define(function (require, exports, module) {
    "use strict";

    var oop = require("../lib/oop");
    var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;

    var GitignoreHighlightRules = function () {
        this.$rules = {
            "start": [
                {
                    token: "comment",
                    regex: /^\s*#.*$/
                }, {
                    token: "keyword", // negated patterns
                    regex: /^\s*!.*$/
                }
            ]
        };

        this.normalizeRules();
    };

    GitignoreHighlightRules.metaData = {
        fileTypes: ['gitignore'],
        name: 'Gitignore'
    };

    oop.inherits(GitignoreHighlightRules, TextHighlightRules);

    exports.GitignoreHighlightRules = GitignoreHighlightRules;
});
