/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.map;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.HashMap;

@Extension(name="create", namespace="map", description="This creates a map between the keys and their corresponding values.", parameters={@Parameter(name="key1", description="key 1", type={DataType.OBJECT}), @Parameter(name="value1", description="Value 1", type={DataType.OBJECT}), @Parameter(name="key2", description="Key 2", type={DataType.OBJECT}), @Parameter(name="value2", description="Value 2", type={DataType.OBJECT})}, returnAttributes={@ReturnAttribute(description="Returns the created map object. ", type={DataType.OBJECT})}, examples={@Example(syntax="create(1 , \u201done\u201d ,  2 , \u201dtwo\u201d , 3 , \u201dthree\u201d)", description="This returns a map with keys 1, 2, 3 mapped with their corresponding values, \"one\", \"two\", \"three\".")})
public class CreateFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.OBJECT;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length % 2 == 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:create() function, required 0 or multiple of 2, but found " + attributeExpressionExecutors.length);
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < data.length; i += 2) {
            map.put(data[i], data[i + 1]);
        }
        return map;
    }

    protected Object execute(Object data, State state) {
        return new HashMap();
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

