/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.map;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.Map;

@Extension(name="isMap", namespace="map", description="This returns 'true' if the object is a map and 'false' if otherwise.", parameters={@Parameter(name="object", description="The object that the function checks to determine whether it's a map or not.", type={DataType.OBJECT}, optional=false)}, returnAttributes={@ReturnAttribute(description="This returns a boolean value based on whether the object specified is a map or not.", type={DataType.BOOL})}, examples={@Example(syntax="isMap(students)", description="This function returns 'true' if the object, students is a map. It returns 'false' if it is not a map.")})
public class IsMapFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.BOOL;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:isMap() function, required only one, but found " + attributeExpressionExecutors.length);
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return null;
    }

    protected Boolean execute(Object data, State state) {
        if (data instanceof Map) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

