/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.map;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.Map;
import org.apache.log4j.Logger;

@Extension(name="remove", namespace="map", description="This returns the updated map after removing the element with the key specified.", parameters={@Parameter(name="map", description="The map that needs to be updated by removing the element.", type={DataType.OBJECT}, optional=false), @Parameter(name="key", description="The key of the element that needs to removed from the map.", type={DataType.OBJECT}, optional=false)}, returnAttributes={@ReturnAttribute(description="return Object will be a HashMap", type={DataType.OBJECT})}, examples={@Example(syntax="remove(students , 1234)", description="This function returns the updated map, students after removing the element with the key 1234.")})
public class RemoveFunctionExtension
extends FunctionExecutor {
    private static final Logger log = Logger.getLogger(RemoveFunctionExtension.class);
    private Attribute.Type returnType = Attribute.Type.OBJECT;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length < 2) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:remove() function, required one or more keys, but found " + attributeExpressionExecutors.length);
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        Map map = (Map)data[0];
        for (int i = 1; i < data.length; ++i) {
            map.remove(data[i]);
        }
        return map;
    }

    protected Object execute(Object data, State state) {
        return null;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

