/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.map;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.Map;
import org.json.JSONObject;

@Extension(name="toJSON", namespace="map", description="This converts a map into a JSON object and returns the definition of that JSON object as a string.", parameters={@Parameter(name="map", description="The map that needs to be converted to JSON", type={DataType.OBJECT}, optional=false)}, returnAttributes={@ReturnAttribute(description="This returns a string representation of the map in JSON format.", type={DataType.STRING})}, examples={@Example(syntax="toJSON(company)", description="If \"company\" is a map with key-value pairs, (\"symbol\" : wso2),(\"volume\" : 100), and (\"price\",200), it returns the string \u201c{\u201csymbol\u201d : \u201cwso2\u201d, \u201cvolume\u201d : 100 , \u201cprice\u201d : 200}\u201d.")})
public class ToJSONFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.STRING;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:toJSON() function, required only 1, but found " + attributeExpressionExecutors.length);
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return null;
    }

    protected Object execute(Object data, State state) {
        if (data instanceof Map) {
            Map map = (Map)data;
            JSONObject jsonObject = new JSONObject(map);
            return jsonObject.toString();
        }
        throw new SiddhiAppRuntimeException("Data should be a string");
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

