/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.map;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.Map;

@Extension(name="toXML", namespace="map", description="This returns the map as an XML string.", parameters={@Parameter(name="map", description="The map that needs to be converted to XML.", type={DataType.OBJECT}, optional=false), @Parameter(name="rootelementname", description="The root element of the map.", type={DataType.OBJECT}, optional=true, defaultValue="null")}, returnAttributes={@ReturnAttribute(description="This returns the string representation of the map in XML format.", type={DataType.STRING})}, examples={@Example(syntax="toXML(company, \"abcCompany\")", description="If \"company\" is a map with key-value pairs, (\u201csymbol\u201d : wso2), (\u201cvolume\u201d : 100), and (\u201cprice\u201d : 200), this function returns the string, \u201c<abcCompany><symbol>wso2</symbol><volume><100></volume><price>200</price></abcCompany>.")})
public class ToXMLFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.STRING;
    private String rootElement = null;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length > 2) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:toXML() function, required only 1 or 2, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors.length == 2) {
            Object rootElementObject = attributeExpressionExecutors[1].execute(null);
            if (rootElementObject instanceof String) {
                this.rootElement = (String)rootElementObject;
            } else {
                throw new OperationNotSupportedException("Root element name should be of type String. But found " + attributeExpressionExecutors[1].getReturnType());
            }
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        if (data[0] instanceof Map) {
            Map map = (Map)data[0];
            return this.getXmlFromMapWithRootElement(map);
        }
        throw new SiddhiAppRuntimeException("Data should be a string");
    }

    protected Object execute(Object data, State state) {
        if (data instanceof Map) {
            Map map = (Map)data;
            return this.getXmlFromMap(map);
        }
        throw new SiddhiAppRuntimeException("Data should be a string");
    }

    private Object getXmlFromMap(Map<Object, Object> map) {
        return this.addingElements(map);
    }

    private Object getXmlFromMapWithRootElement(Map<Object, Object> map) {
        StringBuilder xmlValue = new StringBuilder();
        xmlValue.append("<" + this.rootElement + ">");
        xmlValue.append(this.addingElements(map));
        xmlValue.append("</" + this.rootElement + ">");
        return xmlValue.toString();
    }

    private String addingElements(Map<Object, Object> map) {
        StringBuilder xmlValue = new StringBuilder();
        for (Map.Entry<Object, Object> mapEntry : map.entrySet()) {
            xmlValue.append("<" + mapEntry.getKey().toString() + ">");
            if (mapEntry.getValue() instanceof Map) {
                xmlValue.append(this.getXmlFromMap((Map)mapEntry.getValue()));
            } else {
                xmlValue.append(mapEntry.getValue().toString());
            }
            xmlValue.append("</" + mapEntry.getKey().toString() + ">");
        }
        return xmlValue.toString();
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

