/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.map;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.Map;

@Extension(name="get", namespace="map", description="Function returns the value corresponding to the given key from the map.", parameters={@Parameter(name="map", description="The map from where the value should be obtained.", type={DataType.OBJECT}, dynamic=true), @Parameter(name="key", description="The key to fetch the value.", type={DataType.OBJECT, DataType.INT, DataType.LONG, DataType.FLOAT, DataType.DOUBLE, DataType.FLOAT, DataType.BOOL, DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"map", "key"})}, returnAttributes={@ReturnAttribute(description="Returns the value from the map that corresponds to the given key.", type={DataType.OBJECT})}, examples={@Example(syntax="map:get(companyMap, 1)", description="If the companyMap has key `1` and value `ABC` in it's set of key value pairs. The function returns `ABC`."), @Example(syntax="map:get(companyMap, 2)", description="If the companyMap does not have any value for key `2` then the function returns `null`.")})
public class GetFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.OBJECT;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:get() function, required 2, but found " + attributeExpressionExecutors.length);
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        if (!(data[0] instanceof Map)) {
            throw new SiddhiAppRuntimeException("First attribute value must be of type java.util.Map");
        }
        Map map = (Map)data[0];
        return map.get(data[1]);
    }

    protected Object execute(Object data, State state) {
        return null;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

