/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMConstants;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.OMXMLStreamReader;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMNamespaceImpl;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.builder.XOPAwareStAXOMBuilder;
import org.apache.axiom.om.impl.builder.XOPBuilder;
import org.apache.axiom.om.impl.llom.OMAttributeImpl;
import org.apache.axiom.om.impl.llom.OMContainerHelper;
import org.apache.axiom.om.impl.llom.OMNodeImpl;
import org.apache.axiom.om.impl.llom.factory.OMLinkedListImplFactory;
import org.apache.axiom.om.impl.traverse.OMChildElementIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenLegacyQNameIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenLocalNameIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenNamespaceIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenQNameIterator;
import org.apache.axiom.om.impl.util.EmptyIterator;
import org.apache.axiom.om.impl.util.OMSerializerUtil;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OMElementImpl
extends OMNodeImpl
implements OMElement,
OMConstants,
OMContainerEx {
    private static final Log log = LogFactory.getLog(OMElementImpl.class);
    private static boolean DEBUG_ENABLED = log.isDebugEnabled();
    public static final OMNamespace DEFAULT_DEFAULT_NS_OBJECT = new OMNamespaceImpl("", "");
    protected OMNamespace ns;
    protected String localName;
    protected QName qName;
    protected OMNode firstChild;
    protected HashMap namespaces = null;
    protected HashMap attributes = null;
    protected int noPrefixNamespaceCounter = 0;
    protected OMNode lastChild;
    private int lineNumber;
    private static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();
    static final OMNamespaceImpl xmlns = new OMNamespaceImpl("http://www.w3.org/XML/1998/namespace", "xml");

    public OMElementImpl(String localName, OMNamespace ns, OMContainer parent, OMXMLParserWrapper builder, OMFactory factory) {
        super(parent, factory, false);
        this.localName = localName;
        if (ns != null) {
            this.setNamespace(ns);
        }
        this.builder = builder;
        this.firstChild = null;
    }

    public OMElementImpl(String localName, OMNamespace ns, OMFactory factory) {
        this(localName, ns, null, factory);
    }

    public OMElementImpl(String localName, OMNamespace ns, OMContainer parent, OMFactory factory) {
        super(parent, factory, true);
        if (localName == null || localName.trim().isEmpty()) {
            throw new OMException("localname can not be null or empty");
        }
        this.localName = localName;
        if (ns != null) {
            this.setNamespace(ns);
        }
    }

    public OMElementImpl(QName qname, OMContainer parent, OMFactory factory) throws OMException {
        this(qname.getLocalPart(), null, parent, factory);
        this.ns = this.handleNamespace(qname);
    }

    OMNamespace handleNamespace(QName qname) {
        OMNamespace ns = null;
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI != null && namespaceURI.length() > 0) {
            String prefix = qname.getPrefix();
            ns = this.findNamespace(qname.getNamespaceURI(), prefix);
            if (ns == null) {
                if (prefix.isEmpty()) {
                    prefix = OMSerializerUtil.getNextNSPrefix();
                }
                ns = this.declareNamespace(namespaceURI, prefix);
            }
            if (ns != null) {
                this.ns = ns;
            }
        }
        return ns;
    }

    private OMNamespace handleNamespace(OMNamespace ns) {
        OMNamespace namespace = this.findNamespace(ns.getNamespaceURI(), ns.getPrefix());
        if (namespace == null) {
            namespace = this.declareNamespace(ns);
        }
        return namespace;
    }

    OMNamespace handleNamespace(String namespaceURI, String prefix) {
        OMNamespace namespace = this.findNamespace(namespaceURI, prefix);
        if (namespace == null) {
            namespace = this.declareNamespace(namespaceURI, prefix);
        }
        return namespace;
    }

    @Override
    public void addChild(OMNode child) {
        if (child.getOMFactory() instanceof OMLinkedListImplFactory) {
            this.addChild((OMNodeImpl)child);
        } else {
            this.addChild(this.importNode(child));
        }
    }

    @Override
    public Iterator getChildrenWithName(QName elementQName) {
        OMNode firstChild = this.getFirstOMChild();
        OMChildrenQNameIterator it = new OMChildrenQNameIterator(firstChild, elementQName);
        if (elementQName.getNamespaceURI().isEmpty() && firstChild != null && !it.hasNext()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("There are no child elements that match the unqualifed name: " + elementQName));
                log.trace((Object)"Now looking for child elements that have the same local name.");
            }
            it = new OMChildrenLegacyQNameIterator(this.getFirstOMChild(), elementQName);
        }
        return it;
    }

    @Override
    public Iterator getChildrenWithLocalName(String localName) {
        return new OMChildrenLocalNameIterator(this.getFirstOMChild(), localName);
    }

    @Override
    public Iterator getChildrenWithNamespaceURI(String uri) {
        return new OMChildrenNamespaceIterator(this.getFirstOMChild(), uri);
    }

    @Override
    public OMElement getFirstChildWithName(QName elementQName) throws OMException {
        OMChildrenQNameIterator omChildrenQNameIterator = new OMChildrenQNameIterator(this.getFirstOMChild(), elementQName);
        OMNode omNode = null;
        if (omChildrenQNameIterator.hasNext()) {
            omNode = (OMNode)omChildrenQNameIterator.next();
        }
        return omNode != null && 1 == omNode.getType() ? (OMElement)omNode : null;
    }

    private void addChild(OMNodeImpl child) {
        if (child.parent != this || child != this.lastChild) {
            child.setParent(this);
            if (this.firstChild == null) {
                this.firstChild = child;
                child.previousSibling = null;
            } else {
                child.previousSibling = (OMNodeImpl)this.lastChild;
                ((OMNodeImpl)this.lastChild).nextSibling = child;
            }
            child.nextSibling = null;
            this.lastChild = child;
        }
        if (!child.isComplete() && !(child instanceof OMSourcedElement)) {
            this.setComplete(false);
        }
    }

    @Override
    public OMNode getNextOMSibling() throws OMException {
        while (!this.done && this.builder != null) {
            if (this.builder.isCompleted()) {
                if (DEBUG_ENABLED) {
                    log.debug((Object)"Builder is complete.  Setting OMElement to complete.");
                }
                this.setComplete(true);
                continue;
            }
            int token = this.builder.next();
            if (token != 8) continue;
            throw new OMException("Parser has already reached end of the document. No siblings found");
        }
        return super.getNextOMSibling();
    }

    @Override
    public Iterator getChildren() {
        return new OMChildrenIterator(this.getFirstOMChild());
    }

    @Override
    public Iterator getChildElements() {
        return new OMChildElementIterator(this.getFirstElement());
    }

    @Override
    public OMNamespace declareNamespace(String uri, String prefix) {
        if (prefix != null && prefix.isEmpty()) {
            prefix = OMSerializerUtil.getNextNSPrefix();
        }
        OMNamespaceImpl ns = new OMNamespaceImpl(uri, prefix);
        return this.declareNamespace(ns);
    }

    @Override
    public OMNamespace declareDefaultNamespace(String uri) {
        OMNamespaceImpl namespace = new OMNamespaceImpl(uri == null ? "" : uri, "");
        if (this.namespaces == null) {
            this.namespaces = new HashMap(5);
        }
        this.namespaces.put("", namespace);
        if (this.ns == null || this.ns.getPrefix() == null || this.ns.getPrefix().isEmpty()) {
            this.ns = namespace;
            this.qName = null;
        }
        return namespace;
    }

    @Override
    public OMNamespace getDefaultNamespace() {
        OMNamespace defaultNS;
        if (this.namespaces != null && (defaultNS = (OMNamespace)this.namespaces.get("")) != null) {
            return defaultNS;
        }
        if (this.parent instanceof OMElementImpl) {
            return ((OMElementImpl)this.parent).getDefaultNamespace();
        }
        return null;
    }

    @Override
    public OMNamespace declareNamespace(OMNamespace namespace) {
        String prefix;
        if (this.namespaces == null) {
            this.namespaces = new HashMap(5);
        }
        if ((prefix = namespace.getPrefix()) == null) {
            prefix = OMSerializerUtil.getNextNSPrefix();
            namespace = new OMNamespaceImpl(namespace.getNamespaceURI(), prefix);
        }
        this.namespaces.put(prefix, namespace);
        return namespace;
    }

    @Override
    public OMNamespace findNamespace(String uri, String prefix) {
        OMNamespace namespace = this.findDeclaredNamespace(uri, prefix);
        if (namespace != null) {
            return namespace;
        }
        if (this.parent != null && this.parent instanceof OMElement) {
            namespace = ((OMElementImpl)this.parent).findNamespace(uri, prefix);
        }
        return namespace;
    }

    @Override
    public OMNamespace findNamespaceURI(String prefix) {
        OMNamespace ns;
        OMNamespace oMNamespace = ns = this.namespaces == null ? null : (OMNamespace)this.namespaces.get(prefix);
        if (ns == null && this.parent instanceof OMElement) {
            ns = ((OMElement)((Object)this.parent)).findNamespaceURI(prefix);
        }
        return ns;
    }

    private OMNamespace findDeclaredNamespace(String uri, String prefix) {
        if (uri == null) {
            return this.namespaces == null ? null : (OMNamespace)this.namespaces.get(prefix);
        }
        if (prefix != null && prefix.equals("xml") && uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return xmlns;
        }
        if (this.namespaces == null) {
            return null;
        }
        if (prefix == null || prefix.isEmpty()) {
            OMNamespace defaultNamespace = this.getDefaultNamespace();
            if (defaultNamespace != null && uri.equals(defaultNamespace.getNamespaceURI())) {
                return defaultNamespace;
            }
            for (OMNamespace omNamespace : this.namespaces.values()) {
                String nsUri = omNamespace.getNamespaceURI();
                if (nsUri == null || !nsUri.equals(uri)) continue;
                return omNamespace;
            }
        } else {
            OMNamespace namespace = (OMNamespace)this.namespaces.get(prefix);
            if (namespace != null && uri.equals(namespace.getNamespaceURI())) {
                return namespace;
            }
        }
        return null;
    }

    @Override
    public Iterator getAllDeclaredNamespaces() {
        if (this.namespaces == null) {
            return EMPTY_ITERATOR;
        }
        return this.namespaces.values().iterator();
    }

    @Override
    public Iterator getAllAttributes() {
        if (this.attributes == null) {
            return EMPTY_ITERATOR;
        }
        return this.attributes.values().iterator();
    }

    @Override
    public OMAttribute getAttribute(QName qname) {
        return this.attributes == null ? null : (OMAttribute)this.attributes.get(qname);
    }

    @Override
    public String getAttributeValue(QName qname) {
        OMAttribute attr = this.getAttribute(qname);
        return attr == null ? null : attr.getAttributeValue();
    }

    @Override
    public OMAttribute addAttribute(OMAttribute attr) {
        String prefix;
        OMNamespace ns2;
        String uri;
        OMNamespace namespace;
        OMElement owner = attr.getOwner();
        if (owner != null) {
            if (owner == this) {
                return attr;
            }
            attr = new OMAttributeImpl(attr.getLocalName(), attr.getNamespace(), attr.getAttributeValue(), attr.getOMFactory());
        }
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap(5);
        }
        if (!((namespace = attr.getNamespace()) == null || (uri = namespace.getNamespaceURI()).length() <= 0 || (ns2 = this.findNamespaceURI(prefix = namespace.getPrefix())) != null && uri.equals(ns2.getNamespaceURI()))) {
            this.declareNamespace(uri, prefix);
        }
        ((OMAttributeImpl)attr).owner = this;
        OMAttributeImpl oldAttr = (OMAttributeImpl)this.attributes.put(attr.getQName(), attr);
        if (oldAttr != null) {
            oldAttr.owner = null;
        }
        return attr;
    }

    @Override
    public void removeAttribute(OMAttribute attr) {
        if (this.attributes != null) {
            ((OMAttributeImpl)attr).owner = null;
            this.attributes.remove(attr.getQName());
        }
    }

    @Override
    public OMAttribute addAttribute(String attributeName, String value, OMNamespace ns) {
        String prefix;
        String namespaceURI;
        OMNamespace namespace = null;
        if (ns != null && (namespace = this.findNamespace(namespaceURI = ns.getNamespaceURI(), prefix = ns.getPrefix())) == null) {
            namespace = new OMNamespaceImpl(namespaceURI, prefix);
        }
        return this.addAttribute(new OMAttributeImpl(attributeName, namespace, value, this.factory));
    }

    @Override
    public void setBuilder(OMXMLParserWrapper wrapper) {
        this.builder = wrapper;
    }

    @Override
    public OMXMLParserWrapper getBuilder() {
        return this.builder;
    }

    @Override
    public void buildNext() {
        if (this.builder != null) {
            if (!this.builder.isCompleted()) {
                this.builder.next();
            } else {
                this.setComplete(true);
                if (DEBUG_ENABLED) {
                    log.debug((Object)"Builder is complete.  Setting OMElement to complete.");
                }
            }
        }
    }

    @Override
    public OMNode getFirstOMChild() {
        while (this.firstChild == null && !this.done) {
            this.buildNext();
        }
        return this.firstChild;
    }

    @Override
    public OMNode getFirstOMChildIfAvailable() {
        return this.firstChild;
    }

    @Override
    public void setFirstChild(OMNode firstChild) {
        if (firstChild != null) {
            ((OMNodeEx)firstChild).setParent(this);
        }
        this.firstChild = firstChild;
    }

    @Override
    public void setLastChild(OMNode omNode) {
        this.lastChild = omNode;
    }

    @Override
    public OMNode detach() throws OMException {
        if (!this.done) {
            this.build();
        }
        super.detach();
        return this;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void build() throws OMException {
        if (this.builder == null && !this.done) {
            Iterator childrenIterator = this.getChildren();
            while (childrenIterator.hasNext()) {
                OMNode omNode = (OMNode)childrenIterator.next();
                omNode.build();
            }
        } else {
            super.build();
        }
    }

    @Override
    public XMLStreamReader getXMLStreamReader() {
        return this.getXMLStreamReader(true);
    }

    @Override
    public XMLStreamReader getXMLStreamReaderWithoutCaching() {
        return this.getXMLStreamReader(false);
    }

    @Override
    public XMLStreamReader getXMLStreamReader(boolean cache) {
        return OMContainerHelper.getXMLStreamReader(this, cache);
    }

    @Override
    public void setText(String text) {
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            if (child.getType() != 4) continue;
            child.detach();
        }
        OMAbstractFactory.getOMFactory().createOMText((OMContainer)this, text);
    }

    @Override
    public void setText(QName text) {
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            if (child.getType() != 4) continue;
            child.detach();
        }
        OMAbstractFactory.getOMFactory().createOMText((OMContainer)this, text);
    }

    @Override
    public String getText() {
        String childText = null;
        StringBuffer buffer = null;
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            OMText textNode;
            String textValue;
            int type = child.getType();
            if (type != 4 && type != 12 || (textValue = (textNode = (OMText)child).getText()) == null || textValue.length() == 0) continue;
            if (childText == null) {
                childText = textValue;
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuffer(childText);
            }
            buffer.append(textValue);
        }
        if (childText == null) {
            return "";
        }
        if (buffer != null) {
            return buffer.toString();
        }
        return childText;
    }

    @Override
    public QName getTextAsQName() {
        String childText = this.getTrimmedText();
        if (childText != null) {
            return this.resolveQName(childText);
        }
        return null;
    }

    public String getTrimmedText() {
        String childText = null;
        StringBuffer buffer = null;
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            OMText textNode;
            String textValue;
            if (child.getType() != 4 || (textValue = (textNode = (OMText)child).getText()) == null || textValue.length() == 0) continue;
            if (childText == null) {
                childText = textValue.trim();
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuffer(childText);
            }
            buffer.append(textValue.trim());
        }
        if (childText == null) {
            return "";
        }
        if (buffer != null) {
            return buffer.toString();
        }
        return childText;
    }

    @Override
    public void internalSerialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        if (cache || this.done || this.builder == null) {
            OMSerializerUtil.serializeStartpart(this, writer);
            OMSerializerUtil.serializeChildren(this, writer, cache);
            OMSerializerUtil.serializeEndpart(writer);
        } else {
            OMSerializerUtil.serializeByPullStream(this, writer, cache);
        }
    }

    @Override
    public OMElement getFirstElement() {
        for (OMNode node = this.getFirstOMChild(); node != null; node = node.getNextOMSibling()) {
            if (node.getType() != 1) continue;
            return (OMElement)node;
        }
        return null;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public void setLocalName(String localName) {
        this.localName = localName;
        this.qName = null;
    }

    @Override
    public OMNamespace getNamespace() {
        OMNamespace parentDefaultNS;
        if (this.ns == null && (parentDefaultNS = this.findNamespaceURI("")) != null && !"".equals(parentDefaultNS.getNamespaceURI())) {
            this.ns = DEFAULT_DEFAULT_NS_OBJECT;
            this.qName = null;
        }
        return this.ns;
    }

    @Override
    public void setNamespace(OMNamespace namespace) {
        OMNamespace nsObject = null;
        if (namespace != null) {
            nsObject = this.handleNamespace(namespace);
        }
        this.ns = nsObject;
        this.qName = null;
    }

    @Override
    public void setNamespaceWithNoFindInCurrentScope(OMNamespace namespace) {
        this.ns = namespace;
        this.qName = null;
    }

    @Override
    public QName getQName() {
        if (this.qName != null) {
            return this.qName;
        }
        this.qName = this.ns != null ? (this.ns.getPrefix() != null ? new QName(this.ns.getNamespaceURI(), this.localName, this.ns.getPrefix()) : new QName(this.ns.getNamespaceURI(), this.localName)) : new QName(this.localName);
        return this.qName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toStringWithConsume() throws XMLStreamException {
        StringWriter writer = new StringWriter();
        try (XMLStreamWriter writer2 = StAXUtils.createXMLStreamWriter(writer);){
            this.serializeAndConsume(writer2);
            writer2.flush();
        }
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        try (XMLStreamWriter writer2 = StAXUtils.createXMLStreamWriter(writer);){
            this.serialize(writer2);
            writer2.flush();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Can not serialize OM Element " + this.getLocalName(), e);
        }
        return writer.toString();
    }

    @Override
    public void discard() throws OMException {
        if (this.done || this.builder == null) {
            this.detach();
        } else {
            this.builder.discard(this);
        }
    }

    @Override
    public QName resolveQName(String qname) {
        ElementHelper helper = new ElementHelper(this);
        return helper.resolveQName(qname);
    }

    @Override
    public OMElement cloneOMElement() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"cloneOMElement start");
            log.debug((Object)("  element string =" + this.getLocalName()));
            log.debug((Object)(" isComplete = " + this.isComplete()));
            log.debug((Object)("  builder = " + this.builder));
        }
        if (!this.isComplete()) {
            this.build();
        }
        XMLStreamReader xmlStreamReader = this.getXMLStreamReader(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("  reader = " + xmlStreamReader));
        }
        StAXOMBuilder newBuilder = null;
        if (this.builder instanceof XOPBuilder) {
            Attachments attachments = ((XOPBuilder)((Object)this.builder)).getAttachments();
            attachments.getAllContentIDs();
            if (xmlStreamReader instanceof OMXMLStreamReader) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  read optimized xop:include");
                }
                ((OMXMLStreamReader)xmlStreamReader).setInlineMTOM(false);
            }
            newBuilder = new XOPAwareStAXOMBuilder(xmlStreamReader, attachments);
        } else {
            newBuilder = new StAXOMBuilder(xmlStreamReader);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("  newBuilder = " + newBuilder));
        }
        OMElement clonedElement = newBuilder.getDocumentElement();
        clonedElement.build();
        return clonedElement;
    }

    @Override
    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void buildWithAttachments() {
        if (!this.done) {
            this.build();
        }
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            OMNode node = (OMNode)iterator.next();
            node.buildWithAttachments();
        }
    }

    protected void notifyChildComplete() {
        if (!this.done && this.builder == null) {
            Iterator iterator = this.getChildren();
            while (iterator.hasNext()) {
                OMNode node = (OMNode)iterator.next();
                if (node.isComplete()) continue;
                return;
            }
            this.setComplete(true);
        }
    }
}

