/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.map;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import java.util.Map;

@Extension(name="clear", namespace="map", description="Function returns the cleared map. ", parameters={@Parameter(name="map", description="The map which needs to be cleared", type={DataType.OBJECT}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"map"})}, returnAttributes={@ReturnAttribute(description="Returns the cleared map.", type={DataType.OBJECT})}, examples={@Example(syntax="map:clear(stockDetails)", description="Returns an empty map.")})
public class ClearFunctionExtension
extends FunctionExecutor<State> {
    private Attribute.Type returnType = Attribute.Type.OBJECT;

    protected StateFactory<State> init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return null;
    }

    protected Object execute(Object data, State state) {
        if (data instanceof Map) {
            Map hashMap = (Map)data;
            hashMap.clear();
            return hashMap;
        }
        throw new SiddhiAppRuntimeException("First attribute value must be of type java.util.Map, but found '" + data.getClass().getCanonicalName() + "'");
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

