/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.map;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregatorExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.extension.execution.map.MapState;
import io.siddhi.query.api.definition.Attribute;
import java.util.HashMap;

@Extension(namespace="map", name="collect", description="Collect multiple key-value pairs to construct a map. Only distinct keys are collected, if a duplicate key arrives, it overrides the old value", parameters={@Parameter(name="key", description="Key of the map entry", type={DataType.INT, DataType.LONG, DataType.FLOAT, DataType.DOUBLE, DataType.FLOAT, DataType.BOOL, DataType.STRING}, dynamic=true), @Parameter(name="value", description="Value of the map entry", type={DataType.OBJECT, DataType.INT, DataType.LONG, DataType.FLOAT, DataType.DOUBLE, DataType.BOOL, DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"key", "value"})}, returnAttributes={@ReturnAttribute(description="Map containing all the key-value pairs.", type={DataType.OBJECT})}, examples={@Example(syntax="from StockStream#window.lengthBatch(10)\nselect map:collect(symbol, price) as stockDetails\ninsert into OutputStream;", description="For the window expiry of 10 events, the collect() function will collect attributes of `key` and `value` to a single map and return as stockDetails.")})
public class CollectAggregateFunction
extends AttributeAggregatorExecutor<State> {
    private static final long serialVersionUID = 1L;

    protected StateFactory<State> init(ExpressionExecutor[] expressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        return MapState::new;
    }

    public Object processAdd(Object object, State state) {
        return null;
    }

    public Object processAdd(Object[] objects, State state) {
        ((MapState)state).addEntry(objects[0], objects[1]);
        return ((MapState)state).getDataMapClone();
    }

    public Object processRemove(Object object, State state) {
        return null;
    }

    public Object processRemove(Object[] objects, State state) {
        ((MapState)state).removeEntry(objects[0]);
        return ((MapState)state).getDataMapClone();
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.OBJECT;
    }

    public Object reset(State state) {
        ((MapState)state).setDataMap(new HashMap<Object, Object>());
        return ((MapState)state).getDataMapClone();
    }
}

