/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.map;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import java.util.Map;

@Extension(name="isEmpty", namespace="map", description="Function checks if the map is empty.", parameters={@Parameter(name="map", description="The map the need to be checked whether it's empty or not.", type={DataType.OBJECT}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"map"})}, returnAttributes={@ReturnAttribute(description="Returns `true` if the map is empty and `false` if otherwise.", type={DataType.BOOL})}, examples={@Example(syntax="map:isEmpty(stockDetails)", description="Returns 'true' if the stockDetails map is empty else it returns `false`.")})
public class IsEmptyFunctionExtension
extends FunctionExecutor<State> {
    private Attribute.Type returnType = Attribute.Type.BOOL;
    private static final long serialVersionUID = 1L;

    protected StateFactory<State> init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return null;
    }

    protected Boolean execute(Object data, State state) {
        if (data instanceof Map) {
            return ((Map)data).isEmpty();
        }
        throw new SiddhiAppRuntimeException("First attribute value must be of type java.util.Map, but found '" + data.getClass().getCanonicalName() + "'.");
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

