/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.map;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.Map;

@Extension(name="isMap", namespace="map", description="Function checks if the object is type of a map.", parameters={@Parameter(name="arg", description="The argument the need to be determined whether it's a map or not.", type={DataType.OBJECT, DataType.INT, DataType.LONG, DataType.FLOAT, DataType.DOUBLE, DataType.FLOAT, DataType.BOOL, DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"arg"})}, returnAttributes={@ReturnAttribute(description="Returns `true` if the arg is a map (`java.util.Map`) and `false` if otherwise.", type={DataType.BOOL})}, examples={@Example(syntax="map:isMap(stockDetails)", description="Returns 'true' if the stockDetails is and an instance of `java.util.Map` else it returns `false`.")})
public class IsMapFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.BOOL;
    private static final long serialVersionUID = 1L;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to map:isMap() function, required only one, but found " + attributeExpressionExecutors.length);
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return null;
    }

    protected Boolean execute(Object data, State state) {
        if (data instanceof Map) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

