/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.regex;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

@Extension(name="lookingAt", namespace="regex", description="Match the input.sequence from the beginning against the regex pattern, and unlike `regex:matches() it does not require that the entire input.sequence be matched.`", parameters={@Parameter(name="regex", description="A regular expression. For example, `\\d\\d(.*)WSO2`.", type={DataType.STRING}, dynamic=true), @Parameter(name="input.sequence", description="The input sequence to be matched with the regular expression. For example, `21 products are produced by WSO2`.", type={DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"regex", "input.sequence"})}, returnAttributes={@ReturnAttribute(description="Returns `true` if a matching subsequence is available in the beginning of the input.sequence, else return `false`.", type={DataType.BOOL})}, examples={@Example(syntax="regex:lookingAt('\\d\\d(.*)(WSO2.*)', '21 products are produced by WSO2 currently in Sri Lanka')", description="Function matches the input.sequence against the regex pattern, `\\d\\d(.*)(WSO2.*)` from the beginning, and as it matches it returns `true`."), @Example(syntax="regex:lookingAt('WSO2(.*)middleware(.*)', 'sample test string and WSO2 is situated in trace and it's a middleware company')", description="Function matches the input.sequence against the regex pattern, `WSO2(.*)middleware(.*)` from the beginning, and as it does not match it returns `false`.")})
public class LookingAtFunctionExtension
extends FunctionExecutor<ExtensionState> {
    private Attribute.Type returnType = Attribute.Type.BOOL;
    private static final Logger log = Logger.getLogger(LookingAtFunctionExtension.class);

    protected StateFactory<ExtensionState> init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to regex:lookingAt() function, required 2, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for the first argument of regex:lookingAt() function, required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[0].getReturnType().toString());
        }
        if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for the second argument of regex:lookingAt() function, required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[1].getReturnType().toString());
        }
        if (attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor) {
            String regexConstant = (String)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
            Pattern patternConstant = Pattern.compile(regexConstant);
            return () -> new ExtensionState(true, regexConstant, patternConstant);
        }
        return () -> new ExtensionState(false, null, null);
    }

    protected Object execute(Object[] data, ExtensionState extensionState) {
        if (data[0] == null) {
            throw new SiddhiAppRuntimeException("Invalid input given to regex:lookingAt() function. First argument cannot be null");
        }
        if (data[1] == null) {
            if (log.isDebugEnabled()) {
                log.warn((Object)"Invalid input given to regex:lookingAt() function. Second argument cannot be null, returning false");
            }
            return false;
        }
        String source = (String)data[1];
        if (!extensionState.isRegexConstant) {
            String regex = (String)data[0];
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(source);
            return matcher.lookingAt();
        }
        Matcher matcher = extensionState.patternConstant.matcher(source);
        return matcher.lookingAt();
    }

    protected Object execute(Object o, ExtensionState extensionState) {
        return null;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    static class ExtensionState
    extends State {
        private boolean isRegexConstant;
        private String regexConstant;
        private Pattern patternConstant;

        private ExtensionState(boolean isRegexConstant, String regexConstant, Pattern patternConstant) {
            this.isRegexConstant = isRegexConstant;
            this.regexConstant = regexConstant;
            this.patternConstant = patternConstant;
        }

        public boolean canDestroy() {
            return false;
        }

        public Map<String, Object> snapshot() {
            HashMap<String, Object> stateMap = new HashMap<String, Object>(3);
            stateMap.put("isRegexConstant", this.isRegexConstant);
            stateMap.put("regexConstant", this.regexConstant);
            stateMap.put("patternConstant", this.patternConstant);
            return stateMap;
        }

        public void restore(Map<String, Object> state) {
            this.isRegexConstant = (Boolean)state.get("isRegexConstant");
            this.regexConstant = (String)state.get("regexConstant");
            this.patternConstant = (Pattern)state.get("patternConstant");
        }
    }
}

