/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.regex;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

@Extension(name="find", namespace="regex", description="Finds the subsequence that matches the given regex pattern.", parameters={@Parameter(name="regex", description="A regular expression that is matched to a sequence in order to find the subsequence of the same. For example, `\\d\\d(.*)WSO2`.", type={DataType.STRING}, dynamic=true), @Parameter(name="input.sequence", description="The input sequence to be matched with the regular expression. For example, `21 products are produced by WSO2`.", type={DataType.STRING}, dynamic=true), @Parameter(name="starting.index", description="The starting index of the input sequence from where the input sequence ismatched with the given regex pattern.For example, `10`.", type={DataType.INT}, optional=true, dynamic=true, defaultValue="0")}, parameterOverloads={@ParameterOverload(parameterNames={"regex", "input.sequence"}), @ParameterOverload(parameterNames={"regex", "input.sequence", "starting.index"})}, returnAttributes={@ReturnAttribute(description="Returns `true` if a matching subsequence is available in the input.sequence, else return `false`.", type={DataType.BOOL})}, examples={@Example(syntax="regex:find('\\d\\d(.*)WSO2', '21 products are produced by WSO2 currently')", description="This method attempts to find the subsequence of the input.sequence that matches the regex pattern, `\\d\\d(.*)WSO2`. It returns `true` as a subsequence exists."), @Example(syntax="regex:find('\\d\\d(.*)WSO2', '21 products are produced by WSO2.', 4)", description="This method attempts to find the subsequence of the input.sequence that matches the regex pattern, `\\d\\d(.*)WSO2` starting from index `4`. It returns 'false' as subsequence does not exists.")})
public class FindFunctionExtension
extends FunctionExecutor<ExtensionState> {
    private static final Logger log = Logger.getLogger(FindFunctionExtension.class);
    private Attribute.Type returnType = Attribute.Type.BOOL;

    protected StateFactory<ExtensionState> init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 2 && attributeExpressionExecutors.length != 3) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to regex:find() function, required 2 or 3, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for the first argument of regex:find() function, required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[0].getReturnType().toString());
        }
        if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for the second argument of regex:find() function, required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[1].getReturnType().toString());
        }
        if (attributeExpressionExecutors.length == 3 && attributeExpressionExecutors[2].getReturnType() != Attribute.Type.INT) {
            throw new SiddhiAppValidationException("Invalid parameter type found for the third argument of str:find() function, required " + Attribute.Type.INT + ", but found " + attributeExpressionExecutors[1].getReturnType().toString());
        }
        if (attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor) {
            String regexConstant = (String)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
            Pattern patternConstant = Pattern.compile(regexConstant);
            return () -> new ExtensionState(true, regexConstant, patternConstant);
        }
        return () -> new ExtensionState(false, null, null);
    }

    protected Object execute(Object[] data, ExtensionState extensionState) {
        int startingIndex;
        Matcher matcher;
        if (data[0] == null) {
            throw new SiddhiAppRuntimeException("Invalid input given to regex:find() function. First argument cannot be null");
        }
        if (data[1] == null) {
            if (log.isDebugEnabled()) {
                log.warn((Object)"Invalid input given to regex:find() function. Second argument cannot be null, returning false");
            }
            return false;
        }
        String source = (String)data[1];
        if (!extensionState.isRegexConstant) {
            String regex = (String)data[0];
            Pattern pattern = Pattern.compile(regex);
            matcher = pattern.matcher(source);
        } else {
            matcher = extensionState.patternConstant.matcher(source);
        }
        if (data.length == 2) {
            return matcher.find();
        }
        if (data[2] == null) {
            if (log.isDebugEnabled()) {
                log.warn((Object)"Invalid input given to regex:find() function. Second argument cannot be null, returning false");
            }
            return false;
        }
        try {
            startingIndex = (Integer)data[2];
        }
        catch (ClassCastException ex) {
            throw new SiddhiAppRuntimeException("Invalid input given to regex:group() function. Third argument should be an integer");
        }
        return matcher.find(startingIndex);
    }

    protected Object execute(Object o, ExtensionState extensionState) {
        return null;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    static class ExtensionState
    extends State {
        private boolean isRegexConstant;
        private String regexConstant;
        private Pattern patternConstant;

        private ExtensionState(boolean isRegexConstant, String regexConstant, Pattern patternConstant) {
            this.isRegexConstant = isRegexConstant;
            this.regexConstant = regexConstant;
            this.patternConstant = patternConstant;
        }

        public boolean canDestroy() {
            return false;
        }

        public Map<String, Object> snapshot() {
            HashMap<String, Object> stateMap = new HashMap<String, Object>(3);
            stateMap.put("isRegexConstant", this.isRegexConstant);
            stateMap.put("regexConstant", this.regexConstant);
            stateMap.put("patternConstant", this.patternConstant);
            return stateMap;
        }

        public void restore(Map<String, Object> state) {
            this.isRegexConstant = (Boolean)state.get("isRegexConstant");
            this.regexConstant = (String)state.get("regexConstant");
            this.patternConstant = (Pattern)state.get("patternConstant");
        }
    }
}

