/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.regex;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Extension(name="matches", namespace="regex", description="Matches the entire input.sequence against the regex pattern.", parameters={@Parameter(name="regex", description="A regular expression. For example, `\\d\\d(.*)WSO2`.", type={DataType.STRING}, dynamic=true), @Parameter(name="input.sequence", description="The input sequence to be matched with the regular expression. For example, `21 products are produced by WSO2`.", type={DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"regex", "input.sequence"})}, returnAttributes={@ReturnAttribute(description="Returns `true` if the regex matches the entire input.sequence, else return `false`.", type={DataType.BOOL})}, examples={@Example(syntax="regex:matches('WSO2(.*)middleware(.*)', 'WSO2 is situated in trace and its a middleware company')", description="Function matches the entire input.sequence against `WSO2(.*)middleware(.*)` regex pattern, and as it matches it returns `true`."), @Example(syntax="regex:matches('WSO2(.*)middleware', 'WSO2 is situated in trace and its a middleware company')", description="Function matches the entire input.sequence against `WSO2(.*)middleware` regex pattern. As it does not match it returns `false`.")})
public class MatchesFunctionExtension
extends FunctionExecutor<ExtensionState> {
    private Attribute.Type returnType = Attribute.Type.BOOL;
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(MatchesFunctionExtension.class);

    protected StateFactory<ExtensionState> init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to regex:matches() function, required 2, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for the first argument of regex:matches() function, required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[0].getReturnType().toString());
        }
        if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for the second argument of regex:matches() function, required " + Attribute.Type.STRING + ", but found " + attributeExpressionExecutors[1].getReturnType().toString());
        }
        if (attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor) {
            String regexConstant = (String)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
            Pattern patternConstant = Pattern.compile(regexConstant);
            return () -> new ExtensionState(true, regexConstant, patternConstant);
        }
        return () -> new ExtensionState(false, null, null);
    }

    protected Object execute(Object[] data, ExtensionState extensionState) {
        if (data[0] == null) {
            throw new SiddhiAppRuntimeException("Invalid input given to regex:matches() function. First argument cannot be null");
        }
        if (data[1] == null) {
            if (log.isDebugEnabled()) {
                log.warn("Invalid input given to regex:matches() function. Second argument cannot be null, returning false");
            }
            return false;
        }
        String source = (String)data[1];
        if (!extensionState.isRegexConstant) {
            String regex = (String)data[0];
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(source);
            return matcher.matches();
        }
        Matcher matcher = extensionState.patternConstant.matcher(source);
        return matcher.matches();
    }

    protected Object execute(Object o, ExtensionState extensionState) {
        return null;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    static class ExtensionState
    extends State {
        private boolean isRegexConstant;
        private String regexConstant;
        private Pattern patternConstant;

        private ExtensionState(boolean isRegexConstant, String regexConstant, Pattern patternConstant) {
            this.isRegexConstant = isRegexConstant;
            this.regexConstant = regexConstant;
            this.patternConstant = patternConstant;
        }

        public boolean canDestroy() {
            return false;
        }

        public Map<String, Object> snapshot() {
            HashMap<String, Object> stateMap = new HashMap<String, Object>(3);
            stateMap.put("isRegexConstant", this.isRegexConstant);
            stateMap.put("regexConstant", this.regexConstant);
            stateMap.put("patternConstant", this.patternConstant);
            return stateMap;
        }

        public void restore(Map<String, Object> state) {
            this.isRegexConstant = (Boolean)state.get("isRegexConstant");
            this.regexConstant = (String)state.get("regexConstant");
            this.patternConstant = (Pattern)state.get("patternConstant");
        }
    }
}

