/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.string;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="coalesce", namespace="str", description=" This returns the first input parameter value of the given argument, that is not null.", parameters={@Parameter(name="arg", description="It can have one or more input parameters in any data type. However, all the specified parameters are required to be of the same type.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL, DataType.OBJECT}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"arg", "..."})}, returnAttributes={@ReturnAttribute(description="This holds the first input parameter that is not null.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING, DataType.BOOL, DataType.OBJECT})}, examples={@Example(syntax="coalesce(null, \"BBB\", \"CCC\")", description="This returns the first input parameter that is not null. In this example, it returns \"BBB\".")})
public class CoalesceFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType;

    protected StateFactory<State> init(ExpressionExecutor[] expressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        int executorsCount = expressionExecutors.length;
        if (executorsCount == 0) {
            throw new SiddhiAppValidationException("str:coalesce() function requires at least one argument, but found only " + executorsCount);
        }
        Attribute.Type expectedType = expressionExecutors[0].getReturnType();
        for (ExpressionExecutor expressionExecutor : expressionExecutors) {
            Attribute.Type type = expressionExecutor.getReturnType();
            if (type == expectedType) continue;
            throw new SiddhiAppValidationException("Invalid parameter type found for the " + executorsCount + "'th argument of str:coalesce() function, required " + type + ", but found " + type.toString());
        }
        this.returnType = expectedType;
        return null;
    }

    protected Object execute(Object[] objects, State state) {
        for (Object o : objects) {
            if (o == null) continue;
            return o;
        }
        return null;
    }

    protected Object execute(Object o, State state) {
        return null;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

