/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.string;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="concat", namespace="str", description="This function returns a string value that is obtained as a result of concatenating two or more input string values.", parameters={@Parameter(name="arg", description="This can have two or more STRING, DOUBLE, BOOL, FLOAT, INT, LONG typed input parameters.", type={DataType.STRING, DataType.DOUBLE, DataType.BOOL, DataType.FLOAT, DataType.INT, DataType.LONG}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"arg", "..."})}, returnAttributes={@ReturnAttribute(description="This is the string that is returned on concatenating the given input arguments.", type={DataType.STRING})}, examples={@Example(syntax="concat(\"D533\", \"8JU^\", \"XYZ\")", description="This returns a string value by concatenating two or more given arguments. In the example shown above, it returns \"D5338JU^XYZ\".")})
public class ConcatFunctionExtension
extends FunctionExecutor {
    protected StateFactory<State> init(ExpressionExecutor[] expressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        int executorsCount = expressionExecutors.length;
        if (executorsCount < 2) {
            throw new SiddhiAppValidationException("str:concat() function requires at least two arguments, but found only " + executorsCount);
        }
        return null;
    }

    protected Object execute(Object[] objects, State state) {
        StringBuilder builder = new StringBuilder();
        for (Object o : objects) {
            if (o == null) continue;
            builder.append(o);
        }
        return builder.toString();
    }

    protected Object execute(Object o, State state) {
        return o;
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.STRING;
    }
}

