/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.string;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;

@Extension(name="locate", namespace="str", description="This function returns the position of one string within another. Optionally, the user can give the starting index to be search from.", parameters={@Parameter(name="string.to.search.for", description="The string to be searched for. eg: @wso2.com", type={DataType.STRING}, dynamic=true), @Parameter(name="string.to.search.in", description="The string to be searched in. eg: john@wso2.com", type={DataType.STRING}, dynamic=true), @Parameter(name="searching.start.position", description="The character position in the string to begin the search.", type={DataType.INT}, optional=true, defaultValue="0", dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"string.to.search.for", "string.to.search.in"}), @ParameterOverload(parameterNames={"string.to.search.for", "string.to.search.in", "searching.start.position"})}, returnAttributes={@ReturnAttribute(description="This returns an index value of the starting position of the searched string in the given string.", type={DataType.INT})}, examples={@Example(syntax="define stream inputStream (str string);\n@info(name = 'query1')\nfrom inputStream#str:locate(str , '@wso2.com')\nselect indexNo\ninsert into outputStream;", description="This query searches the starting index of '@wso2.com' in str. If the str is \"streamin@wso2.com\", then the function will return 8.")})
public class LocateFunctionExtension
extends FunctionExecutor {
    private Attribute.Type returnType = Attribute.Type.INT;

    protected StateFactory<State> init(ExpressionExecutor[] expressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        int executorsCount = expressionExecutors.length;
        switch (executorsCount) {
            case 3: {
                ExpressionExecutor executor3 = expressionExecutors[2];
                if (this.isType(executor3, Attribute.Type.INT)) break;
                throw new SiddhiAppCreationException("Third attribute 'searching.start.position' should be of type int. But found " + executor3.getReturnType());
            }
            case 2: {
                ExpressionExecutor executor1 = expressionExecutors[0];
                ExpressionExecutor executor2 = expressionExecutors[1];
                if (executor1 == null || executor2 == null) {
                    throw new SiddhiAppRuntimeException("Invalid input given to str:locate() function. Input.string argument cannot be null");
                }
                if (!this.isType(executor1, Attribute.Type.STRING)) {
                    throw new SiddhiAppCreationException("Input string should be of type string in the 1st argument. But found " + executor1.getReturnType());
                }
                if (this.isType(executor2, Attribute.Type.STRING)) break;
                throw new SiddhiAppCreationException("Input string should be of type string in the 2nd argument. But found " + executor2.getReturnType());
            }
            default: {
                throw new IllegalArgumentException("Invalid no of arguments passed to str:locate() function, required 2 or 3, but found " + executorsCount);
            }
        }
        return null;
    }

    private boolean isType(ExpressionExecutor executor, Attribute.Type type) {
        return executor.getReturnType() == type;
    }

    protected Object execute(Object[] objects, State state) {
        boolean arg1IsNull;
        boolean arg0IsNull = objects[0] == null;
        boolean bl = arg1IsNull = objects[1] == null;
        if (arg0IsNull || arg1IsNull) {
            String argNumberWord = arg0IsNull ? "First" : "Second";
            throw new SiddhiAppRuntimeException("Invalid input given to str:locate() function. " + argNumberWord + " argument cannot be null");
        }
        String stringToBeSearchedFor = (String)objects[0];
        String stringToBeSearched = (String)objects[1];
        if (objects.length == 3) {
            int positionInTheStringToBeginSearch = (Integer)objects[2];
            stringToBeSearched = stringToBeSearched.substring(positionInTheStringToBeginSearch);
            return stringToBeSearched.indexOf(stringToBeSearchedFor) + positionInTheStringToBeginSearch;
        }
        return stringToBeSearched.indexOf(stringToBeSearchedFor);
    }

    protected Object execute(Object o, State state) {
        return null;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

