/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.string;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="length", namespace="str", description="Returns the length of the input string.", parameters={@Parameter(name="input.string", description="The input string to derive the length.", type={DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"input.string"})}, returnAttributes={@ReturnAttribute(description="Outputs the length of the input string provided.", type={DataType.INT})}, examples={@Example(syntax="length(\"Hello World\")", description="This outputs the length of the provided string. In this scenario, the, output is `11` .")})
public class LengthFunctionExtension
extends FunctionExecutor {
    Attribute.Type returnType = Attribute.Type.INT;

    protected StateFactory<State> init(ExpressionExecutor[] expressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        int executorsCount = expressionExecutors.length;
        if (executorsCount != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to str:length() function. Required 1. Found " + executorsCount);
        }
        Attribute.Type type = expressionExecutors[0].getReturnType();
        if (type != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for str:length() function, required " + Attribute.Type.STRING + ", but found " + type.toString());
        }
        return null;
    }

    protected Object execute(Object[] objects, State state) {
        return null;
    }

    protected Object execute(Object o, State state) {
        if (o == null) {
            throw new SiddhiAppRuntimeException("Invalid input given to str:length() function. The argument cannot be null");
        }
        return o.toString().length();
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

