/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.string;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregatorExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;

@Extension(name="groupConcat", namespace="str", description="This function aggregates the received events by concatenating the keys in those events using a separator, e.g.,a comma (,) or a hyphen (-), and returns the concatenated key string.", parameters={@Parameter(name="key", description="The string that needs to be aggregated.", type={DataType.STRING}, dynamic=true), @Parameter(name="separator", description="The separator that separates each string key after concatenating the keys.", type={DataType.STRING}, optional=true, defaultValue=",", dynamic=true), @Parameter(name="distinct", description="This is used to only have distinct values in the concatenated string that is returned.", type={DataType.BOOL}, optional=true, defaultValue="false", dynamic=true), @Parameter(name="order", description="This parameter accepts 'ASC' or 'DESC' strings to sort the string keys in either ascending or descending order respectively.", type={DataType.STRING}, optional=true, defaultValue="No order", dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"key"}), @ParameterOverload(parameterNames={"key", "..."}), @ParameterOverload(parameterNames={"key", "separator", "distinct"}), @ParameterOverload(parameterNames={"key", "separator", "distinct", "order"})}, returnAttributes={@ReturnAttribute(description="This returns a string,with keys from multiple events concatenated and, separated by a given separator.", type={DataType.STRING})}, examples={@Example(syntax="from InputStream#window.time(5 min)\nselect str:groupConcat(\"key\") as groupedKeys\ninput OutputStream;", description="When we input events having values for the `key` as `'A'`, `'B'`, `'S'`, `'C'`, `'A'`, it returns `\"A,B,S,C,A\"` to the 'OutputStream'."), @Example(syntax="from InputStream#window.time(5 min)\nselect groupConcat(\"key\",\"-\",true,\"ASC\") as groupedKeys\ninput OutputStream;", description="When we input events having values for the `key` as `'A'`, `'B'`, `'S'`, `'C'`, `'A'`, specify the seperator as hyphen and choose the order to be ascending, the function returns `\"A-B-C-S\"` to the 'OutputStream'.")})
public class GroupConcatFunctionExtension
extends AttributeAggregatorExecutor<ExtensionState> {
    private static final String KEY_DATA_MAP = "dataMap";
    private Map<Object, Integer> dataMap = new LinkedHashMap<Object, Integer>();
    private boolean distinct = false;

    protected StateFactory<ExtensionState> init(ExpressionExecutor[] expressionExecutors, ProcessingMode processingMode, boolean b, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        int executorsCount = expressionExecutors.length;
        if (executorsCount < 1) {
            throw new SiddhiAppValidationException("str:groupConcat() function requires at mandatory `key` attribute, but found no attributes.");
        }
        if (executorsCount > 4) {
            throw new SiddhiAppValidationException("str:groupConcat() function requires only `key`, `separator`, `distinct`, and `order` as attributes, but found " + this.attributeExpressionExecutors.length + " attributes");
        }
        switch (executorsCount) {
            case 4: {
                String value;
                ExpressionExecutor executor = expressionExecutors[3];
                if (!this.isType(executor, Attribute.Type.STRING)) {
                    throw new SiddhiAppValidationException("str:groupConcat() function's forth attribute `order` should be a constant `STRING` having `'ASC'` or `'DESC'` values, but found " + executor.getReturnType() + " .");
                }
                if (!this.isConstantAttribute(executor)) {
                    throw new SiddhiAppValidationException("str:groupConcat() function's forth attribute `order` should be a constant having `'ASC'` or `'DESC'`, but found a variable attribute.");
                }
                switch (value = ((String)((ConstantExpressionExecutor)executor).getValue()).toUpperCase()) {
                    case "ASC": {
                        this.dataMap = new TreeMap<Object, Integer>();
                        break;
                    }
                    case "DESC": {
                        this.dataMap = new TreeMap(Collections.reverseOrder());
                        break;
                    }
                    default: {
                        throw new SiddhiAppValidationException("str:groupConcat() function's forth attribute `order` should be a constant `'ASC'` or `'DESC'`, but found '" + value + "'.");
                    }
                }
            }
            case 3: {
                ExpressionExecutor executor = expressionExecutors[2];
                if (!this.isType(executor, Attribute.Type.BOOL)) {
                    throw new SiddhiAppValidationException("str:groupConcat() function's third attribute `distinct` should be a constant `BOOL`, but found " + executor.getReturnType() + " .");
                }
                if (!this.isConstantAttribute(executor)) {
                    throw new SiddhiAppValidationException("str:groupConcat() function's third attribute `distinct` should be a constant, but found a variable attribute.");
                }
                this.distinct = (Boolean)((ConstantExpressionExecutor)executor).getValue();
            }
            case 2: {
                ExpressionExecutor executor = expressionExecutors[1];
                if (this.isType(executor, Attribute.Type.STRING)) break;
                throw new SiddhiAppValidationException("str:groupConcat() function's second attribute `separator` should be a `STRING`, but found " + executor.getReturnType() + " .");
            }
        }
        return () -> new ExtensionState();
    }

    private boolean isType(ExpressionExecutor executor, Attribute.Type type) {
        return executor.getReturnType() == type;
    }

    private boolean isConstantAttribute(ExpressionExecutor executor) {
        return executor instanceof ConstantExpressionExecutor;
    }

    public Object processAdd(Object o, ExtensionState extensionState) {
        if (o == null) {
            return extensionState.currentValue();
        }
        this.addString(String.valueOf(o));
        return this.constructConcatString(",");
    }

    public Object processAdd(Object[] objects, ExtensionState extensionState) {
        this.addString(String.valueOf(objects[0]));
        return this.constructConcatString(String.valueOf(objects[1]));
    }

    public Object processRemove(Object o, ExtensionState extensionState) {
        this.removeString(String.valueOf(o));
        return this.constructConcatString(",");
    }

    public Object processRemove(Object[] objects, ExtensionState extensionState) {
        this.removeString(String.valueOf(objects[0]));
        return this.constructConcatString(String.valueOf(objects[1]));
    }

    private void addString(String data) {
        Integer count = this.dataMap.get(data);
        this.dataMap.put(data, count == null ? 1 : count + 1);
    }

    private void removeString(String data) {
        Integer count = this.dataMap.get(data);
        if (count == 1) {
            this.dataMap.remove(data);
        } else if (count > 1) {
            this.dataMap.put(data, count - 1);
        }
    }

    private Object constructConcatString(String separator) {
        StringJoiner joiner = new StringJoiner(separator);
        if (this.distinct) {
            for (Object key : this.dataMap.keySet()) {
                joiner.add(String.valueOf(key));
            }
            return joiner.toString();
        }
        for (Map.Entry<Object, Integer> entry : this.dataMap.entrySet()) {
            for (int i = 0; i < entry.getValue(); ++i) {
                joiner.add(String.valueOf(entry.getKey()));
            }
        }
        return joiner.toString();
    }

    public Object reset(ExtensionState extensionState) {
        this.dataMap.clear();
        return "";
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.STRING;
    }

    class ExtensionState
    extends State {
        private final Map<String, Object> state = new HashMap<String, Object>();

        private ExtensionState() {
            this.state.put(GroupConcatFunctionExtension.KEY_DATA_MAP, GroupConcatFunctionExtension.this.dataMap);
        }

        public boolean canDestroy() {
            return GroupConcatFunctionExtension.this.dataMap.isEmpty();
        }

        public Map<String, Object> snapshot() {
            return this.state;
        }

        public void restore(Map<String, Object> map) {
            GroupConcatFunctionExtension.this.dataMap = (Map)map.get(GroupConcatFunctionExtension.KEY_DATA_MAP);
        }

        private Object currentValue() {
            if (GroupConcatFunctionExtension.this.dataMap.isEmpty()) {
                return "";
            }
            return GroupConcatFunctionExtension.this.constructConcatString(",");
        }
    }
}

