/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.execution.unique;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.extension.execution.unique.UniqueLengthBatchWindowProcessor;
import java.util.Map;

@Extension(name="firstLengthBatch", namespace="unique", description="This is a batch (tumbling) window that holds a specific number of unique events (depending on which events arrive first). The unique events are selected based on a specific parameter that is considered as the unique key. When a new event arrives with a value for the unique key parameter that matches the same of an existing event in the window, that event is not processed by the window.", parameters={@Parameter(name="unique.key", description="The attribute that should be checked for uniqueness.", type={DataType.INT, DataType.LONG, DataType.FLOAT, DataType.BOOL, DataType.DOUBLE, DataType.STRING}, dynamic=true), @Parameter(name="window.length", description="The number of events the window should tumble.", type={DataType.INT}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"unique.key", "window.length"})}, examples={@Example(syntax="define window CseEventWindow (symbol string, price float, volume int)\n\nfrom CseEventStream#window.unique:firstLengthBatch(symbol, 10)\nselect symbol, price, volume\ninsert all events into OutputStream ;", description="The window in this configuration holds the first unique events from the 'CseEventStream' stream every second, and outputs them all into the the 'OutputStream' stream. All the events in a window during a given second should have a unique value for the 'symbol' attribute.")})
public class UniqueFirstLengthBatchWindowProcessor
extends UniqueLengthBatchWindowProcessor {
    @Override
    protected void addUniqueEvent(Map<Object, StreamEvent> uniqueEventMap, ExpressionExecutor uniqueKeyExpressionExecutor, StreamEvent clonedStreamEvent) {
        String uniqueKey = uniqueKeyExpressionExecutor.execute((ComplexEvent)clonedStreamEvent).toString();
        if (!uniqueEventMap.containsKey(uniqueKey)) {
            uniqueEventMap.put(uniqueKey, clonedStreamEvent);
        }
    }
}

