/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.MongoDbChangeEventSourceFactory;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbErrorHandler;
import io.debezium.connector.mongodb.MongoDbEventMetadataProvider;
import io.debezium.connector.mongodb.MongoDbOffsetContext;
import io.debezium.connector.mongodb.MongoDbSchema;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.connector.mongodb.metrics.MongoDbChangeEventSourceMetricsFactory;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import io.debezium.util.SchemaNameAdjuster;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MongoDbConnectorTask
extends BaseSourceTask {
    private static final String CONTEXT_NAME = "mongodb-connector-task";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile String taskName;
    private volatile MongoDbTaskContext taskContext;
    private volatile ErrorHandler errorHandler;
    private volatile MongoDbSchema schema;

    @Override
    public String version() {
        return Module.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChangeEventSourceCoordinator start(Configuration config) {
        MongoDbConnectorConfig connectorConfig = new MongoDbConnectorConfig(config);
        SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create(this.logger);
        this.taskName = "task" + config.getInteger(MongoDbConnectorConfig.TASK_ID);
        this.taskContext = new MongoDbTaskContext(config);
        Schema structSchema = connectorConfig.getSourceInfoStructMaker().schema();
        this.schema = new MongoDbSchema(this.taskContext.filters(), this.taskContext.topicSelector(), structSchema);
        ReplicaSets replicaSets = this.getReplicaSets(config);
        MongoDbOffsetContext previousOffsets = this.getPreviousOffsets(connectorConfig, replicaSets);
        Clock clock = Clock.system();
        LoggingContext.PreviousContext previousLogContext = this.taskContext.configureLoggingContext(this.taskName);
        try {
            this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).maxQueueSizeInBytes(connectorConfig.getMaxQueueSizeInBytes()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
            this.errorHandler = new MongoDbErrorHandler(connectorConfig.getLogicalName(), this.queue);
            MongoDbEventMetadataProvider metadataProvider = new MongoDbEventMetadataProvider();
            EventDispatcher<CollectionId> dispatcher = new EventDispatcher<CollectionId>(connectorConfig, this.taskContext.topicSelector(), this.schema, this.queue, this.taskContext.filters().collectionFilter()::test, DataChangeEvent::new, metadataProvider, schemaNameAdjuster);
            ChangeEventSourceCoordinator coordinator = new ChangeEventSourceCoordinator(previousOffsets, this.errorHandler, MongoDbConnector.class, connectorConfig, new MongoDbChangeEventSourceFactory(connectorConfig, this.errorHandler, dispatcher, clock, replicaSets, this.taskContext), new MongoDbChangeEventSourceMetricsFactory(), dispatcher, this.schema);
            coordinator.start(this.taskContext, this.queue, metadataProvider);
            ChangeEventSourceCoordinator changeEventSourceCoordinator = coordinator;
            return changeEventSourceCoordinator;
        }
        finally {
            previousLogContext.restore();
        }
    }

    @Override
    public List<SourceRecord> doPoll() throws InterruptedException {
        List<DataChangeEvent> records = this.queue.poll();
        return records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
    }

    @Override
    public void doStop() {
        LoggingContext.PreviousContext previousLogContext = this.taskContext.configureLoggingContext(this.taskName);
        try {
            if (this.schema != null) {
                this.schema.close();
            }
        }
        finally {
            previousLogContext.restore();
        }
    }

    @Override
    protected Iterable<Field> getAllConfigurationFields() {
        return MongoDbConnectorConfig.ALL_FIELDS;
    }

    private MongoDbOffsetContext getPreviousOffsets(MongoDbConnectorConfig connectorConfig, ReplicaSets replicaSets) {
        MongoDbOffsetContext.Loader loader = new MongoDbOffsetContext.Loader(connectorConfig, replicaSets);
        Collection partitions = loader.getPartitions();
        Map<Map<String, String>, Map<String, Object>> offsets = this.context.offsetStorageReader().offsets(partitions);
        if (offsets != null && !offsets.values().stream().filter(Objects::nonNull).collect(Collectors.toList()).isEmpty()) {
            MongoDbOffsetContext offsetContext = loader.loadOffsets(offsets);
            this.logger.info("Found previous offsets {}", (Object)offsetContext);
            return offsetContext;
        }
        return null;
    }

    private ReplicaSets getReplicaSets(Configuration config) {
        String hosts = config.getString(MongoDbConnectorConfig.HOSTS);
        ReplicaSets replicaSets = ReplicaSets.parse(hosts);
        if (replicaSets.validReplicaSetCount() == 0) {
            throw new ConnectException("Unable to start MongoDB connector task since no replica sets were found at " + hosts);
        }
        return replicaSets;
    }
}

