/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.Immutable;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.relational.Selectors;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.util.Collect;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

@Immutable
public class Filters {
    protected static final Set<String> BUILT_IN_DB_NAMES = Collect.unmodifiableSet("mysql", "performance_schema", "sys", "information_schema");
    private static final Set<String> IGNORED_TABLE_NAMES = Collect.unmodifiableSet("mysql.rds_configuration", "mysql.rds_global_status_history", "mysql.rds_global_status_history_old", "mysql.rds_history", "mysql.rds_replication_status", "mysql.rds_sysinfo");
    private final Predicate<String> dbFilter;
    private final Predicate<TableId> tableFilter;
    private final Predicate<String> isBuiltInDb;
    private final Predicate<TableId> isBuiltInTable;
    private final Tables.ColumnNameFilter columnFilter;
    private final Predicate<TableId> isIgnoredTable;

    protected static boolean isBuiltInDatabase(String databaseName) {
        if (databaseName == null) {
            return false;
        }
        return BUILT_IN_DB_NAMES.contains(databaseName.toLowerCase());
    }

    private static boolean isBuiltInTable(TableId id) {
        return Filters.isBuiltInDatabase(id.catalog());
    }

    private static boolean isIgnoredTable(TableId id) {
        return IGNORED_TABLE_NAMES.contains(id.catalog() + "." + id.table());
    }

    private Filters(Predicate<String> dbFilter, Predicate<TableId> tableFilter, Predicate<String> isBuiltInDb, Predicate<TableId> isBuiltInTable, Predicate<TableId> isIgnoredTable, Tables.ColumnNameFilter columnFilter) {
        this.dbFilter = dbFilter;
        this.tableFilter = tableFilter;
        this.isBuiltInDb = isBuiltInDb;
        this.isBuiltInTable = isBuiltInTable;
        this.columnFilter = columnFilter;
        this.isIgnoredTable = isIgnoredTable;
    }

    public Predicate<String> databaseFilter() {
        return this.dbFilter;
    }

    public Predicate<TableId> tableFilter() {
        return this.tableFilter;
    }

    public Predicate<TableId> ignoredTableFilter() {
        return this.isIgnoredTable;
    }

    public Tables.ColumnNameFilter columnFilter() {
        return this.columnFilter;
    }

    public static class Builder {
        private Predicate<String> dbFilter;
        private Predicate<TableId> tableFilter;
        private Predicate<String> isBuiltInDb = Filters::isBuiltInDatabase;
        private Predicate<TableId> isBuiltInTable = x$0 -> Filters.access$800(x$0);
        private Predicate<TableId> isIgnoredTable = x$0 -> Filters.access$700(x$0);
        private Tables.ColumnNameFilter columnFilter;
        private final Configuration config;

        public Builder(Configuration config) {
            this.config = config;
            this.setFiltersFromStrings(config.getFallbackStringProperty(MySqlConnectorConfig.DATABASE_INCLUDE_LIST, MySqlConnectorConfig.DATABASE_WHITELIST), config.getFallbackStringProperty(MySqlConnectorConfig.DATABASE_EXCLUDE_LIST, MySqlConnectorConfig.DATABASE_BLACKLIST), config.getFallbackStringProperty(MySqlConnectorConfig.TABLE_INCLUDE_LIST, MySqlConnectorConfig.TABLE_WHITELIST), config.getFallbackStringProperty(MySqlConnectorConfig.TABLE_EXCLUDE_LIST, MySqlConnectorConfig.TABLE_BLACKLIST));
            String includeColumnsFilter = config.getString(MySqlConnectorConfig.COLUMN_INCLUDE_LIST);
            this.columnFilter = includeColumnsFilter != null ? Tables.ColumnNameFilterFactory.createIncludeListFilter(includeColumnsFilter) : Tables.ColumnNameFilterFactory.createExcludeListFilter(config.getFallbackStringProperty(MySqlConnectorConfig.COLUMN_EXCLUDE_LIST, MySqlConnectorConfig.COLUMN_BLACKLIST));
        }

        public Builder setFiltersFromOffsets(Map<String, ?> offsets) {
            String tableExcludeList;
            String tableIncludeList;
            String dbExcludeList;
            String dbIncludeList = (String)offsets.get("database_include_list");
            if (null == dbIncludeList) {
                dbIncludeList = (String)offsets.get("database_whitelist");
            }
            if (null == (dbExcludeList = (String)offsets.get("database_exclude_list"))) {
                dbExcludeList = (String)offsets.get("database_blacklist");
            }
            if (null == (tableIncludeList = (String)offsets.get("table_include_list"))) {
                tableIncludeList = (String)offsets.get("table_whitelist");
            }
            if (null == (tableExcludeList = (String)offsets.get("table_exclude_list"))) {
                tableExcludeList = (String)offsets.get("table_blacklist");
            }
            this.setFiltersFromStrings(dbIncludeList, dbExcludeList, tableIncludeList, tableExcludeList);
            return this;
        }

        private void setFiltersFromStrings(String dbIncludeList, String dbExcludeList, String tableIncludeList, String tableExcludeList) {
            Predicate<String> dbFilter = Selectors.databaseSelector().includeDatabases(dbIncludeList).excludeDatabases(dbExcludeList).build();
            Predicate<TableId> tableFilter = Selectors.tableSelector().includeDatabases(dbIncludeList).excludeDatabases(dbExcludeList).includeTables(tableIncludeList).excludeTables(tableExcludeList).build();
            if (this.config.getBoolean(MySqlConnectorConfig.TABLES_IGNORE_BUILTIN)) {
                this.tableFilter = tableFilter.and(this.isBuiltInTable.negate());
                this.dbFilter = dbFilter.and(this.isBuiltInDb.negate());
            } else {
                this.tableFilter = tableFilter;
                this.dbFilter = dbFilter;
            }
            this.tableFilter = this.tableFilter.and(this.isIgnoredTable.negate());
        }

        public Builder setFiltersFromFilters(Filters filters) {
            this.dbFilter = filters.dbFilter;
            this.tableFilter = filters.tableFilter;
            this.isBuiltInDb = filters.isBuiltInDb;
            this.isBuiltInTable = filters.isBuiltInTable;
            this.columnFilter = filters.columnFilter;
            this.isIgnoredTable = filters.isIgnoredTable;
            return this;
        }

        public Builder excludeAllTables(Filters otherFilter) {
            this.excludeDatabases(otherFilter.dbFilter);
            this.excludeTables(otherFilter.tableFilter);
            return this;
        }

        public Builder excludeDatabases(Predicate<String> databases) {
            this.dbFilter = this.dbFilter.and(databases.negate());
            return this;
        }

        public Builder includeDatabases(Predicate<String> databases) {
            this.dbFilter = this.dbFilter.or(databases);
            return this;
        }

        public Builder excludeTables(Predicate<TableId> tables) {
            this.tableFilter = this.tableFilter.and(tables.negate());
            return this;
        }

        public Builder includeTables(Predicate<TableId> tables) {
            this.tableFilter = this.tableFilter.or(tables);
            return this;
        }

        public Filters build() {
            return new Filters(this.dbFilter, this.tableFilter, this.isBuiltInDb, this.isBuiltInTable, this.isIgnoredTable, this.columnFilter);
        }
    }
}

