/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.antlr;

import io.debezium.antlr.AntlrDdlParser;
import io.debezium.antlr.AntlrDdlParserListener;
import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.mysql.MySqlSystemVariables;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.antlr.listener.MySqlAntlrDdlParserListener;
import io.debezium.ddl.parser.mysql.generated.MySqlLexer;
import io.debezium.ddl.parser.mysql.generated.MySqlParser;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.AbstractDdlParser;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySqlAntlrDdlParser
extends AntlrDdlParser<MySqlLexer, MySqlParser> {
    private final ConcurrentMap<String, String> charsetNameForDatabase = new ConcurrentHashMap<String, String>();
    private final MySqlValueConverters converters;
    private final Tables.TableFilter tableFilter;

    public MySqlAntlrDdlParser() {
        this(null, Tables.TableFilter.includeAll());
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters) {
        this(converters, Tables.TableFilter.includeAll());
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters, Tables.TableFilter tableFilter) {
        this(true, false, converters, tableFilter);
    }

    protected MySqlAntlrDdlParser(boolean throwErrorsFromTreeWalk, boolean includeViews, MySqlValueConverters converters, Tables.TableFilter tableFilter) {
        super(throwErrorsFromTreeWalk, includeViews);
        this.systemVariables = new MySqlSystemVariables();
        this.converters = converters;
        this.tableFilter = tableFilter;
    }

    @Override
    protected ParseTree parseTree(MySqlParser parser) {
        return parser.root();
    }

    @Override
    protected AntlrDdlParserListener createParseTreeWalkerListener() {
        return new MySqlAntlrDdlParserListener(this);
    }

    @Override
    protected MySqlLexer createNewLexerInstance(CharStream charStreams) {
        return new MySqlLexer(charStreams);
    }

    @Override
    protected MySqlParser createNewParserInstance(CommonTokenStream commonTokenStream) {
        return new MySqlParser(commonTokenStream);
    }

    @Override
    protected SystemVariables createNewSystemVariablesInstance() {
        return new MySqlSystemVariables();
    }

    @Override
    protected boolean isGrammarInUpperCase() {
        return true;
    }

    @Override
    protected DataTypeResolver initializeDataTypeResolver() {
        DataTypeResolver.Builder dataTypeResolverBuilder = new DataTypeResolver.Builder();
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.StringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, 205), new DataTypeResolver.DataTypeEntry(12, 205, 221), new DataTypeResolver.DataTypeEntry(12, 206), new DataTypeResolver.DataTypeEntry(12, 216), new DataTypeResolver.DataTypeEntry(12, 217), new DataTypeResolver.DataTypeEntry(12, 218), new DataTypeResolver.DataTypeEntry(12, 219), new DataTypeResolver.DataTypeEntry(-15, 450), new DataTypeResolver.DataTypeEntry(-9, 450, 221), new DataTypeResolver.DataTypeEntry(-9, 207), new DataTypeResolver.DataTypeEntry(-2, 205, 209), new DataTypeResolver.DataTypeEntry(-2, 206, 209), new DataTypeResolver.DataTypeEntry(-2, 216, 209), new DataTypeResolver.DataTypeEntry(-2, 217, 209), new DataTypeResolver.DataTypeEntry(-2, 218, 209), new DataTypeResolver.DataTypeEntry(-2, 219, 209), new DataTypeResolver.DataTypeEntry(-2, 450, 209), new DataTypeResolver.DataTypeEntry(-2, 207, 209), new DataTypeResolver.DataTypeEntry(1, 22), new DataTypeResolver.DataTypeEntry(12, 22, 221)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, 208, 206).setSuffixTokens(209), new DataTypeResolver.DataTypeEntry(-15, 208, 22).setSuffixTokens(209), new DataTypeResolver.DataTypeEntry(-9, 450, 206).setSuffixTokens(209)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalVaryingStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, 208, 205, 221), new DataTypeResolver.DataTypeEntry(-9, 208, 22, 221)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.DimensionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(5, 179).setSuffixTokens(529, 166, 178), new DataTypeResolver.DataTypeEntry(5, 184).setSuffixTokens(529, 166, 178), new DataTypeResolver.DataTypeEntry(5, 180).setSuffixTokens(529, 166, 178), new DataTypeResolver.DataTypeEntry(5, 185).setSuffixTokens(529, 166, 178), new DataTypeResolver.DataTypeEntry(4, 181).setSuffixTokens(529, 166, 178), new DataTypeResolver.DataTypeEntry(4, 186).setSuffixTokens(529, 166, 178), new DataTypeResolver.DataTypeEntry(4, 182).setSuffixTokens(529, 166, 178), new DataTypeResolver.DataTypeEntry(4, 183).setSuffixTokens(529, 166, 178), new DataTypeResolver.DataTypeEntry(4, 189).setSuffixTokens(529, 166, 178), new DataTypeResolver.DataTypeEntry(4, 187).setSuffixTokens(529, 166, 178), new DataTypeResolver.DataTypeEntry(-5, 190).setSuffixTokens(529, 166, 178), new DataTypeResolver.DataTypeEntry(-5, 188).setSuffixTokens(529, 166, 178), new DataTypeResolver.DataTypeEntry(7, 191).setSuffixTokens(529, 166, 178), new DataTypeResolver.DataTypeEntry(8, 192).setSuffixTokens(193, 529, 166, 178), new DataTypeResolver.DataTypeEntry(8, 196).setSuffixTokens(193, 529, 166, 178), new DataTypeResolver.DataTypeEntry(6, 194).setSuffixTokens(529, 166, 178), new DataTypeResolver.DataTypeEntry(6, 195).setSuffixTokens(529, 166, 178), new DataTypeResolver.DataTypeEntry(3, 197).setSuffixTokens(529, 166, 178).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, 198).setSuffixTokens(529, 166, 178).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, 365).setSuffixTokens(529, 166, 178).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(2, 199).setSuffixTokens(529, 166, 178).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(-7, 285), new DataTypeResolver.DataTypeEntry(92, 201), new DataTypeResolver.DataTypeEntry(2014, 202), new DataTypeResolver.DataTypeEntry(93, 203), new DataTypeResolver.DataTypeEntry(-2, 209), new DataTypeResolver.DataTypeEntry(-3, 210), new DataTypeResolver.DataTypeEntry(2004, 212), new DataTypeResolver.DataTypeEntry(4, 204)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SimpleDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(91, 200), new DataTypeResolver.DataTypeEntry(2004, 211), new DataTypeResolver.DataTypeEntry(2004, 213), new DataTypeResolver.DataTypeEntry(2004, 215), new DataTypeResolver.DataTypeEntry(16, 287), new DataTypeResolver.DataTypeEntry(16, 288), new DataTypeResolver.DataTypeEntry(-5, 222)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.CollectionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, 220).setSuffixTokens(209), new DataTypeResolver.DataTypeEntry(1, 139).setSuffixTokens(209)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SpatialDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1111, 702), new DataTypeResolver.DataTypeEntry(1111, 703), new DataTypeResolver.DataTypeEntry(1111, 705), new DataTypeResolver.DataTypeEntry(1111, 706), new DataTypeResolver.DataTypeEntry(1111, 707), new DataTypeResolver.DataTypeEntry(1111, 708), new DataTypeResolver.DataTypeEntry(1111, 709), new DataTypeResolver.DataTypeEntry(1111, 710), new DataTypeResolver.DataTypeEntry(1111, 398), new DataTypeResolver.DataTypeEntry(1111, 704)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.LongVarbinaryDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(2004, 214).setSuffixTokens(210)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.LongVarcharDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(12, 214).setSuffixTokens(206)));
        return dataTypeResolverBuilder.build();
    }

    public ConcurrentMap<String, String> charsetNameForDatabase() {
        return this.charsetNameForDatabase;
    }

    public String parseName(MySqlParser.UidContext uidContext) {
        return this.withoutQuotes(uidContext);
    }

    public TableId parseQualifiedTableId(MySqlParser.FullIdContext fullIdContext) {
        char[] fullTableName = fullIdContext.getText().toCharArray();
        StringBuilder component = new StringBuilder();
        String dbName = null;
        String tableName = null;
        boolean EMPTY = false;
        char lastQuote = '\u0000';
        for (int i = 0; i < fullTableName.length; ++i) {
            char c = fullTableName[i];
            if (MySqlAntlrDdlParser.isQuote(c)) {
                if (lastQuote == '\u0000') {
                    lastQuote = c;
                    continue;
                }
                if (lastQuote == c) {
                    if (i < fullTableName.length - 1 && fullTableName[i + 1] == c) {
                        component.append(c);
                        ++i;
                        continue;
                    }
                    lastQuote = '\u0000';
                    continue;
                }
                component.append(c);
                continue;
            }
            if (c == '.' && lastQuote == '\u0000') {
                dbName = component.toString();
                component = new StringBuilder();
                continue;
            }
            component.append(c);
        }
        tableName = component.toString();
        return this.resolveTableId(dbName != null ? dbName : this.currentSchema(), tableName);
    }

    public void parsePrimaryIndexColumnNames(MySqlParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        List<String> pkColumnNames = indexColumnNamesContext.indexColumnName().stream().map(indexColumnNameContext -> {
            String columnName = indexColumnNameContext.uid() != null ? this.parseName(indexColumnNameContext.uid()) : MySqlAntlrDdlParser.withoutQuotes(indexColumnNameContext.STRING_LITERAL().getText());
            Column column = tableEditor.columnWithName(columnName);
            if (column != null && column.isOptional()) {
                ColumnEditor ce = column.edit().optional(false);
                if (ce.hasDefaultValue() && ce.defaultValue() == null) {
                    ce.unsetDefaultValue();
                }
                tableEditor.addColumn(ce.create());
            }
            return columnName;
        }).collect(Collectors.toList());
        tableEditor.setPrimaryKeyNames(pkColumnNames);
    }

    public String currentDatabaseCharset() {
        String charsetName = this.systemVariables.getVariable("character_set_database");
        if (charsetName == null || "DEFAULT".equalsIgnoreCase(charsetName)) {
            charsetName = this.systemVariables.getVariable("character_set_server");
        }
        return charsetName;
    }

    public String charsetForTable(TableId tableId) {
        String defaultDatabaseCharset = tableId.catalog() != null ? (String)this.charsetNameForDatabase().get(tableId.catalog()) : null;
        return defaultDatabaseCharset != null ? defaultDatabaseCharset : this.currentDatabaseCharset();
    }

    public void runIfNotNull(Runnable function, Object ... nullableObjects) {
        for (Object nullableObject : nullableObjects) {
            if (nullableObject != null) continue;
            return;
        }
        function.run();
    }

    public static List<String> extractEnumAndSetOptions(List<String> enumValues) {
        return enumValues.stream().map(AbstractDdlParser::withoutQuotes).map(MySqlAntlrDdlParser::escapeOption).collect(Collectors.toList());
    }

    public static String escapeOption(String option) {
        return option.replaceAll(",", "\\\\,").replaceAll("\\\\'", "'").replaceAll("''", "'");
    }

    public MySqlValueConverters getConverters() {
        return this.converters;
    }

    public Tables.TableFilter getTableFilter() {
        return this.tableFilter;
    }
}

