/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.util.Strings;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleConnection
extends JdbcConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleConnection.class);
    private static final int ORACLE_UNSET_SCALE = -127;
    private static final Field URL = Field.create("url", "Raw JDBC url");

    public OracleConnection(Configuration config, Supplier<ClassLoader> classLoaderSupplier) {
        super(config, OracleConnection.resolveConnectionFactory(config), classLoaderSupplier);
    }

    public void setSessionToPdb(String pdbName) {
        Statement statement = null;
        try {
            statement = this.connection().createStatement();
            statement.execute("alter session set container=" + pdbName);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOGGER.error("Couldn't close statement", (Throwable)e);
                }
            }
        }
    }

    public void resetSessionToCdb() {
        Statement statement = null;
        try {
            statement = this.connection().createStatement();
            statement.execute("alter session set container=cdb$root");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOGGER.error("Couldn't close statement", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Set<TableId> readTableNames(String databaseCatalog, String schemaNamePattern, String tableNamePattern, String[] tableTypes) throws SQLException {
        Set<TableId> tableIds = super.readTableNames(null, schemaNamePattern, tableNamePattern, tableTypes);
        return tableIds.stream().map(t -> new TableId(databaseCatalog, t.schema(), t.table())).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<TableId> getAllTableIds(String catalogName, String schemaNamePattern, boolean isView) throws SQLException {
        String query;
        boolean filterBySchema;
        boolean bl = filterBySchema = !Strings.isNullOrEmpty(schemaNamePattern);
        if (!isView) {
            query = "select table_name, owner from all_tables where table_name NOT LIKE 'MDRT_%' AND table_name not LIKE 'MDXT_%' ";
            if (filterBySchema) {
                query = query + " and owner like ?";
            }
        } else {
            query = "select view_name, owner from all_views";
            if (filterBySchema) {
                query = query + " where owner like ?";
            }
        }
        HashSet<TableId> tableIds = new HashSet<TableId>();
        try (PreparedStatement statement = this.connection().prepareStatement(query);){
            if (filterBySchema) {
                statement.setString(1, '%' + schemaNamePattern.toUpperCase() + '%');
            }
            try (ResultSet result = statement.executeQuery();){
                while (result.next()) {
                    String tableName = result.getString(1);
                    String schemaName = result.getString(2);
                    TableId tableId = new TableId(catalogName, schemaName, tableName);
                    tableIds.add(tableId);
                }
            }
        }
        finally {
            LOGGER.trace("TableIds are: {}", tableIds);
        }
        return tableIds;
    }

    private ResultSet getTableColumnsInfo(String schemaNamePattern, String tableName) throws SQLException {
        String columnQuery = "select column_name, data_type, data_length, data_precision, data_scale, default_length, density, char_length from all_tab_columns where owner like '" + schemaNamePattern + "' and table_name='" + tableName + "'";
        PreparedStatement statement = this.connection().prepareStatement(columnQuery);
        return statement.executeQuery();
    }

    public void readSchemaForCapturedTables(Tables tables, String databaseCatalog, String schemaNamePattern, Tables.ColumnNameFilter columnFilter, boolean removeTablesNotFoundInJdbc, Set<TableId> capturedTables) throws SQLException {
        HashSet<TableId> tableIdsBefore = new HashSet<TableId>(tables.tableIds());
        DatabaseMetaData metadata = this.connection().getMetaData();
        HashMap columnsByTable = new HashMap();
        for (TableId tableId : capturedTables) {
            ResultSet columnMetadata = metadata.getColumns(databaseCatalog, schemaNamePattern, tableId.table(), null);
            Throwable throwable = null;
            try {
                while (columnMetadata.next()) {
                    this.readTableColumn(columnMetadata, tableId, columnFilter).ifPresent(column -> columnsByTable.computeIfAbsent(tableId, t -> new ArrayList()).add(column.create()));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (columnMetadata == null) continue;
                if (throwable != null) {
                    try {
                        columnMetadata.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                columnMetadata.close();
            }
        }
        for (Map.Entry entry : columnsByTable.entrySet()) {
            List<String> pkColumnNames = this.readPrimaryKeyNames(metadata, (TableId)entry.getKey());
            List columns = (List)entry.getValue();
            Collections.sort(columns);
            tables.overwriteTable((TableId)entry.getKey(), columns, pkColumnNames, null);
        }
        if (removeTablesNotFoundInJdbc) {
            tableIdsBefore.removeAll(columnsByTable.keySet());
            tableIdsBefore.forEach(tables::removeTable);
        }
        for (TableId tableId : capturedTables) {
            this.overrideOracleSpecificColumnTypes(tables, tableId, tableId);
        }
    }

    @Override
    public void readSchema(Tables tables, String databaseCatalog, String schemaNamePattern, Tables.TableFilter tableFilter, Tables.ColumnNameFilter columnFilter, boolean removeTablesNotFoundInJdbc) throws SQLException {
        super.readSchema(tables, null, schemaNamePattern, null, columnFilter, removeTablesNotFoundInJdbc);
        Set tableIds = tables.tableIds().stream().filter(x -> schemaNamePattern.equals(x.schema())).collect(Collectors.toSet());
        for (TableId tableId : tableIds) {
            TableId tableIdWithCatalog = new TableId(databaseCatalog, tableId.schema(), tableId.table());
            if (tableFilter.isIncluded(tableIdWithCatalog)) {
                this.overrideOracleSpecificColumnTypes(tables, tableId, tableIdWithCatalog);
            }
            tables.removeTable(tableId);
        }
    }

    private void overrideOracleSpecificColumnTypes(Tables tables, TableId tableId, TableId tableIdWithCatalog) {
        TableEditor editor = tables.editTable(tableId);
        editor.tableId(tableIdWithCatalog);
        ArrayList<String> columnNames = new ArrayList<String>(editor.columnNames());
        for (String columnName : columnNames) {
            Column column = editor.columnWithName(columnName);
            if (column.jdbcType() == 93) {
                editor.addColumn(column.edit().length(column.scale().orElse(-1)).scale(null).create());
                continue;
            }
            if (column.jdbcType() != 2) continue;
            column.scale().filter(s -> s == -127).ifPresent(s -> editor.addColumn(column.edit().scale(null).create()));
        }
        tables.overwriteTable(editor.create());
    }

    public OracleConnection executeLegacy(String ... sqlStatements) throws SQLException {
        return this.executeLegacy((Statement statement) -> {
            for (String sqlStatement : sqlStatements) {
                if (sqlStatement == null) continue;
                statement.execute(sqlStatement);
            }
        });
    }

    public OracleConnection executeLegacy(JdbcConnection.Operations operations) throws SQLException {
        Connection conn = this.connection();
        try (Statement statement = conn.createStatement();){
            operations.apply(statement);
            this.commit();
        }
        return this;
    }

    private static JdbcConnection.ConnectionFactory resolveConnectionFactory(Configuration config) {
        String connectionUrl = config.getString(URL) != null ? config.getString(URL) : OracleConnectorConfig.ConnectorAdapter.parse(config.getString("connection.adapter")).getConnectionUrl();
        return JdbcConnection.patternBasedFactory(connectionUrl, new Field[0]);
    }
}

