/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.oracle.Module;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleSourceInfoStructMaker;
import io.debezium.connector.oracle.logminer.HistoryRecorder;
import io.debezium.connector.oracle.logminer.NeverHistoryRecorder;
import io.debezium.connector.oracle.xstream.LcrPosition;
import io.debezium.connector.oracle.xstream.OracleVersion;
import io.debezium.document.Document;
import io.debezium.function.Predicates;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.ColumnId;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.KafkaDatabaseHistory;
import io.debezium.util.Strings;
import java.time.Duration;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.kafka.common.config.ConfigDef;

public class OracleConnectorConfig
extends HistorizedRelationalDatabaseConnectorConfig {
    public static final String DATABASE_CONFIG_PREFIX = "database.";
    protected static final int DEFAULT_PORT = 1528;
    public static final Field HOSTNAME = Field.create("database." + JdbcConfiguration.HOSTNAME).withDisplayName("Hostname").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(OracleConnectorConfig::requiredWhenNoUrl).withDescription("Resolvable hostname or IP address of the Oracle database server.");
    public static final Field PORT = Field.create("database." + JdbcConfiguration.PORT).withDisplayName("Port").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withDefault(1528).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isInteger).withDescription("Port of the Oracle database server.");
    public static final Field USER = Field.create("database." + JdbcConfiguration.USER).withDisplayName("User").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isRequired).withDescription("Name of the Oracle database user to be used when connecting to the database.");
    public static final Field PASSWORD = Field.create("database." + JdbcConfiguration.PASSWORD).withDisplayName("Password").withType(ConfigDef.Type.PASSWORD).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Password of the Oracle database user to be used when connecting to the database.");
    public static final Field DATABASE_NAME = Field.create("database." + JdbcConfiguration.DATABASE).withDisplayName("Database name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(Field::isRequired).withDescription("The name of the database the connector should be monitoring. When working with a multi-tenant set-up, must be set to the CDB name.");
    public static final Field PDB_NAME = Field.create("database.pdb.name").withDisplayName("PDB name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("Name of the pluggable database when working with a multi-tenant set-up. The CDB name must be given via " + DATABASE_NAME.name() + " in this case.");
    public static final Field SCHEMA_NAME = Field.create("database.schema").withDisplayName("Schema name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(OracleConnectorConfig::validateDatabaseSchema).withDescription("Name of the connection user to the database ");
    public static final Field XSTREAM_SERVER_NAME = Field.create("database.out.server.name").withDisplayName("XStream out server name").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(OracleConnectorConfig::validateOutServerName).withDescription("Name of the XStream Out server to connect to.");
    public static final Field SNAPSHOT_MODE = Field.create("snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, SnapshotMode.INITIAL).withValidation(OracleConnectorConfig::validateSnapshotMode).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The criteria for running a snapshot upon startup of the connector. Options include: 'initial' (the default) to specify the connector should run a snapshot only when no offsets are available for the logical server name; 'schema_only' to specify the connector should run a snapshot of the schema when no offsets are available for the logical server name. ");
    public static final Field TABLENAME_CASE_INSENSITIVE = Field.create("database.tablename.case.insensitive").withDisplayName("Case insensitive table names").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withImportance(ConfigDef.Importance.LOW).withDescription("Case insensitive table names; set to 'true' for Oracle 11g, 'false' (default) otherwise.");
    public static final Field ORACLE_VERSION = Field.create("database.oracle.version").withDisplayName("Oracle version, 11 or 12+").withEnum(OracleVersion.class, OracleVersion.V12Plus).withImportance(ConfigDef.Importance.LOW).withDescription("For default Oracle 12+, use default pos_version value v2, for Oracle 11, use pos_version value v1.");
    public static final Field SERVER_NAME = RelationalDatabaseConnectorConfig.SERVER_NAME.withValidation(CommonConnectorConfig::validateServerNameIsDifferentFromHistoryTopicName);
    public static final Field CONNECTOR_ADAPTER = Field.create("database.connection.adapter").withDisplayName("Connector adapter").withEnum(ConnectorAdapter.class, ConnectorAdapter.XSTREAM).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("There are two adapters: XStream and LogMiner.");
    public static final Field LOG_MINING_STRATEGY = Field.create("log.mining.strategy").withDisplayName("Log Mining Strategy").withEnum(LogMiningStrategy.class, LogMiningStrategy.CATALOG_IN_REDO).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("There are strategies: Online catalog with faster mining but no captured DDL. Another - with data dictionary loaded into REDO LOG files");
    public static final Field CONTINUOUS_MINE = Field.create("log.mining.continuous.mine").withDisplayName("Should log mining session configured with CONTINUOUS_MINE setting?").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(false).withValidation(Field::isBoolean).withDescription("If true, CONTINUOUS_MINE option will be added to the log mining session. This will manage log files switches seamlessly.");
    public static final Field SNAPSHOT_ENHANCEMENT_TOKEN = Field.create("snapshot.enhance.predicate.scn").withDisplayName("A string to replace on snapshot predicate enhancement").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("A token to replace on snapshot predicate template");
    public static final Field LOG_MINING_HISTORY_RECORDER_CLASS = Field.create("log.mining.history.recorder.class").withDisplayName("Log Mining History Recorder Class").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withInvisibleRecommender().withDescription("Allows connector deployment to capture log mining results");
    public static final Field LOG_MINING_HISTORY_RETENTION = Field.create("database.history.retention.hours").withDisplayName("Log Mining history retention").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(0).withDescription("Hours to keep Log Mining history.  By default, no history is retained.");
    public static final Field RAC_SYSTEM = Field.create("database.rac").withDisplayName("Oracle RAC").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDefault(false).withDescription("Flag to if it is RAC system");
    public static final Field RAC_NODES = Field.create("rac.nodes").withDisplayName("Oracle RAC nodes").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("A comma-separated list of RAC node hostnames or ip addresses");
    public static final Field URL = Field.create("database.url").withDisplayName("Complete JDBC URL").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(OracleConnectorConfig::requiredWhenNoHostname).withDescription("Complete JDBC URL as an alternative to specifying hostname, port and database provided as a way to support alternative connection scenarios.");
    public static final Field LOG_MINING_ARCHIVE_LOG_HOURS = Field.create("log.mining.archive.log.hours").withDisplayName("Log Mining Archive Log Hours").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(0).withDescription("The number of hours in the past from SYSDATE to mine archive logs.  Using 0 mines all available archive logs");
    public static Field.Set ALL_FIELDS = Field.setOf(HOSTNAME, PORT, USER, PASSWORD, SERVER_NAME, DATABASE_NAME, PDB_NAME, XSTREAM_SERVER_NAME, SNAPSHOT_MODE, HistorizedRelationalDatabaseConnectorConfig.DATABASE_HISTORY, RelationalDatabaseConnectorConfig.TABLE_WHITELIST, RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST, RelationalDatabaseConnectorConfig.TABLE_BLACKLIST, RelationalDatabaseConnectorConfig.TABLE_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN, RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, CommonConnectorConfig.POLL_INTERVAL_MS, CommonConnectorConfig.MAX_BATCH_SIZE, CommonConnectorConfig.MAX_QUEUE_SIZE, CommonConnectorConfig.SNAPSHOT_DELAY_MS, CommonConnectorConfig.SNAPSHOT_FETCH_SIZE, CommonConnectorConfig.PROVIDE_TRANSACTION_METADATA, Heartbeat.HEARTBEAT_INTERVAL, Heartbeat.HEARTBEAT_TOPICS_PREFIX, TABLENAME_CASE_INSENSITIVE, ORACLE_VERSION, SCHEMA_NAME, CONNECTOR_ADAPTER, LOG_MINING_STRATEGY, SNAPSHOT_ENHANCEMENT_TOKEN, LOG_MINING_HISTORY_RECORDER_CLASS, LOG_MINING_HISTORY_RETENTION, RAC_SYSTEM, RAC_NODES, CommonConnectorConfig.EVENT_PROCESSING_FAILURE_HANDLING_MODE, URL, LOG_MINING_ARCHIVE_LOG_HOURS);
    private final String databaseName;
    private final String pdbName;
    private final String xoutServerName;
    private final SnapshotMode snapshotMode;
    private final boolean tablenameCaseInsensitive;
    private final OracleVersion oracleVersion;
    private final String schemaName;
    private final Tables.ColumnNameFilter columnFilter;
    private final HistoryRecorder logMiningHistoryRecorder;

    public OracleConnectorConfig(Configuration config) {
        super(OracleConnector.class, config, config.getString(SERVER_NAME), new SystemTablesPredicate(), x -> x.schema() + "." + x.table(), true);
        this.databaseName = OracleConnectorConfig.toUpperCase(config.getString(DATABASE_NAME));
        this.pdbName = OracleConnectorConfig.toUpperCase(config.getString(PDB_NAME));
        this.xoutServerName = config.getString(XSTREAM_SERVER_NAME);
        this.snapshotMode = SnapshotMode.parse(config.getString(SNAPSHOT_MODE));
        this.tablenameCaseInsensitive = config.getBoolean(TABLENAME_CASE_INSENSITIVE);
        this.oracleVersion = OracleVersion.parse(config.getString(ORACLE_VERSION));
        this.schemaName = OracleConnectorConfig.toUpperCase(config.getString(SCHEMA_NAME));
        String blacklistedColumns = OracleConnectorConfig.toUpperCase(config.getString(RelationalDatabaseConnectorConfig.COLUMN_BLACKLIST));
        this.columnFilter = this.getColumnNameFilter(blacklistedColumns);
        this.logMiningHistoryRecorder = OracleConnectorConfig.resolveLogMiningHistoryRecorder(config);
    }

    private static String toUpperCase(String property) {
        return property == null ? null : property.toUpperCase();
    }

    private static HistoryRecorder resolveLogMiningHistoryRecorder(Configuration config) {
        if (!config.hasKey(LOG_MINING_HISTORY_RECORDER_CLASS.name())) {
            return new NeverHistoryRecorder();
        }
        return config.getInstance(LOG_MINING_HISTORY_RECORDER_CLASS, HistoryRecorder.class);
    }

    protected Tables.ColumnNameFilter getColumnNameFilter(final String excludedColumnPatterns) {
        return new Tables.ColumnNameFilter(){
            Predicate<ColumnId> delegate;
            {
                this.delegate = Predicates.excludes(excludedColumnPatterns, ColumnId::toString);
            }

            @Override
            public boolean matches(String catalogName, String schemaName, String tableName, String columnName) {
                return this.delegate.test(new ColumnId(new TableId(null, null, tableName), columnName));
            }
        };
    }

    public static ConfigDef configDef() {
        ConfigDef config = new ConfigDef();
        Field.group(config, "Oracle", HOSTNAME, PORT, USER, PASSWORD, SERVER_NAME, DATABASE_NAME, PDB_NAME, XSTREAM_SERVER_NAME, SNAPSHOT_MODE, CONNECTOR_ADAPTER, LOG_MINING_STRATEGY, URL);
        Field.group(config, "History Storage", KafkaDatabaseHistory.BOOTSTRAP_SERVERS, KafkaDatabaseHistory.TOPIC, KafkaDatabaseHistory.RECOVERY_POLL_ATTEMPTS, KafkaDatabaseHistory.RECOVERY_POLL_INTERVAL_MS, HistorizedRelationalDatabaseConnectorConfig.DATABASE_HISTORY);
        Field.group(config, "Events", RelationalDatabaseConnectorConfig.TABLE_WHITELIST, RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST, RelationalDatabaseConnectorConfig.TABLE_BLACKLIST, RelationalDatabaseConnectorConfig.TABLE_EXCLUDE_LIST, RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, RelationalDatabaseConnectorConfig.COLUMN_BLACKLIST, RelationalDatabaseConnectorConfig.TABLE_IGNORE_BUILTIN, CommonConnectorConfig.PROVIDE_TRANSACTION_METADATA, Heartbeat.HEARTBEAT_INTERVAL, Heartbeat.HEARTBEAT_TOPICS_PREFIX, CommonConnectorConfig.EVENT_PROCESSING_FAILURE_HANDLING_MODE);
        Field.group(config, "Connector", CommonConnectorConfig.POLL_INTERVAL_MS, CommonConnectorConfig.MAX_BATCH_SIZE, CommonConnectorConfig.MAX_QUEUE_SIZE, CommonConnectorConfig.SNAPSHOT_DELAY_MS, CommonConnectorConfig.SNAPSHOT_FETCH_SIZE, SNAPSHOT_ENHANCEMENT_TOKEN, LOG_MINING_HISTORY_RECORDER_CLASS, LOG_MINING_HISTORY_RETENTION, RAC_SYSTEM, RAC_NODES, LOG_MINING_ARCHIVE_LOG_HOURS);
        return config;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getPdbName() {
        return this.pdbName;
    }

    public String getXoutServerName() {
        return this.xoutServerName;
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    public boolean getTablenameCaseInsensitive() {
        return this.tablenameCaseInsensitive;
    }

    public OracleVersion getOracleVersion() {
        return this.oracleVersion;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Tables.ColumnNameFilter getColumnFilter() {
        return this.columnFilter;
    }

    @Override
    protected HistoryRecordComparator getHistoryRecordComparator() {
        return new HistoryRecordComparator(){

            @Override
            protected boolean isPositionAtOrBefore(Document recorded, Document desired) {
                Long desiredScn;
                if (OracleConnectorConfig.this.getAdapter() == ConnectorAdapter.XSTREAM) {
                    LcrPosition recordedPosition = LcrPosition.valueOf(recorded.getString("lcr_position"));
                    LcrPosition desiredPosition = LcrPosition.valueOf(desired.getString("lcr_position"));
                    Long recordedScn = recordedPosition != null ? recordedPosition.getScn() : recorded.getLong("scn").longValue();
                    Long desiredScn2 = desiredPosition != null ? desiredPosition.getScn() : desired.getLong("scn").longValue();
                    return recordedPosition != null && desiredPosition != null ? recordedPosition.compareTo(desiredPosition) < 1 : recordedScn.compareTo(desiredScn2) < 1;
                }
                Long recordedScn = recorded.getLong("scn");
                return recordedScn.compareTo(desiredScn = desired.getLong("scn")) < 1;
            }
        };
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return new OracleSourceInfoStructMaker(Module.name(), Module.version(), this);
    }

    @Override
    public String getContextName() {
        return Module.contextName();
    }

    public ConnectorAdapter getAdapter() {
        return ConnectorAdapter.parse(this.getConfig().getString(CONNECTOR_ADAPTER));
    }

    public LogMiningStrategy getLogMiningStrategy() {
        return LogMiningStrategy.parse(this.getConfig().getString(LOG_MINING_STRATEGY));
    }

    public Boolean isLogMiningHistoryRecorded() {
        return this.getLogMinerHistoryRetentionHours() > 0L;
    }

    public HistoryRecorder getLogMiningHistoryRecorder() {
        return this.logMiningHistoryRecorder;
    }

    public long getLogMinerHistoryRetentionHours() {
        return this.getConfig().getLong(LOG_MINING_HISTORY_RETENTION);
    }

    public Boolean isRacSystem() {
        return !this.getRacNodes().isEmpty();
    }

    public Set<String> getRacNodes() {
        String nodes = this.getConfig().getString(RAC_NODES);
        return Strings.setOf(nodes, String::new);
    }

    public String getTokenToReplaceInSnapshotPredicate() {
        return this.getConfig().getString(SNAPSHOT_ENHANCEMENT_TOKEN);
    }

    public boolean isContinuousMining() {
        return this.getConfig().getBoolean(CONTINUOUS_MINE);
    }

    public Duration getLogMiningArchiveLogRetention() {
        return Duration.ofHours(this.getConfig().getLong(LOG_MINING_ARCHIVE_LOG_HOURS));
    }

    private static int validateSnapshotMode(Configuration config, Field field, Field.ValidationOutput problems) {
        if (config.hasKey(SNAPSHOT_MODE.name())) {
            String snapshotMode = config.getString(SNAPSHOT_MODE.name());
            if (SnapshotMode.INITIAL_SCHEMA_ONLY.value.equals(snapshotMode)) {
                problems.accept(SNAPSHOT_MODE, snapshotMode, "The 'initial_schema_only' snapshot.mode is no longer supported and will be removed in a future revision. Use 'schema_only' instead.");
                return 0;
            }
        }
        return 0;
    }

    @Override
    public String getConnectorName() {
        return Module.name();
    }

    public static int validateDatabaseSchema(Configuration config, Field field, Field.ValidationOutput problems) {
        String schemaName;
        if (ConnectorAdapter.LOG_MINER.equals(ConnectorAdapter.parse(config.getString(CONNECTOR_ADAPTER))) && ((schemaName = config.getString(SCHEMA_NAME)) == null || schemaName.trim().length() == 0)) {
            problems.accept(SCHEMA_NAME, schemaName, "The '" + SCHEMA_NAME.name() + "' be provided when using the LogMiner connection adapter");
            return 1;
        }
        return 0;
    }

    public static int validateOutServerName(Configuration config, Field field, Field.ValidationOutput problems) {
        if (ConnectorAdapter.XSTREAM.equals(ConnectorAdapter.parse(config.getString(CONNECTOR_ADAPTER)))) {
            return Field.isRequired(config, field, problems);
        }
        return 0;
    }

    public static int requiredWhenNoUrl(Configuration config, Field field, Field.ValidationOutput problems) {
        if (config.getString(URL) == null) {
            return Field.isRequired(config, field, problems);
        }
        return 0;
    }

    public static int requiredWhenNoHostname(Configuration config, Field field, Field.ValidationOutput problems) {
        if (config.getString(HOSTNAME) == null) {
            return Field.isRequired(config, field, problems);
        }
        return 0;
    }

    private static class SystemTablesPredicate
    implements Tables.TableFilter {
        private SystemTablesPredicate() {
        }

        @Override
        public boolean isIncluded(TableId t) {
            return !t.schema().toLowerCase().equals("appqossys") && !t.schema().toLowerCase().equals("audsys") && !t.schema().toLowerCase().equals("ctxsys") && !t.schema().toLowerCase().equals("dvsys") && !t.schema().toLowerCase().equals("dbsfwuser") && !t.schema().toLowerCase().equals("dbsnmp") && !t.schema().toLowerCase().equals("gsmadmin_internal") && !t.schema().toLowerCase().equals("lbacsys") && !t.schema().toLowerCase().equals("mdsys") && !t.schema().toLowerCase().equals("ojvmsys") && !t.schema().toLowerCase().equals("olapsys") && !t.schema().toLowerCase().equals("orddata") && !t.schema().toLowerCase().equals("ordsys") && !t.schema().toLowerCase().equals("outln") && !t.schema().toLowerCase().equals("sys") && !t.schema().toLowerCase().equals("system") && !t.schema().toLowerCase().equals("wmsys") && !t.schema().toLowerCase().equals("xdb");
        }
    }

    public static enum LogMiningStrategy implements EnumeratedValue
    {
        ONLINE_CATALOG("online_catalog"),
        CATALOG_IN_REDO("redo_log_catalog");

        private final String value;

        private LogMiningStrategy(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static LogMiningStrategy parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (LogMiningStrategy adapter : LogMiningStrategy.values()) {
                if (!adapter.getValue().equalsIgnoreCase(value)) continue;
                return adapter;
            }
            return null;
        }

        public static LogMiningStrategy parse(String value, String defaultValue) {
            LogMiningStrategy mode = LogMiningStrategy.parse(value);
            if (mode == null && defaultValue != null) {
                mode = LogMiningStrategy.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum ConnectorAdapter implements EnumeratedValue
    {
        XSTREAM("XStream"){

            @Override
            public String getConnectionUrl() {
                return "jdbc:oracle:oci:@${" + JdbcConfiguration.HOSTNAME + "}:${" + JdbcConfiguration.PORT + "}/${" + JdbcConfiguration.DATABASE + "}";
            }
        }
        ,
        LOG_MINER("LogMiner"){

            @Override
            public String getConnectionUrl() {
                return "jdbc:oracle:thin:@${" + JdbcConfiguration.HOSTNAME + "}:${" + JdbcConfiguration.PORT + "}/${" + JdbcConfiguration.DATABASE + "}";
            }
        };

        private final String value;

        public abstract String getConnectionUrl();

        private ConnectorAdapter(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static ConnectorAdapter parse(String value) {
            if (value == null) {
                return XSTREAM;
            }
            value = value.trim();
            for (ConnectorAdapter adapter : ConnectorAdapter.values()) {
                if (!adapter.getValue().equalsIgnoreCase(value)) continue;
                return adapter;
            }
            return null;
        }

        public static ConnectorAdapter parse(String value, String defaultValue) {
            ConnectorAdapter mode = ConnectorAdapter.parse(value);
            if (mode == null && defaultValue != null) {
                mode = ConnectorAdapter.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        INITIAL("initial", true),
        INITIAL_SCHEMA_ONLY("initial_schema_only", false),
        SCHEMA_ONLY("schema_only", false);

        private final String value;
        private final boolean includeData;

        private SnapshotMode(String value, boolean includeData) {
            this.value = value;
            this.includeData = includeData;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public boolean includeData() {
            return this.includeData;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

