/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.SourceInfo;
import io.debezium.connector.oracle.xstream.LcrPosition;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import java.lang.constant.Constable;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class OracleOffsetContext
implements OffsetContext {
    private static final String SERVER_PARTITION_KEY = "server";
    private static final String SNAPSHOT_COMPLETED_KEY = "snapshot_completed";
    private final Schema sourceInfoSchema;
    private final Map<String, String> partition;
    private final SourceInfo sourceInfo;
    private final TransactionContext transactionContext;
    private boolean snapshotCompleted;

    public OracleOffsetContext(OracleConnectorConfig connectorConfig, long scn, Long commitScn, LcrPosition lcrPosition, boolean snapshot, boolean snapshotCompleted, TransactionContext transactionContext) {
        this(connectorConfig, scn, lcrPosition, snapshot, snapshotCompleted, transactionContext);
        this.sourceInfo.setCommitScn(commitScn);
    }

    private OracleOffsetContext(OracleConnectorConfig connectorConfig, long scn, LcrPosition lcrPosition, boolean snapshot, boolean snapshotCompleted, TransactionContext transactionContext) {
        this.partition = Collections.singletonMap(SERVER_PARTITION_KEY, connectorConfig.getLogicalName());
        this.sourceInfo = new SourceInfo(connectorConfig);
        this.sourceInfo.setScn(scn);
        this.sourceInfo.setLcrPosition(lcrPosition);
        this.sourceInfoSchema = this.sourceInfo.schema();
        this.transactionContext = transactionContext;
        this.snapshotCompleted = snapshotCompleted;
        if (this.snapshotCompleted) {
            this.postSnapshotCompletion();
        } else {
            this.sourceInfo.setSnapshot(snapshot ? SnapshotRecord.TRUE : SnapshotRecord.FALSE);
        }
    }

    public static Builder create() {
        return new Builder();
    }

    @Override
    public Map<String, ?> getPartition() {
        return this.partition;
    }

    @Override
    public Map<String, ?> getOffset() {
        if (this.sourceInfo.isSnapshot()) {
            HashMap<String, Constable> offset = new HashMap<String, Constable>();
            offset.put("scn", Long.valueOf(this.sourceInfo.getScn()));
            offset.put("snapshot", Boolean.valueOf(true));
            offset.put(SNAPSHOT_COMPLETED_KEY, Boolean.valueOf(this.snapshotCompleted));
            return offset;
        }
        HashMap<String, Object> offset = new HashMap<String, Object>();
        if (this.sourceInfo.getLcrPosition() != null) {
            offset.put("lcr_position", this.sourceInfo.getLcrPosition().toString());
        } else {
            offset.put("scn", this.sourceInfo.getScn());
            offset.put("commit_scn", this.sourceInfo.getCommitScn());
        }
        return this.transactionContext.store(offset);
    }

    @Override
    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    @Override
    public Struct getSourceInfo() {
        return this.sourceInfo.struct();
    }

    public void setScn(long scn) {
        this.sourceInfo.setScn(scn);
    }

    public void setCommitScn(Long commitScn) {
        this.sourceInfo.setCommitScn(commitScn);
    }

    public long getScn() {
        return this.sourceInfo.getScn();
    }

    public Long getCommitScn() {
        return this.sourceInfo.getCommitScn();
    }

    public void setLcrPosition(LcrPosition lcrPosition) {
        this.sourceInfo.setLcrPosition(lcrPosition);
    }

    public LcrPosition getLcrPosition() {
        return this.sourceInfo.getLcrPosition();
    }

    public void setTransactionId(String transactionId) {
        this.sourceInfo.setTransactionId(transactionId);
    }

    public void setSourceTime(Instant instant) {
        this.sourceInfo.setSourceTime(instant);
    }

    public void setTableId(TableId tableId) {
        this.sourceInfo.setTableId(tableId);
    }

    @Override
    public boolean isSnapshotRunning() {
        return this.sourceInfo.isSnapshot() && !this.snapshotCompleted;
    }

    @Override
    public void preSnapshotStart() {
        this.sourceInfo.setSnapshot(SnapshotRecord.TRUE);
        this.snapshotCompleted = false;
    }

    @Override
    public void preSnapshotCompletion() {
        this.snapshotCompleted = true;
    }

    @Override
    public void postSnapshotCompletion() {
        this.sourceInfo.setSnapshot(SnapshotRecord.FALSE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OracleOffsetContext [scn=").append(this.getScn());
        if (this.sourceInfo.isSnapshot()) {
            sb.append(", snapshot=").append(this.sourceInfo.isSnapshot());
            sb.append(", snapshot_completed=").append(this.snapshotCompleted);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void markLastSnapshotRecord() {
        this.sourceInfo.setSnapshot(SnapshotRecord.LAST);
    }

    @Override
    public void event(DataCollectionId tableId, Instant timestamp) {
        this.sourceInfo.setTableId((TableId)tableId);
        this.sourceInfo.setSourceTime(timestamp);
    }

    @Override
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public static class Loader
    implements OffsetContext.Loader {
        private final OracleConnectorConfig connectorConfig;
        private final OracleConnectorConfig.ConnectorAdapter adapter;

        public Loader(OracleConnectorConfig connectorConfig, OracleConnectorConfig.ConnectorAdapter adapter) {
            this.connectorConfig = connectorConfig;
            this.adapter = adapter;
        }

        @Override
        public Map<String, ?> getPartition() {
            return Collections.singletonMap(OracleOffsetContext.SERVER_PARTITION_KEY, this.connectorConfig.getLogicalName());
        }

        @Override
        public OffsetContext load(Map<String, ?> offset) {
            boolean snapshot = Boolean.TRUE.equals(offset.get("snapshot"));
            boolean snapshotCompleted = Boolean.TRUE.equals(offset.get(OracleOffsetContext.SNAPSHOT_COMPLETED_KEY));
            if (this.adapter == OracleConnectorConfig.ConnectorAdapter.LOG_MINER) {
                Long scn = (Long)offset.get("scn");
                Long commitScn = (Long)offset.get("commit_scn");
                return new OracleOffsetContext(this.connectorConfig, (long)scn, commitScn, null, snapshot, snapshotCompleted, TransactionContext.load(offset));
            }
            LcrPosition lcrPosition = LcrPosition.valueOf((String)offset.get("lcr_position"));
            Long scn = lcrPosition != null ? lcrPosition.getScn() : ((Long)offset.get("scn")).longValue();
            return new OracleOffsetContext(this.connectorConfig, (long)scn, lcrPosition, snapshot, snapshotCompleted, TransactionContext.load(offset));
        }
    }

    public static class Builder {
        private OracleConnectorConfig connectorConfig;
        private long scn;
        private LcrPosition lcrPosition;
        private boolean snapshot;
        private boolean snapshotCompleted;
        private TransactionContext transactionContext;

        public Builder logicalName(OracleConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
            return this;
        }

        public Builder scn(long scn) {
            this.scn = scn;
            return this;
        }

        public Builder lcrPosition(LcrPosition lcrPosition) {
            this.lcrPosition = lcrPosition;
            return this;
        }

        public Builder snapshot(boolean snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public Builder snapshotCompleted(boolean snapshotCompleted) {
            this.snapshotCompleted = snapshotCompleted;
            return this;
        }

        public Builder transactionContext(TransactionContext transactionContext) {
            this.transactionContext = transactionContext;
            return this;
        }

        OracleOffsetContext build() {
            return new OracleOffsetContext(this.connectorConfig, this.scn, this.lcrPosition, this.snapshot, this.snapshotCompleted, this.transactionContext);
        }
    }
}

