/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.data.VariableScaleDecimal;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.time.MicroDuration;
import io.debezium.time.ZonedTimestamp;
import io.debezium.util.NumberConversions;
import io.debezium.util.Strings;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class OracleValueConverters
extends JdbcValueConverters {
    private static final Pattern INTERVAL_DAY_SECOND_PATTERN = Pattern.compile("([+\\-])?(\\d+) (\\d+):(\\d+):(\\d+).(\\d+)");
    private final OracleConnection connection;

    public OracleValueConverters(OracleConnectorConfig config, OracleConnection connection) {
        super(config.getDecimalMode(), TemporalPrecisionMode.ADAPTIVE, ZoneOffset.UTC, null, null, null);
        this.connection = connection;
    }

    @Override
    public SchemaBuilder schemaBuilder(Column column) {
        this.logger.debug("Building schema for column {} of type {} named {} with constraints ({},{})", new Object[]{column.name(), column.jdbcType(), column.typeName(), column.length(), column.scale()});
        switch (column.jdbcType()) {
            case 6: {
                return this.variableScaleSchema(column);
            }
            case 2: {
                return this.getNumericSchema(column);
            }
            case 100: {
                return SchemaBuilder.float32();
            }
            case 101: {
                return SchemaBuilder.float64();
            }
            case -102: 
            case -101: {
                return ZonedTimestamp.builder();
            }
            case -104: 
            case -103: {
                return MicroDuration.builder();
            }
            case 2002: {
                return SchemaBuilder.string();
            }
        }
        SchemaBuilder builder = super.schemaBuilder(column);
        this.logger.info("JdbcValueConverters returned '{}' for column '{}'", (Object)builder.getClass().getName(), (Object)column.name());
        return builder;
    }

    private SchemaBuilder getNumericSchema(Column column) {
        if (column.scale().isPresent()) {
            Integer scale = column.scale().get();
            if (scale <= 0) {
                int width = column.length() - scale;
                if (width < 3) {
                    return SchemaBuilder.int8();
                }
                if (width < 5) {
                    return SchemaBuilder.int16();
                }
                if (width < 10) {
                    return SchemaBuilder.int32();
                }
                if (width < 19) {
                    return SchemaBuilder.int64();
                }
            }
            return super.schemaBuilder(column);
        }
        return this.variableScaleSchema(column);
    }

    private SchemaBuilder variableScaleSchema(Column column) {
        if (this.decimalMode == JdbcValueConverters.DecimalMode.PRECISE) {
            return VariableScaleDecimal.builder();
        }
        return SpecialValueDecimal.builder(this.decimalMode, column.length(), column.scale().orElse(-1));
    }

    @Override
    public ValueConverter converter(Column column, Field fieldDefn) {
        switch (column.jdbcType()) {
            case -15: 
            case -9: 
            case 1: 
            case 12: 
            case 2002: 
            case 2005: {
                return data -> this.convertString(column, fieldDefn, data);
            }
            case 2004: {
                return data -> this.convertBinary(column, fieldDefn, data, this.binaryMode);
            }
            case 100: {
                return data -> this.convertFloat(column, fieldDefn, data);
            }
            case 101: {
                return data -> this.convertDouble(column, fieldDefn, data);
            }
            case 2: {
                return this.getNumericConverter(column, fieldDefn);
            }
            case 6: {
                return data -> this.convertVariableScale(column, fieldDefn, data);
            }
            case -102: 
            case -101: {
                return data -> this.convertTimestampWithZone(column, fieldDefn, data);
            }
            case -103: {
                return data -> this.convertIntervalYearMonth(column, fieldDefn, data);
            }
            case -104: {
                return data -> this.convertIntervalDaySecond(column, fieldDefn, data);
            }
        }
        return super.converter(column, fieldDefn);
    }

    private Object getFloatConverter(Column column, Field fieldDefn, Object data) {
        if (data instanceof BigDecimal) {
            return Float.valueOf(((BigDecimal)data).floatValue());
        }
        return this.convertVariableScale(column, fieldDefn, data);
    }

    private ValueConverter getNumericConverter(Column column, Field fieldDefn) {
        if (column.scale().isPresent()) {
            Integer scale = column.scale().get();
            if (scale <= 0) {
                int width = column.length() - scale;
                if (width < 3) {
                    return data -> this.convertNumericAsTinyInt(column, fieldDefn, data);
                }
                if (width < 5) {
                    return data -> this.convertNumericAsSmallInt(column, fieldDefn, data);
                }
                if (width < 10) {
                    return data -> this.convertNumericAsInteger(column, fieldDefn, data);
                }
                if (width < 19) {
                    return data -> this.convertNumericAsBigInteger(column, fieldDefn, data);
                }
            }
            return data -> this.convertNumeric(column, fieldDefn, data);
        }
        return data -> this.convertVariableScale(column, fieldDefn, data);
    }

    @Override
    protected Object convertString(Column column, Field fieldDefn, Object data) {
        if (data instanceof CHAR) {
            return ((CHAR)data).stringValue();
        }
        if (data instanceof CLOB) {
            return ((CLOB)data).toString();
        }
        return super.convertString(column, fieldDefn, data);
    }

    @Override
    protected Object convertBinary(Column column, Field fieldDefn, Object data, CommonConnectorConfig.BinaryHandlingMode mode) {
        if (data instanceof BLOB) {
            return ((BLOB)data).getBytes();
        }
        return super.convertBinary(column, fieldDefn, data, mode);
    }

    @Override
    protected Object convertInteger(Column column, Field fieldDefn, Object data) {
        if (data instanceof NUMBER) {
            try {
                data = ((NUMBER)data).intValue();
            }
            catch (SQLException e) {
                throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
            }
        }
        return super.convertInteger(column, fieldDefn, data);
    }

    @Override
    protected Object convertFloat(Column column, Field fieldDefn, Object data) {
        if (data instanceof Float) {
            return data;
        }
        if (data instanceof NUMBER) {
            return Float.valueOf(((NUMBER)data).floatValue());
        }
        if (data instanceof BINARY_FLOAT) {
            try {
                return Float.valueOf(((BINARY_FLOAT)data).floatValue());
            }
            catch (SQLException e) {
                throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
            }
        }
        return super.convertFloat(column, fieldDefn, data);
    }

    @Override
    protected Object convertDouble(Column column, Field fieldDefn, Object data) {
        if (data instanceof BINARY_DOUBLE) {
            try {
                return ((BINARY_DOUBLE)data).doubleValue();
            }
            catch (SQLException e) {
                throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
            }
        }
        return super.convertDouble(column, fieldDefn, data);
    }

    @Override
    protected Object convertDecimal(Column column, Field fieldDefn, Object data) {
        if (data instanceof NUMBER) {
            try {
                data = ((NUMBER)data).bigDecimalValue();
            }
            catch (SQLException e) {
                throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
            }
        }
        if (data instanceof BigDecimal) {
            data = this.withScaleAdjustedIfNeeded(column, (BigDecimal)data);
        }
        if (data instanceof Struct) {
            SpecialValueDecimal value = VariableScaleDecimal.toLogical((Struct)data);
            return value.getDecimalValue().orElse(null);
        }
        return super.convertDecimal(column, fieldDefn, data);
    }

    @Override
    protected Object convertNumeric(Column column, Field fieldDefn, Object data) {
        return this.convertDecimal(column, fieldDefn, data);
    }

    protected Object convertNumericAsTinyInt(Column column, Field fieldDefn, Object data) {
        if (data instanceof NUMBER) {
            try {
                data = ((NUMBER)data).byteValue();
            }
            catch (SQLException e) {
                throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
            }
        }
        return this.convertTinyInt(column, fieldDefn, data);
    }

    protected Object convertNumericAsSmallInt(Column column, Field fieldDefn, Object data) {
        if (data instanceof NUMBER) {
            try {
                data = ((NUMBER)data).shortValue();
            }
            catch (SQLException e) {
                throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
            }
        }
        return super.convertSmallInt(column, fieldDefn, data);
    }

    protected Object convertNumericAsInteger(Column column, Field fieldDefn, Object data) {
        if (data instanceof NUMBER) {
            try {
                data = ((NUMBER)data).intValue();
            }
            catch (SQLException e) {
                throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
            }
        }
        return super.convertInteger(column, fieldDefn, data);
    }

    protected Object convertNumericAsBigInteger(Column column, Field fieldDefn, Object data) {
        if (data instanceof NUMBER) {
            try {
                data = ((NUMBER)data).longValue();
            }
            catch (SQLException e) {
                throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
            }
        }
        return super.convertBigInt(column, fieldDefn, data);
    }

    @Override
    protected Object convertBoolean(Column column, Field fieldDefn, Object data) {
        if (data instanceof BigDecimal) {
            return ((BigDecimal)data).byteValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return super.convertBoolean(column, fieldDefn, data);
    }

    @Override
    protected Object convertTinyInt(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, NumberConversions.BYTE_FALSE, r -> {
            if (data instanceof Byte) {
                r.deliver(data);
            } else if (data instanceof Number) {
                Number value = (Number)data;
                r.deliver(value.byteValue());
            } else if (data instanceof Boolean) {
                r.deliver(NumberConversions.getByte((Boolean)data));
            } else if (data instanceof String) {
                r.deliver(Byte.parseByte((String)data));
            }
        });
    }

    protected Object convertVariableScale(Column column, Field fieldDefn, Object data) {
        if ((data = this.convertNumeric(column, fieldDefn, data)) == null) {
            return null;
        }
        if (this.decimalMode == JdbcValueConverters.DecimalMode.PRECISE) {
            if (data instanceof SpecialValueDecimal) {
                return VariableScaleDecimal.fromLogical(fieldDefn.schema(), (SpecialValueDecimal)data);
            }
            if (data instanceof BigDecimal) {
                return VariableScaleDecimal.fromLogical(fieldDefn.schema(), new SpecialValueDecimal((BigDecimal)data));
            }
        } else {
            return data;
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object fromOracleTimeClasses(Column column, Object data) {
        try {
            if (data instanceof TIMESTAMP) {
                data = ((TIMESTAMP)data).timestampValue();
            } else if (data instanceof DATE) {
                data = ((DATE)data).timestampValue();
            } else if (data instanceof TIMESTAMPTZ) {
                TIMESTAMPTZ ts = (TIMESTAMPTZ)data;
                data = ZonedDateTime.ofInstant(ts.timestampValue(this.connection.connection()).toInstant(), ts.getTimeZone().toZoneId());
            } else if (data instanceof TIMESTAMPLTZ) {
                return null;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
        }
        return data;
    }

    @Override
    protected Object convertTimestampToEpochMicros(Column column, Field fieldDefn, Object data) {
        if (data instanceof Long) {
            return data;
        }
        return super.convertTimestampToEpochMicros(column, fieldDefn, this.fromOracleTimeClasses(column, data));
    }

    @Override
    protected Object convertTimestampToEpochMillis(Column column, Field fieldDefn, Object data) {
        return super.convertTimestampToEpochMillis(column, fieldDefn, this.fromOracleTimeClasses(column, data));
    }

    @Override
    protected Object convertTimestampToEpochNanos(Column column, Field fieldDefn, Object data) {
        return super.convertTimestampToEpochNanos(column, fieldDefn, this.fromOracleTimeClasses(column, data));
    }

    @Override
    protected Object convertTimestampWithZone(Column column, Field fieldDefn, Object data) {
        return super.convertTimestampWithZone(column, fieldDefn, this.fromOracleTimeClasses(column, data));
    }

    protected Object convertIntervalYearMonth(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, NumberConversions.LONG_FALSE, r -> {
            if (data instanceof Number) {
                r.deliver(((Number)data).longValue());
            } else if (data instanceof INTERVALYM) {
                String interval = ((INTERVALYM)data).stringValue();
                int sign = 1;
                int start = 0;
                if (interval.charAt(0) == '-') {
                    sign = -1;
                    start = 1;
                }
                for (int i = 1; i < interval.length(); ++i) {
                    if (interval.charAt(i) != '-') continue;
                    int year = sign * Integer.parseInt(interval.substring(start, i));
                    int month = sign * Integer.parseInt(interval.substring(i + 1, interval.length()));
                    r.deliver(MicroDuration.durationMicros(year, month, 0, 0, 0, 0.0, 30.4375));
                }
            }
        });
    }

    protected Object convertIntervalDaySecond(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, NumberConversions.LONG_FALSE, r -> {
            String interval;
            Matcher m;
            if (data instanceof Number) {
                r.deliver(((Number)data).longValue());
            } else if (data instanceof INTERVALDS && (m = INTERVAL_DAY_SECOND_PATTERN.matcher(interval = ((INTERVALDS)data).stringValue())).matches()) {
                int sign = "-".equals(m.group(1)) ? -1 : 1;
                r.deliver(MicroDuration.durationMicros(0, 0, sign * Integer.valueOf(m.group(2)), sign * Integer.valueOf(m.group(3)), sign * Integer.valueOf(m.group(4)), sign * Integer.valueOf(m.group(5)), sign * Integer.valueOf(Strings.pad(m.group(6), 6, '0')), 30.4375));
            }
        });
    }
}

