/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr.listener;

import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.oracle.antlr.listener.BaseParserListener;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.TableEditor;

public class ColumnDefinitionParserListener
extends BaseParserListener {
    private final DataTypeResolver dataTypeResolver;
    private final TableEditor tableEditor;
    private ColumnEditor columnEditor;

    ColumnDefinitionParserListener(TableEditor tableEditor, ColumnEditor columnEditor, DataTypeResolver dataTypeResolver) {
        this.dataTypeResolver = dataTypeResolver;
        this.tableEditor = tableEditor;
        this.columnEditor = columnEditor;
    }

    void setColumnEditor(ColumnEditor columnEditor) {
        this.columnEditor = columnEditor;
    }

    Column getColumn() {
        return this.columnEditor.create();
    }

    @Override
    public void enterColumn_definition(PlSqlParser.Column_definitionContext ctx) {
        this.resolveColumnDataType(ctx);
        super.enterColumn_definition(ctx);
    }

    @Override
    public void enterPrimary_key_clause(PlSqlParser.Primary_key_clauseContext ctx) {
        this.columnEditor.optional(false);
        this.tableEditor.addColumn(this.columnEditor.create());
        this.tableEditor.setPrimaryKeyNames(this.columnEditor.name());
        super.enterPrimary_key_clause(ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void resolveColumnDataType(PlSqlParser.Column_definitionContext ctx) {
        this.columnEditor.name(this.getColumnName(ctx.column_name()));
        PlSqlParser.Precision_partContext precisionPart = null;
        if (ctx.datatype() != null) {
            precisionPart = ctx.datatype().precision_part();
        }
        if (ctx.datatype() == null) {
            if (ctx.type_name() != null && "\"MDSYS\".\"SDO_GEOMETRY\"".equalsIgnoreCase(ctx.type_name().getText())) {
                this.columnEditor.jdbcType(2002).type("MDSYS.SDO_GEOMETRY");
            }
        } else if (ctx.datatype().native_datatype_element() != null) {
            if (ctx.datatype().native_datatype_element().INT() != null || ctx.datatype().native_datatype_element().INTEGER() != null || ctx.datatype().native_datatype_element().SMALLINT() != null || ctx.datatype().native_datatype_element().NUMERIC() != null || ctx.datatype().native_datatype_element().DECIMAL() != null) {
                this.columnEditor.jdbcType(2).type("NUMBER");
                if (precisionPart == null) {
                    this.columnEditor.length(38).scale(0);
                } else {
                    this.setPrecision(precisionPart, this.columnEditor);
                    this.setScale(precisionPart, this.columnEditor);
                }
            } else if (ctx.datatype().native_datatype_element().DATE() != null) {
                this.columnEditor.jdbcType(93).type("DATE");
            } else if (ctx.datatype().native_datatype_element().TIMESTAMP() != null) {
                if (ctx.datatype().WITH() != null && ctx.datatype().TIME() != null && ctx.datatype().ZONE() != null) {
                    if (ctx.datatype().LOCAL() != null) {
                        this.columnEditor.jdbcType(-102).type("TIMESTAMP WITH LOCAL TIME ZONE");
                    } else {
                        this.columnEditor.jdbcType(-101).type("TIMESTAMP WITH TIME ZONE");
                    }
                } else {
                    this.columnEditor.jdbcType(93).type("TIMESTAMP");
                }
                if (precisionPart == null) {
                    this.columnEditor.length(6);
                } else {
                    this.setPrecision(precisionPart, this.columnEditor);
                }
            } else if (ctx.datatype().native_datatype_element().VARCHAR2() != null || ctx.datatype().native_datatype_element().VARCHAR() != null) {
                this.columnEditor.jdbcType(12).type("VARCHAR2");
                if (precisionPart == null) {
                    this.columnEditor.length(this.getVarCharDefaultLength());
                } else {
                    this.setPrecision(precisionPart, this.columnEditor);
                }
            } else if (ctx.datatype().native_datatype_element().NVARCHAR2() != null) {
                this.columnEditor.jdbcType(-9).type("NVARCHAR2");
                if (precisionPart == null) {
                    this.columnEditor.length(this.getVarCharDefaultLength());
                } else {
                    this.setPrecision(precisionPart, this.columnEditor);
                }
            } else if (ctx.datatype().native_datatype_element().CHAR() != null) {
                this.columnEditor.jdbcType(1).type("CHAR").length(1);
            } else if (ctx.datatype().native_datatype_element().NCHAR() != null) {
                this.columnEditor.jdbcType(-15).type("NCHAR").length(1);
            } else if (ctx.datatype().native_datatype_element().BINARY_FLOAT() != null) {
                this.columnEditor.jdbcType(100).type("BINARY_FLOAT");
            } else if (ctx.datatype().native_datatype_element().BINARY_DOUBLE() != null) {
                this.columnEditor.jdbcType(101).type("BINARY_DOUBLE");
            } else if (ctx.datatype().native_datatype_element().FLOAT() != null || ctx.datatype().native_datatype_element().DOUBLE() != null && ctx.datatype().native_datatype_element().PRECISION() != null) {
                this.columnEditor.jdbcType(6).type("FLOAT").length(126);
                if (precisionPart != null) {
                    this.setPrecision(precisionPart, this.columnEditor);
                }
            } else if (ctx.datatype().native_datatype_element().REAL() != null) {
                this.columnEditor.jdbcType(6).type("FLOAT").length(63);
            } else if (ctx.datatype().native_datatype_element().NUMBER() != null) {
                this.columnEditor.jdbcType(2).type("NUMBER");
                if (precisionPart == null) {
                    this.columnEditor.length(38);
                } else {
                    this.setPrecision(precisionPart, this.columnEditor);
                    this.setScale(precisionPart, this.columnEditor);
                }
            } else if (ctx.datatype().native_datatype_element().BLOB() != null) {
                this.columnEditor.jdbcType(2004).type("BLOB");
            } else {
                if (ctx.datatype().native_datatype_element().CLOB() == null) throw new IllegalArgumentException("Unsupported column type: " + ctx.datatype().native_datatype_element().getText());
                this.columnEditor.jdbcType(2005).type("CLOB");
            }
        } else if (ctx.datatype().INTERVAL() != null && ctx.datatype().YEAR() != null && ctx.datatype().TO() != null && ctx.datatype().MONTH() != null) {
            this.columnEditor.jdbcType(-103).type("INTERVAL YEAR TO MONTH").length(2);
            if (!ctx.datatype().expression().isEmpty()) {
                this.columnEditor.length(Integer.valueOf(ctx.datatype().expression(0).getText()));
            }
        } else {
            if (ctx.datatype().INTERVAL() == null || ctx.datatype().DAY() == null || ctx.datatype().TO() == null || ctx.datatype().SECOND() == null) throw new IllegalArgumentException("Unsupported column type: " + ctx.datatype().getText());
            this.columnEditor.jdbcType(-104).type("INTERVAL DAY TO SECOND").length(2).scale(6);
            for (PlSqlParser.ExpressionContext e : ctx.datatype().expression()) {
                if (e.getSourceInterval().startsAfter(ctx.datatype().TO().getSourceInterval())) {
                    this.columnEditor.scale(Integer.valueOf(e.getText()));
                    continue;
                }
                this.columnEditor.length(Integer.valueOf(e.getText()));
            }
            if (!ctx.datatype().expression().isEmpty()) {
                this.columnEditor.length(Integer.valueOf(ctx.datatype().expression(0).getText()));
            }
        }
        boolean hasNotNullConstraint = ctx.inline_constraint().stream().anyMatch(c -> c.NOT() != null);
        if (ctx.DEFAULT() != null) {
            String defaultValue = ctx.expression().getText();
            this.columnEditor.defaultValue(defaultValue);
        }
        this.columnEditor.optional(!hasNotNullConstraint);
    }

    private int getVarCharDefaultLength() {
        return 4000;
    }

    private void setPrecision(PlSqlParser.Precision_partContext precisionPart, ColumnEditor columnEditor) {
        columnEditor.length(Integer.valueOf(precisionPart.numeric(0).getText()));
    }

    private void setScale(PlSqlParser.Precision_partContext precisionPart, ColumnEditor columnEditor) {
        if (precisionPart.numeric().size() > 1) {
            columnEditor.scale(Integer.valueOf(precisionPart.numeric(1).getText()));
        } else if (precisionPart.numeric_negative() != null) {
            columnEditor.scale(Integer.valueOf(precisionPart.numeric_negative().getText()));
        } else {
            columnEditor.scale(0);
        }
    }
}

