/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr.listener;

import io.debezium.connector.oracle.logminer.OracleChangeRecordValueConverter;
import io.debezium.connector.oracle.logminer.valueholder.LogMinerColumnValueWrapper;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.ValueConverter;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class ParserUtils {
    private ParserUtils() {
    }

    public static String getColumnName(PlSqlParser.Column_nameContext ctx) {
        return ParserUtils.stripeQuotes(ctx.identifier().id_expression().getText());
    }

    public static String stripeQuotes(String text) {
        if (text != null && text.indexOf("\"") == 0 && text.lastIndexOf("\"") == text.length() - 1) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static String stripeAlias(String text, String alias) {
        int index = text.indexOf(alias + ".");
        if (index >= 0) {
            return text.substring(alias.length() + 1);
        }
        return text;
    }

    public static void cloneOldToNewColumnValues(Map<String, LogMinerColumnValueWrapper> newColumnValues, Map<String, LogMinerColumnValueWrapper> oldColumnValues, Table table) {
        for (Column column : table.columns()) {
            LogMinerColumnValueWrapper newColumnValue = newColumnValues.get(column.name());
            if (newColumnValue.isProcessed()) continue;
            LogMinerColumnValueWrapper oldColumnValue = oldColumnValues.get(column.name());
            newColumnValue.setProcessed(true);
            newColumnValue.getColumnValue().setColumnData(oldColumnValue.getColumnValue().getColumnData());
        }
    }

    public static Object convertValueToSchemaType(Column column, Object value, OracleChangeRecordValueConverter converters) {
        if (converters != null && value != null) {
            SchemaBuilder schemaBuilder = converters.schemaBuilder(column);
            if (schemaBuilder == null) {
                return null;
            }
            Schema schema = schemaBuilder.build();
            Field field = new Field(column.name(), 1, schema);
            ValueConverter valueConverter = converters.converter(column, field);
            return valueConverter.convert(value);
        }
        return null;
    }

    public static String removeApostrophes(String text) {
        if (text != null && text.indexOf("'") == 0 && text.lastIndexOf("'") == text.length() - 1) {
            return text.substring(1, text.length() - 1);
        }
        if ("null".equalsIgnoreCase(text)) {
            return null;
        }
        return text;
    }

    public static String replaceDoubleBackSlashes(String text) {
        if (text != null && text.contains("\\\\")) {
            return text.replaceAll("\\\\\\\\", "\\\\");
        }
        return text;
    }

    static String getTableName(PlSqlParser.Tableview_nameContext tableview_name) {
        if (tableview_name.id_expression() != null) {
            return ParserUtils.stripeQuotes(tableview_name.id_expression().getText());
        }
        return ParserUtils.stripeQuotes(tableview_name.identifier().id_expression().getText());
    }
}

