/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.logminer.LogMinerMetrics;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.connector.oracle.logminer.TransactionalBufferMetrics;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMinerHelper {
    private static final String UNKNOWN = "unknown";
    private static final String TOTAL = "TOTAL";
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerHelper.class);
    private static Map<String, OracleConnection> racFlushConnections = new HashMap<String, OracleConnection>();

    static void instantiateFlushConnections(JdbcConfiguration config, Set<String> hosts) {
        for (OracleConnection conn : racFlushConnections.values()) {
            if (conn == null) continue;
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOGGER.warn("Cannot close existing RAC flush connection", (Throwable)e);
            }
        }
        racFlushConnections = new HashMap<String, OracleConnection>();
        for (String host : hosts) {
            try {
                racFlushConnections.put(host, LogMinerHelper.createFlushConnection(config, host));
            }
            catch (SQLException e) {
                LOGGER.error("Cannot connect to RAC node {}", (Object)host, (Object)e);
            }
        }
    }

    static void buildDataDictionary(Connection connection) throws SQLException {
        LogMinerHelper.executeCallableStatement(connection, "BEGIN DBMS_LOGMNR_D.BUILD (options => DBMS_LOGMNR_D.STORE_IN_REDO_LOGS); END;");
    }

    /*
     * Exception decompiling
     */
    public static long getCurrentScn(Connection connection) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static void createFlushTable(Connection connection) throws SQLException {
        String recordExists;
        String tableExists = (String)LogMinerHelper.getSingleResult(connection, SqlUtils.tableExistsQuery("LOG_MINING_FLUSH"), DATATYPE.STRING);
        if (tableExists == null) {
            LogMinerHelper.executeCallableStatement(connection, "CREATE TABLE LOG_MINING_FLUSH(LAST_SCN NUMBER(19,0))");
        }
        if ((recordExists = (String)LogMinerHelper.getSingleResult(connection, "SELECT '1' AS ONE FROM LOG_MINING_FLUSH", DATATYPE.STRING)) == null) {
            LogMinerHelper.executeCallableStatement(connection, "INSERT INTO LOG_MINING_FLUSH VALUES(0)");
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
    }

    static void createLogMiningHistoryObjects(Connection connection, String historyTableName) throws SQLException {
        String sequenceExists;
        String tableExists = (String)LogMinerHelper.getSingleResult(connection, SqlUtils.tableExistsQuery("LOG_MINING_TEMP"), DATATYPE.STRING);
        if (tableExists == null) {
            LogMinerHelper.executeCallableStatement(connection, SqlUtils.logMiningHistoryDdl("LOG_MINING_TEMP"));
        }
        if ((tableExists = (String)LogMinerHelper.getSingleResult(connection, SqlUtils.tableExistsQuery(historyTableName), DATATYPE.STRING)) == null) {
            LogMinerHelper.executeCallableStatement(connection, SqlUtils.logMiningHistoryDdl(historyTableName));
        }
        if ((sequenceExists = (String)LogMinerHelper.getSingleResult(connection, "SELECT '1' AS ONE FROM USER_SEQUENCES WHERE SEQUENCE_NAME = 'LOG_MINING_HIST_SEQ'", DATATYPE.STRING)) == null) {
            LogMinerHelper.executeCallableStatement(connection, "CREATE SEQUENCE LOG_MINING_HIST_SEQ ORDER CACHE 10000");
        }
    }

    static void deleteOutdatedHistory(Connection connection, long retention) throws SQLException {
        Set<String> tableNames = LogMinerHelper.getMap(connection, SqlUtils.getHistoryTableNamesQuery(), "-1").keySet();
        for (String tableName : tableNames) {
            long hoursAgo = SqlUtils.parseRetentionFromName(tableName);
            if (hoursAgo <= retention) continue;
            LOGGER.info("Deleting history table {}", (Object)tableName);
            LogMinerHelper.executeCallableStatement(connection, SqlUtils.dropHistoryTableStatement(tableName));
        }
    }

    static long getEndScn(Connection connection, long startScn, LogMinerMetrics metrics) throws SQLException {
        long currentScn = LogMinerHelper.getCurrentScn(connection);
        metrics.setCurrentScn(currentScn);
        long topScnToMine = startScn + (long)metrics.getBatchSize();
        boolean topMiningScnInFarFuture = false;
        if (topScnToMine - currentScn > 20000L) {
            metrics.changeBatchSize(false);
            topMiningScnInFarFuture = true;
        }
        if (currentScn - topScnToMine > 20000L) {
            metrics.changeBatchSize(true);
        }
        if (currentScn < topScnToMine) {
            if (!topMiningScnInFarFuture) {
                metrics.changeSleepingTime(true);
            }
            return currentScn;
        }
        metrics.changeSleepingTime(false);
        return topScnToMine;
    }

    static void flushLogWriter(Connection connection, JdbcConfiguration config, boolean isRac, Set<String> racHosts) throws SQLException {
        long currentScn = LogMinerHelper.getCurrentScn(connection);
        if (isRac) {
            LogMinerHelper.flushRacLogWriters(currentScn, config, racHosts);
        } else {
            LogMinerHelper.executeCallableStatement(connection, "UPDATE LOG_MINING_FLUSH SET LAST_SCN =" + currentScn);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
    }

    static Duration getTimeDifference(Connection connection) throws SQLException {
        Timestamp dbCurrentMillis = (Timestamp)LogMinerHelper.getSingleResult(connection, "SELECT CURRENT_TIMESTAMP FROM DUAL", DATATYPE.TIMESTAMP);
        if (dbCurrentMillis == null) {
            return Duration.ZERO;
        }
        Instant fromDb = dbCurrentMillis.toInstant();
        Instant now = Instant.now();
        return Duration.between(fromDb, now);
    }

    static void startLogMining(Connection connection, Long startScn, Long endScn, OracleConnectorConfig.LogMiningStrategy strategy, boolean isContinuousMining) throws SQLException {
        String statement = SqlUtils.startLogMinerStatement(startScn, endScn, strategy, isContinuousMining);
        LogMinerHelper.executeCallableStatement(connection, statement);
    }

    static Set<String> getCurrentRedoLogFiles(Connection connection, LogMinerMetrics metrics) throws SQLException {
        HashSet<String> fileNames = new HashSet<String>();
        try (PreparedStatement st = connection.prepareStatement(SqlUtils.currentRedoNameQuery());
             ResultSet result = st.executeQuery();){
            while (result.next()) {
                fileNames.add(result.getString(1));
                LOGGER.trace(" Current Redo log fileName: {} ", fileNames);
            }
        }
        LogMinerHelper.updateRedoLogMetrics(connection, metrics, fileNames);
        return fileNames;
    }

    static long getFirstOnlineLogScn(Connection connection, Duration archiveLogRetention) throws SQLException {
        LOGGER.trace("getting first scn of all online logs");
        Statement s = connection.createStatement();
        ResultSet res = s.executeQuery(SqlUtils.oldestFirstChangeQuery(archiveLogRetention));
        res.next();
        long firstScnOfOnlineLog = res.getLong(1);
        res.close();
        return firstScnOfOnlineLog;
    }

    static void setNlsSessionParameters(JdbcConnection connection) throws SQLException {
        connection.executeWithoutCommitting("ALTER SESSION SET   NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'  NLS_TIMESTAMP_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF'  NLS_TIMESTAMP_TZ_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF TZH:TZM'  NLS_NUMERIC_CHARACTERS = '.,'");
    }

    private static void updateRedoLogMetrics(Connection connection, LogMinerMetrics metrics, Set<String> fileNames) {
        try {
            Map<String, String> logStatuses = LogMinerHelper.getRedoLogStatus(connection);
            metrics.setRedoLogStatus(logStatuses);
            int counter = LogMinerHelper.getSwitchCount(connection);
            metrics.setSwitchCount(counter);
            metrics.setCurrentLogFileName(fileNames);
        }
        catch (SQLException e) {
            LOGGER.error("Cannot update metrics");
        }
    }

    private static Map<String, String> getRedoLogStatus(Connection connection) throws SQLException {
        return LogMinerHelper.getMap(connection, SqlUtils.redoLogStatusQuery(), UNKNOWN);
    }

    private static int getSwitchCount(Connection connection) {
        try {
            Map<String, String> total = LogMinerHelper.getMap(connection, SqlUtils.switchHistoryQuery(), UNKNOWN);
            if (total != null && total.get(TOTAL) != null) {
                return Integer.parseInt(total.get(TOTAL));
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot get switch counter", (Throwable)e);
        }
        return 0;
    }

    private static void flushRacLogWriters(long currentScn, JdbcConfiguration config, Set<String> racHosts) {
        Instant startTime = Instant.now();
        if (racHosts.isEmpty()) {
            throw new RuntimeException("No RAC node ip addresses were supplied in the configuration");
        }
        boolean errors = false;
        for (String host : racHosts) {
            try {
                OracleConnection conn = racFlushConnections.get(host);
                if (conn == null) {
                    LOGGER.warn("Connection to the node {} was not instantiated", (Object)host);
                    errors = true;
                    continue;
                }
                LOGGER.trace("Flushing Log Writer buffer of node {}", (Object)host);
                LogMinerHelper.executeCallableStatement(conn.connection(), "UPDATE LOG_MINING_FLUSH SET LAST_SCN =" + currentScn);
                conn.commit();
            }
            catch (Exception e) {
                LOGGER.warn("Cannot flush Log Writer buffer of the node {} due to {}", (Object)host, (Object)e);
                errors = true;
            }
        }
        if (errors) {
            LogMinerHelper.instantiateFlushConnections(config, racHosts);
            LOGGER.warn("Not all LogWriter buffers were flushed. Sleeping for 3 seconds to let Oracle do the flush.", racHosts);
            Metronome metronome = Metronome.sleeper(Duration.ofMillis(3000L), Clock.system());
            try {
                metronome.pause();
            }
            catch (InterruptedException e) {
                LOGGER.warn("Metronome was interrupted");
            }
        }
        LOGGER.trace("Flushing RAC Log Writers took {} ", (Object)Duration.between(startTime, Instant.now()));
    }

    private static OracleConnection createFlushConnection(JdbcConfiguration config, String host) throws SQLException {
        JdbcConfiguration hostConfig = JdbcConfiguration.adapt(((Configuration.Builder)config.edit().with(JdbcConfiguration.DATABASE, host)).build());
        OracleConnection connection = new OracleConnection((Configuration)hostConfig, () -> LogMinerHelper.class.getClassLoader());
        connection.setAutoCommit(false);
        return connection;
    }

    static void checkSupplementalLogging(OracleConnection connection, String pdbName) throws SQLException {
        try {
            Map<String, String> globalLogging;
            if (pdbName != null) {
                connection.setSessionToPdb(pdbName);
            }
            if ("no".equalsIgnoreCase((globalLogging = LogMinerHelper.getMap(connection.connection(false), SqlUtils.supplementalLoggingCheckQuery(), UNKNOWN)).get("KEY"))) {
                throw new RuntimeException("Supplemental logging was not set. Use command: ALTER DATABASE ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS");
            }
        }
        finally {
            if (pdbName != null) {
                connection.resetSessionToCdb();
            }
        }
    }

    public static void endMining(Connection connection) {
        String stopMining = "BEGIN SYS.DBMS_LOGMNR.END_LOGMNR(); END;";
        try {
            LogMinerHelper.executeCallableStatement(connection, stopMining);
        }
        catch (SQLException e) {
            if (e.getMessage().toUpperCase().contains("ORA-01307")) {
                LOGGER.info("Log Miner session was already closed");
            }
            LOGGER.error("Cannot close Log Miner session gracefully: {}", (Throwable)e);
        }
    }

    public static void setRedoLogFilesForMining(Connection connection, Long lastProcessedScn, Duration archiveLogRetention) throws SQLException {
        LogMinerHelper.removeLogFilesFromMining(connection);
        Map<String, Long> onlineLogFilesForMining = LogMinerHelper.getOnlineLogFilesForOffsetScn(connection, lastProcessedScn);
        Map<String, Long> archivedLogFilesForMining = LogMinerHelper.getArchivedLogFilesForOffsetScn(connection, lastProcessedScn, archiveLogRetention);
        if (onlineLogFilesForMining.size() + archivedLogFilesForMining.size() == 0) {
            throw new IllegalStateException("None of log files contains offset SCN: " + lastProcessedScn + ", re-snapshot is required.");
        }
        List logFilesNames = onlineLogFilesForMining.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
        List archivedLogFiles = archivedLogFilesForMining.entrySet().stream().filter(e -> !onlineLogFilesForMining.values().contains(e.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        logFilesNames.addAll(archivedLogFiles);
        for (String file : logFilesNames) {
            String addLogFileStatement = SqlUtils.addLogFileStatement("DBMS_LOGMNR.ADDFILE", file);
            LogMinerHelper.executeCallableStatement(connection, addLogFileStatement);
            LOGGER.trace("add log file to the mining session = {}", (Object)file);
        }
        LOGGER.debug("Last mined SCN: {}, Log file list to mine: {}\n", (Object)lastProcessedScn, logFilesNames);
    }

    public static Optional<Long> getLastScnToAbandon(Connection connection, Long offsetScn, int hoursToKeepTransaction) {
        try {
            String query = SqlUtils.diffInDaysQuery(offsetScn);
            Float diffInDays = (Float)LogMinerHelper.getSingleResult(connection, query, DATATYPE.FLOAT);
            if (diffInDays != null && diffInDays.floatValue() * 24.0f > (float)hoursToKeepTransaction) {
                return Optional.of(offsetScn);
            }
            return Optional.empty();
        }
        catch (SQLException e) {
            LOGGER.error("Cannot calculate days difference due to {}", (Throwable)e);
            return Optional.of(offsetScn);
        }
    }

    static void logWarn(TransactionalBufferMetrics metrics, String format, Object ... args) {
        LOGGER.warn(format, args);
        metrics.incrementWarningCounter();
    }

    static void logError(TransactionalBufferMetrics metrics, String format, Object ... args) {
        LOGGER.error(format, args);
        metrics.incrementErrorCounter();
    }

    private static int getRedoLogGroupSize(Connection connection) throws SQLException {
        return LogMinerHelper.getMap(connection, SqlUtils.allOnlineLogsQuery(), "-1").size();
    }

    public static Map<String, Long> getOnlineLogFilesForOffsetScn(Connection connection, Long offsetScn) throws SQLException {
        Map<String, String> redoLogFiles = LogMinerHelper.getMap(connection, SqlUtils.allOnlineLogsQuery(), "-1");
        return redoLogFiles.entrySet().stream().filter(entry -> new BigInteger((String)entry.getValue()).longValue() > offsetScn || new BigInteger((String)entry.getValue()).longValue() == -1L).collect(Collectors.toMap(Map.Entry::getKey, e -> new BigInteger((String)e.getValue()).longValue() == -1L ? Long.MAX_VALUE : new BigInteger((String)e.getValue()).longValue()));
    }

    public static Map<String, Long> getArchivedLogFilesForOffsetScn(Connection connection, Long offsetScn, Duration archiveLogRetention) throws SQLException {
        Map<String, String> redoLogFiles = LogMinerHelper.getMap(connection, SqlUtils.archiveLogsQuery(offsetScn, archiveLogRetention), "-1");
        return redoLogFiles.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new BigDecimal((String)e.getValue()).longValue() == -1L ? Long.MAX_VALUE : new BigDecimal((String)e.getValue()).longValue()));
    }

    public static void removeLogFilesFromMining(Connection conn) throws SQLException {
        try (PreparedStatement ps = conn.prepareStatement("SELECT FILENAME AS NAME FROM V$LOGMNR_LOGS");
             ResultSet result = ps.executeQuery();){
            while (result.next()) {
                String fileName = result.getString(1);
                LogMinerHelper.executeCallableStatement(conn, SqlUtils.deleteLogFileStatement(fileName));
                LOGGER.debug("File {} was removed from mining", (Object)fileName);
            }
        }
    }

    private static void executeCallableStatement(Connection connection, String statement) throws SQLException {
        Objects.requireNonNull(statement);
        try (CallableStatement s = connection.prepareCall(statement);){
            s.execute();
        }
    }

    /*
     * Exception decompiling
     */
    public static Map<String, String> getMap(Connection connection, String query, String nullReplacement) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Object getSingleResult(Connection connection, String query, DATATYPE type) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 27[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static enum DATATYPE {
        LONG,
        TIMESTAMP,
        STRING,
        FLOAT;

    }
}

