/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.config.Configuration;
import io.debezium.connector.postgresql.Module;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresConnectorTask;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.util.Strings;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresConnector
extends SourceConnector {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, String> props;

    @Override
    public String version() {
        return Module.version();
    }

    @Override
    public Class<? extends Task> taskClass() {
        return PostgresConnectorTask.class;
    }

    @Override
    public void start(Map<String, String> props) {
        this.props = props;
    }

    @Override
    public List<Map<String, String>> taskConfigs(int maxTasks) {
        return this.props == null ? Collections.emptyList() : Collections.singletonList(new HashMap<String, String>(this.props));
    }

    @Override
    public void stop() {
        this.props = null;
    }

    @Override
    public ConfigDef config() {
        return PostgresConnectorConfig.configDef();
    }

    @Override
    public Config validate(Map<String, String> connectorConfigs) {
        PostgresConnectorConfig config = new PostgresConnectorConfig(Configuration.from(connectorConfigs));
        Map<String, ConfigValue> results = config.validate();
        ConfigValue hostnameResult = results.get(PostgresConnectorConfig.HOSTNAME.name());
        ConfigValue portResult = results.get(PostgresConnectorConfig.PORT.name());
        ConfigValue databaseNameResult = results.get(PostgresConnectorConfig.DATABASE_NAME.name());
        ConfigValue userResult = results.get(PostgresConnectorConfig.USER.name());
        ConfigValue passwordResult = results.get(PostgresConnectorConfig.PASSWORD.name());
        ConfigValue slotNameResult = results.get(PostgresConnectorConfig.SLOT_NAME.name());
        ConfigValue pluginNameResult = results.get(PostgresConnectorConfig.PLUGIN_NAME.name());
        String passwordStringValue = config.getConfig().getString(PostgresConnectorConfig.PASSWORD);
        if (Strings.isNullOrEmpty(passwordStringValue)) {
            this.logger.warn("The connection password is empty");
        }
        if (hostnameResult.errorMessages().isEmpty() && portResult.errorMessages().isEmpty() && userResult.errorMessages().isEmpty() && passwordResult.errorMessages().isEmpty() && databaseNameResult.errorMessages().isEmpty() && slotNameResult.errorMessages().isEmpty() && pluginNameResult.errorMessages().isEmpty()) {
            try (PostgresConnection connection = new PostgresConnection(config.jdbcConfig());){
                try {
                    String slotName;
                    String errorMessage;
                    connection.execute("SELECT version()");
                    this.logger.info("Successfully tested connection for {} with user '{}'", (Object)connection.connectionString(), (Object)connection.username());
                    String walLevel = connection.queryAndMap("SHOW wal_level", connection.singleResultMapper(rs -> rs.getString("wal_level"), "Could not fetch wal_level"));
                    if (!"logical".equals(walLevel)) {
                        errorMessage = "Postgres server wal_level property must be \"logical\" but is: " + walLevel;
                        this.logger.error(errorMessage);
                        hostnameResult.addErrorMessage(errorMessage);
                    }
                    if (!connection.queryAndMap("SELECT r.rolcanlogin AS rolcanlogin, r.rolreplication AS rolreplication, CAST(array_position(ARRAY(SELECT b.rolname FROM pg_catalog.pg_auth_members m JOIN pg_catalog.pg_roles b ON (m.roleid = b.oid) WHERE m.member = r.oid), 'rds_superuser') AS BOOL) IS TRUE AS aws_superuser, CAST(array_position(ARRAY(SELECT b.rolname FROM pg_catalog.pg_auth_members m JOIN pg_catalog.pg_roles b ON (m.roleid = b.oid) WHERE m.member = r.oid), 'rdsadmin') AS BOOL) IS TRUE AS aws_admin, CAST(array_position(ARRAY(SELECT b.rolname FROM pg_catalog.pg_auth_members m JOIN pg_catalog.pg_roles b ON (m.roleid = b.oid) WHERE m.member = r.oid), 'rdsrepladmin') AS BOOL) IS TRUE AS aws_repladmin FROM pg_roles r WHERE r.rolname = current_user", connection.singleResultMapper(rs -> rs.getBoolean("rolcanlogin") && (rs.getBoolean("rolreplication") || rs.getBoolean("aws_superuser") || rs.getBoolean("aws_admin") || rs.getBoolean("aws_repladmin")), "Could not fetch roles")).booleanValue()) {
                        errorMessage = "Postgres roles LOGIN and REPLICATION are not assigned to user: " + connection.username();
                        this.logger.error(errorMessage);
                    }
                    if (connection.prepareQueryAndMap("SELECT * FROM pg_replication_slots WHERE slot_name = ?", arg_0 -> PostgresConnector.lambda$validate$2(slotName = config.slotName(), arg_0), rs -> {
                        if (rs.next()) {
                            return rs.getBoolean("active");
                        }
                        return false;
                    }).booleanValue()) {
                        String errorMessage2 = "Slot name \"" + slotName + "\" already exists and is active. Choose a unique name or stop the other process occupying the slot.";
                        this.logger.error(errorMessage2);
                        slotNameResult.addErrorMessage(errorMessage2);
                    }
                }
                catch (SQLException e) {
                    this.logger.error("Failed testing connection for {} with user '{}': {}", new Object[]{connection.connectionString(), connection.username(), e.getMessage()});
                    hostnameResult.addErrorMessage("Error while validating connector config: " + e.getMessage());
                }
            }
        }
        return new Config(new ArrayList<ConfigValue>(results.values()));
    }

    private static /* synthetic */ void lambda$validate$2(String slotName, PreparedStatement statement) throws SQLException {
        statement.setString(1, slotName);
    }
}

