/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import io.debezium.connector.postgresql.PostgresStreamingChangeEventSource;
import io.debezium.connector.postgresql.PostgresType;
import io.debezium.connector.postgresql.TypeRegistry;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.List;
import org.postgresql.geometric.PGbox;
import org.postgresql.geometric.PGcircle;
import org.postgresql.geometric.PGline;
import org.postgresql.geometric.PGpath;
import org.postgresql.geometric.PGpoint;
import org.postgresql.geometric.PGpolygon;
import org.postgresql.util.PGmoney;

public interface ReplicationMessage {
    public Operation getOperation();

    public Instant getCommitTime();

    public long getTransactionId();

    public String getTable();

    public List<Column> getOldTupleList();

    public List<Column> getNewTupleList();

    public boolean hasTypeMetadata();

    public boolean isLastEventForLsn();

    default public boolean shouldSchemaBeSynchronized() {
        return true;
    }

    default public boolean isTransactionalMessage() {
        return this.getOperation() == Operation.BEGIN || this.getOperation() == Operation.COMMIT;
    }

    public static class NoopMessage
    implements ReplicationMessage {
        private final long transactionId;
        private final Instant commitTime;
        private final Operation operation = Operation.NOOP;

        public NoopMessage(long transactionId, Instant commitTime) {
            this.transactionId = transactionId;
            this.commitTime = commitTime;
        }

        @Override
        public boolean isLastEventForLsn() {
            return true;
        }

        @Override
        public boolean hasTypeMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getTransactionId() {
            return this.transactionId;
        }

        @Override
        public String getTable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Operation getOperation() {
            return this.operation;
        }

        @Override
        public List<Column> getOldTupleList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Column> getNewTupleList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getCommitTime() {
            return this.commitTime;
        }
    }

    public static class TransactionMessage
    implements ReplicationMessage {
        private final long transationId;
        private final Instant commitTime;
        private final Operation operation;

        public TransactionMessage(Operation operation, long transactionId, Instant commitTime) {
            this.operation = operation;
            this.transationId = transactionId;
            this.commitTime = commitTime;
        }

        @Override
        public boolean isLastEventForLsn() {
            return true;
        }

        @Override
        public boolean hasTypeMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getTransactionId() {
            return this.transationId;
        }

        @Override
        public String getTable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Operation getOperation() {
            return this.operation;
        }

        @Override
        public List<Column> getOldTupleList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Column> getNewTupleList() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getCommitTime() {
            return this.commitTime;
        }
    }

    public static interface ColumnValue<T> {
        public T getRawValue();

        public boolean isNull();

        public String asString();

        public Boolean asBoolean();

        public Integer asInteger();

        public Long asLong();

        public Float asFloat();

        public Double asDouble();

        public Object asDecimal();

        public LocalDate asLocalDate();

        public OffsetDateTime asOffsetDateTimeAtUtc();

        public Instant asInstant();

        public Object asTime();

        public Object asLocalTime();

        public OffsetTime asOffsetTimeUtc();

        public byte[] asByteArray();

        public PGbox asBox();

        public PGcircle asCircle();

        public Object asInterval();

        public PGline asLine();

        public Object asLseg();

        public PGmoney asMoney();

        public PGpath asPath();

        public PGpoint asPoint();

        public PGpolygon asPolygon();

        public boolean isArray(PostgresType var1);

        public Object asArray(String var1, PostgresType var2, String var3, PostgresStreamingChangeEventSource.PgConnectionSupplier var4);

        public Object asDefault(TypeRegistry var1, int var2, String var3, String var4, boolean var5, PostgresStreamingChangeEventSource.PgConnectionSupplier var6);
    }

    public static interface ColumnTypeMetadata {
        public int getLength();

        public int getScale();
    }

    public static interface Column {
        public String getName();

        public PostgresType getType();

        public ColumnTypeMetadata getTypeMetadata();

        public Object getValue(PostgresStreamingChangeEventSource.PgConnectionSupplier var1, boolean var2);

        public boolean isOptional();

        default public boolean isToastedColumn() {
            return false;
        }
    }

    public static enum Operation {
        INSERT,
        UPDATE,
        DELETE,
        BEGIN,
        COMMIT,
        NOOP;

    }
}

