/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.data.SpecialValueDecimal;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.time.ZonedTimestamp;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import microsoft.sql.DateTimeOffset;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.SchemaBuilder;

public class SqlServerValueConverters
extends JdbcValueConverters {
    public SqlServerValueConverters() {
    }

    public SqlServerValueConverters(JdbcValueConverters.DecimalMode decimalMode, TemporalPrecisionMode temporalPrecisionMode) {
        super(decimalMode, temporalPrecisionMode, ZoneOffset.UTC, null, null, null);
    }

    @Override
    public SchemaBuilder schemaBuilder(Column column) {
        switch (column.jdbcType()) {
            case -6: {
                return SchemaBuilder.int16();
            }
            case -148: 
            case -146: {
                return SpecialValueDecimal.builder(this.decimalMode, column.length(), column.scale().get());
            }
            case -155: {
                return ZonedTimestamp.builder();
            }
        }
        return super.schemaBuilder(column);
    }

    @Override
    public ValueConverter converter(Column column, Field fieldDefn) {
        switch (column.jdbcType()) {
            case -6: {
                return data -> this.convertSmallInt(column, fieldDefn, data);
            }
            case -148: 
            case -146: {
                return data -> this.convertDecimal(column, fieldDefn, data);
            }
            case -155: {
                return data -> this.convertTimestampWithZone(column, fieldDefn, data);
            }
        }
        return super.converter(column, fieldDefn);
    }

    @Override
    protected int getTimePrecision(Column column) {
        return column.scale().get();
    }

    @Override
    protected Object convertTimestampWithZone(Column column, Field fieldDefn, Object data) {
        if (!(data instanceof DateTimeOffset)) {
            return super.convertTimestampWithZone(column, fieldDefn, data);
        }
        DateTimeOffset dto = (DateTimeOffset)data;
        Timestamp utc = dto.getTimestamp();
        ZoneOffset offset = ZoneOffset.ofTotalSeconds(dto.getMinutesOffset() * 60);
        return super.convertTimestampWithZone(column, fieldDefn, LocalDateTime.ofEpochSecond(utc.getTime() / 1000L, utc.getNanos(), offset).atOffset(offset));
    }
}

