/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.cdc.source;

import io.debezium.embedded.EmbeddedEngine;
import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.stream.ServiceDeploymentInfo;
import io.siddhi.core.stream.input.source.Source;
import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.extension.io.cdc.source.config.CronConfiguration;
import io.siddhi.extension.io.cdc.source.listening.CDCSourceObjectKeeper;
import io.siddhi.extension.io.cdc.source.listening.ChangeDataCapture;
import io.siddhi.extension.io.cdc.source.listening.MongoChangeDataCapture;
import io.siddhi.extension.io.cdc.source.listening.RdbmsChangeDataCapture;
import io.siddhi.extension.io.cdc.source.listening.WrongConfigurationException;
import io.siddhi.extension.io.cdc.source.metrics.CDCStatus;
import io.siddhi.extension.io.cdc.source.metrics.ListeningMetrics;
import io.siddhi.extension.io.cdc.source.metrics.Metrics;
import io.siddhi.extension.io.cdc.source.metrics.PollingMetrics;
import io.siddhi.extension.io.cdc.source.polling.CDCPoller;
import io.siddhi.extension.io.cdc.util.CDCSourceUtil;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.io.File;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.quartz.CronExpression;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.wso2.carbon.si.metrics.core.internal.MetricsDataHolder;

@Extension(name="cdc", namespace="source", description="The CDC source receives events when change events (i.e., INSERT, UPDATE, DELETE) are triggered for a database table. Events are received in the 'key-value' format.\n\nThere are two modes you could perform CDC:\u00a0Listening mode\u00a0and\u00a0Polling mode.\n\nIn polling mode, the datasource is periodically polled for capturing the changes. The polling period can be configured.\nIn polling mode, you can only capture INSERT and UPDATE changes.\n\nOn listening mode, the Source will keep listening to the Change Log of the database and notify in case a change has taken place. Here, you are immediately notified about the change, compared to polling mode.\n\nThe key values of the map of a CDC change event are as follows.\n\nFor 'listening' mode: \n\tFor insert: Keys are specified as columns of the table.\n\tFor delete: Keys are followed by the specified table columns. This is achieved via 'before_'. e.g., specifying 'before_X' results in the key being added before the column named 'X'.\n\tFor update: Keys are followed followed by the specified table columns. This is achieved via 'before_'. e.g., specifying 'before_X' results in the key being added before the column named 'X'.\n\nFor 'polling' mode: Keys are specified as the columns of the table.In order to connect in to the database table for receive CDC events, url, username, password and driverClassName(in polling mode) can be provided in deployment.yaml file under the siddhi namespace as below,  ```\n  siddhi:\n    extensions:\n      -\n        extension:\n          name: 'cdc'\n          namespace: 'source'\n          properties:\n            url: jdbc:sqlserver://localhost:1433;databaseName=CDC_DATA_STORE\n            password: <password>\n            username: <>\n            driverClassName: com.microsoft.sqlserver.jdbc.SQLServerDriver  ```\n#### Preparations required for working with Oracle Databases in listening mode\n\nUsing the extension in Windows, Mac OSX and AIX are pretty straight forward inorder to achieve the required behaviour please follow the steps given below\n\n  - Download the compatible version of oracle instantclient for the database version from [here](https://www.oracle.com/database/technologies/instant-client/downloads.html) and extract\n  - Extract and set the environment variable `LD_LIBRARY_PATH` to the location of instantclient which was exstracted as shown below\n  ```\n    export LD_LIBRARY_PATH=<path to the instant client location>\n  ```\n  - Inside the instantclient folder which was download there are two jars `xstreams.jar` and `ojdbc<version>.jar` convert them to OSGi bundles using the tools which were provided in the `<distribution>/bin` for converting the `ojdbc.jar` use the tool `spi-provider.sh|bat` and for the conversion of `xstreams.jar` use the jni-provider.sh as shown below(Note: this way of converting Xstreams jar is applicable only for Linux environments for other OSs this step is not required and converting it through the `jartobundle.sh` tool is enough)\n  ```\n    ./jni-provider.sh <input-jar> <destination> <comma seperated native library names>\n  ```\n  once ojdbc and xstreams jars are converted to OSGi copy the generated jars to the `<distribution>/lib`. Currently siddhi-io-cdc only supports the oracle database distributions 12 and above\n#### Configurations for PostgreSQL\nWhen using listening mode with PostgreSQL, following properties has to be configured accordingly to create the connection.\n***slot.name***: (default value = debezium) in postgreSQL only one connection can be created from            single slot, so to create multiple connection custom slot.name should be provided.\n ***plugin.name***: (default value = decoderbufs ) Logical decoding output plugin name which the database is configured with. Other supported values are pgoutput, decoderbufs, wal2json.\n***table.name***: table name should be provided as <schema_name>.<table_name>. As an example, public.customer \n\n\nSee parameter: mode for supported databases and change events.", parameters={@Parameter(name="url", description="The connection URL to the database.\nF=The format used is: 'jdbc:mysql://<host>:<port>/<database_name>' ", type={DataType.STRING}), @Parameter(name="mode", description="Mode to capture the change data. The type of events that can be received, and the required parameters differ based on the mode. The mode can be one of the following:\n'polling': This mode uses a column named 'polling.column' to monitor the given table. It captures change events of the 'RDBMS', 'INSERT, and 'UPDATE' types.\n'listening': This mode uses logs to monitor the given table. It currently supports change events only of the 'MySQL', 'INSERT', 'UPDATE', and 'DELETE' types.", type={DataType.STRING}, defaultValue="listening", optional=true), @Parameter(name="jdbc.driver.name", description="The driver class name for connecting the database. **It is required to specify a value for this parameter when the mode is 'polling'.**", type={DataType.STRING}, defaultValue="<Empty_String>", optional=true), @Parameter(name="username", description="The username to be used for accessing the database. This user needs to have the 'SELECT', 'RELOAD', 'SHOW DATABASES', 'REPLICATION SLAVE', and 'REPLICATION CLIENT'privileges for the change data capturing table (specified via the 'table.name' parameter).\nTo operate in the polling mode, the user needs 'SELECT' privileges.", type={DataType.STRING}), @Parameter(name="password", description="The password of the username you specified for accessing the database.", type={DataType.STRING}), @Parameter(name="pool.properties", description="The pool parameters for the database connection can be specified as key-value pairs.", type={DataType.STRING}, optional=true, defaultValue="<Empty_String>"), @Parameter(name="datasource.name", description="Name of the wso2 datasource to connect to the database. When datasource name is provided, the URL, username and password are not needed. A datasource based connection is given more priority over the URL based connection.\n This parameter is applicable only when the mode is set to **polling**, and it can be applied only when you use this extension with WSO2 Stream Processor.", type={DataType.STRING}, defaultValue="<Empty_String>", optional=true), @Parameter(name="table.name", description="The name of the table that needs to be monitored for data changes.", type={DataType.STRING}), @Parameter(name="polling.column", description="The column name  that is polled to capture the change data. It is recommended to have a TIMESTAMP field as the 'polling.column' in order to capture the inserts and updates.\nNumeric auto-incremental fields and char fields can also be used as 'polling.column'. However, note that fields of these types only support insert change capturing, and the possibility of using a char field also depends on how the data is input.\n**It is required to enter a value for this parameter only when the mode is 'polling'.**", type={DataType.STRING}, defaultValue="<Empty_String>", optional=true), @Parameter(name="polling.interval", description="The time interval (specified in seconds) to poll the given table for changes.\nThis parameter is applicable only when the mode is set to 'polling'.", type={DataType.INT}, defaultValue="1", optional=true), @Parameter(name="operation", description="The change event operation you want to carry out. Possible values are 'insert', 'update', 'delete' or you can provide multiple operation as coma separated values. This parameter is not case sensitive.  \n When provided the multiple operations, the relevant operation for each event will be return as a transport property **trp:operation** this can be access when mapping the events. According to the operation, the required fields from the stream has to be extracted. \n**It is required to specify a value only when the mode is 'listening'.**\n", type={DataType.STRING}), @Parameter(name="connector.properties", description="Here, you can specify Debezium connector properties as a comma-separated string. \nThe properties specified here are given more priority over the parameters. This parameter is applicable only for the 'listening' mode.", type={DataType.STRING}, optional=true, defaultValue="Empty_String"), @Parameter(name="database.server.id", description="An ID to be used when joining MySQL database cluster to read the bin log. This should be a unique integer between 1 to 2^32. This parameter is applicable only when the mode is 'listening'.", type={DataType.STRING}, optional=true, defaultValue="Random integer between 5400 and 6400"), @Parameter(name="database.server.name", description="A logical name that identifies and provides a namespace for the database server. This parameter is applicable only when the mode is 'listening'.", defaultValue="{host}_{port}", optional=true, type={DataType.STRING}), @Parameter(name="wait.on.missed.record", description="Indicates whether the process needs to wait on missing/out-of-order records. \nWhen this flag is set to 'true' the process will be held once it identifies a missing record. The missing record is identified by the sequence of the polling.column value. This can be used only with number fields and not recommended to use with time values as it will not be sequential.\nThis should be enabled ONLY where the records can be written out-of-order, (eg. concurrent writers) as this degrades the performance.", type={DataType.BOOL}, optional=true, defaultValue="false"), @Parameter(name="missed.record.waiting.timeout", description="The timeout (specified in seconds) to retry for missing/out-of-order record. This should be used along with the wait.on.missed.record parameter. If the parameter is not set, the process will indefinitely wait for the missing record.", type={DataType.INT}, optional=true, defaultValue="-1"), @Parameter(name="polling.history.size", description="Should be use when metrics are enabled, Define the number of polling details that should expose to metrics, Ex: if polling.history.size is 20, then it will expose details of last 20 polling", type={DataType.INT}, defaultValue="10", optional=true), @Parameter(name="cron.expression", description="This is used to specify a timestamp in cron expression.The records which has been inserted or updated is printed when the given expression satisfied by the system time. This parameter is applicable only when the mode is 'polling'.", optional=true, type={DataType.STRING}, defaultValue="None"), @Parameter(name="plugin.name", description="This is used when the logical decoding output plugin needed to specify to create the connection to the database. Mostly this will be required on PostgreSQL.", optional=true, type={DataType.STRING}, defaultValue="decoderbufs")}, examples={@Example(syntax="@source(type = 'cdc' , url = 'jdbc:mysql://localhost:3306/SimpleDB', \nusername = 'cdcuser', password = 'pswd4cdc', \ntable.name = 'students', operation = 'insert', \n@map(type='keyvalue', @attributes(id = 'id', name = 'name')))\ndefine stream inputStream (id string, name string);", description="In this example, the CDC source listens to the row insertions that are made in the 'students' table with the column name, and the ID. This table belongs to the 'SimpleDB' MySQL database that can be accessed via the given URL."), @Example(syntax="@source(type = 'cdc' , url = 'jdbc:mysql://localhost:3306/SimpleDB', \nusername = 'cdcuser', password = 'pswd4cdc', \ntable.name = 'students', operation = 'update', \n@map(type='keyvalue', @attributes(id = 'id', name = 'name', \nbefore_id = 'before_id', before_name = 'before_name')))\ndefine stream inputStream (before_id string, id string, \nbefore_name string , name string);", description="In this example, the CDC source listens to the row updates that are made in the 'students' table. This table belongs to the 'SimpleDB' MySQL database that can be accessed via the given URL."), @Example(syntax="@source(type = 'cdc' , url = 'jdbc:mysql://localhost:3306/SimpleDB', \nusername = 'cdcuser', password = 'pswd4cdc', \ntable.name = 'students', operation = 'delete', \n@map(type='keyvalue', @attributes(before_id = 'before_id', before_name = 'before_name')))\ndefine stream inputStream (before_id string, before_name string);", description="In this example, the CDC source listens to the row deletions made in the 'students' table. This table belongs to the 'SimpleDB' database that can be accessed via the given URL."), @Example(syntax="@source(type = 'cdc' , url = 'jdbc:mysql://localhost:3306/SimpleDB', \nusername = 'cdcuser', password = 'pswd4cdc', \ntable.name = 'students', operation = 'insert,update,delete', \n@map(type='keyvalue', @attributes(before_id = 'before_id', before_name = 'before_name', name = 'name', id = 'id', operation= 'trp:operation')))\ndefine stream inputStream (id string, name string, before_id string, before_name string, operation string);", description="In this example, the CDC source listens to multiple operations of the 'students' table. This table belongs to the 'SimpleDB' database that can be accessed via the given URL."), @Example(syntax="@source(type = 'cdc', mode='polling', polling.column = 'id', \njdbc.driver.name = 'com.mysql.jdbc.Driver', url = 'jdbc:mysql://localhost:3306/SimpleDB', \nusername = 'cdcuser', password = 'pswd4cdc', \ntable.name = 'students', \n@map(type='keyvalue'), @attributes(id = 'id', name = 'name'))\ndefine stream inputStream (id int, name string);", description="In this example, the CDC source polls the 'students' table for inserts. 'id' that is specified as the polling colum' is an auto incremental field. The connection to the database is made via the URL, username, password, and the JDBC driver name."), @Example(syntax="@source(type = 'cdc', mode='polling', polling.column = 'id', datasource.name = 'SimpleDB',\ntable.name = 'students', \n@map(type='keyvalue'), @attributes(id = 'id', name = 'name'))\ndefine stream inputStream (id int, name string);", description="In this example, the CDC source polls the 'students' table for inserts. The given polling column is a char column with the 'S001, S002, ... .' pattern. The connection to the database is made via a data source named 'SimpleDB'. Note that the 'datasource.name' parameter works only with the Stream Processor."), @Example(syntax="@source(type = 'cdc', mode='polling', polling.column = 'last_updated', datasource.name = 'SimpleDB',\ntable.name = 'students', \n@map(type='keyvalue'))\ndefine stream inputStream (name string);", description="In this example, the CDC source polls the 'students' table for inserts and updates. The polling column is a timestamp field."), @Example(syntax="@source(type='cdc', jdbc.driver.name='com.mysql.jdbc.Driver', url='jdbc:mysql://localhost:3306/SimpleDB', username='cdcuser', password='pswd4cdc', table.name='students', mode='polling', polling.column='id', operation='insert', wait.on.missed.record='true', missed.record.waiting.timeout='10',\n@map(type='keyvalue'), \n@attributes(batch_no='batch_no', item='item', qty='qty'))\ndefine stream inputStream (id int, name string);", description="In this example, the CDC source polls the 'students' table for inserts. The polling column is a numeric field. This source expects the records in the database to be written concurrently/out-of-order so it waits if it encounters a missing record. If the record doesn't appear within 10 seconds it resumes the process."), @Example(syntax="@source(type = 'cdc', url = 'jdbc:oracle:thin://localhost:1521/ORCLCDB', username='c##xstrm', password='xs', table.name='DEBEZIUM.sweetproductiontable', operation = 'insert', connector.properties='oracle.outserver.name=DBZXOUT,oracle.pdb=ORCLPDB1' @map(type = 'keyvalue'))\ndefine stream insertSweetProductionStream (ID int, NAME string, WEIGHT int);\n", description="In this example, the CDC source connect to an Oracle database and listens for insert queries of sweetproduction table")})
public class CDCSource
extends Source<CdcState> {
    private static final Logger log = Logger.getLogger(CDCSource.class);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private int pollingInterval;
    private String mode;
    private Map<byte[], byte[]> offsetData = new HashMap<byte[], byte[]>();
    private String operation;
    private ChangeDataCapture changeDataCapture;
    private String historyFileDirectory;
    private CDCSourceObjectKeeper cdcSourceObjectKeeper = CDCSourceObjectKeeper.getCdcSourceObjectKeeper();
    private String carbonHome;
    private CDCPoller cdcPoller;
    private String cronExpression = null;
    private CronConfiguration cronConfiguration;
    private boolean waitOnMissedRecord;
    private EmbeddedEngine engine;
    private Metrics metrics;
    private String siddhiAppName;
    private ExecutorService siddhiAppContextExecutorService;

    protected ServiceDeploymentInfo exposeServiceDeploymentInfo() {
        return null;
    }

    public StateFactory<CdcState> init(SourceEventListener sourceEventListener, OptionHolder optionHolder, String[] requestedTransportPropertyNames, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        HashMap deploymentConfigMap = new HashMap();
        deploymentConfigMap.putAll(configReader.getAllConfigs());
        this.cronConfiguration = new CronConfiguration();
        configReader.getAllConfigs();
        this.mode = optionHolder.validateAndGetStaticValue("mode", "listening");
        String tableName = optionHolder.validateAndGetOption("table.name").getValue();
        String pluginName = optionHolder.validateAndGetStaticValue("plugin.name", "decoderbufs");
        this.siddhiAppName = siddhiAppContext.getName();
        this.siddhiAppContextExecutorService = siddhiAppContext.getExecutorService();
        boolean isPrometheusReporterRunning = false;
        if (MetricsDataHolder.getInstance().getMetricService() != null && MetricsDataHolder.getInstance().getMetricManagementService().isEnabled()) {
            try {
                isPrometheusReporterRunning = MetricsDataHolder.getInstance().getMetricManagementService().isReporterRunning("prometheus");
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)"Prometheus reporter is not running. Hence cdc metrics will not be initialise.");
            }
        }
        String url = deploymentConfigMap.containsKey("url") ? (String)deploymentConfigMap.get("url") : optionHolder.validateAndGetOption("url").getValue();
        String username = deploymentConfigMap.containsKey("username") ? (String)deploymentConfigMap.get("username") : optionHolder.validateAndGetOption("username").getValue();
        String password = deploymentConfigMap.containsKey("password") ? (String)deploymentConfigMap.get("password") : optionHolder.validateAndGetOption("password").getValue();
        switch (this.mode) {
            case "listening": {
                boolean isDirectoryCreated;
                String streamName = sourceEventListener.getStreamDefinition().getId();
                this.operation = optionHolder.validateAndGetOption("operation").getValue();
                int serverID = Integer.parseInt(optionHolder.validateAndGetStaticValue("database.server.id", Integer.toString(-1)));
                String serverName = optionHolder.validateAndGetStaticValue("database.server.name", "");
                String connectorProperties = optionHolder.validateAndGetStaticValue("connector.properties", "");
                this.carbonHome = CDCSourceUtil.getCarbonHome();
                this.historyFileDirectory = this.carbonHome + File.separator + "cdc" + File.separator + "history" + File.separator + this.siddhiAppName + File.separator;
                this.validateListeningModeParameters(optionHolder);
                if (isPrometheusReporterRunning) {
                    this.metrics = new ListeningMetrics(this.siddhiAppName, url, tableName, this.operation);
                }
                this.changeDataCapture = url.toLowerCase(Locale.ENGLISH).contains("jdbc:mongodb") ? new MongoChangeDataCapture(this.operation, sourceEventListener, (ListeningMetrics)this.metrics) : new RdbmsChangeDataCapture(this.operation, sourceEventListener, (ListeningMetrics)this.metrics);
                File directory = new File(this.historyFileDirectory);
                if (!directory.exists() && (isDirectoryCreated = directory.mkdirs()) && log.isDebugEnabled()) {
                    log.debug((Object)"Directory created for history file.");
                }
                try {
                    Map<String, Object> configMap = CDCSourceUtil.getConfigMap(username, password, url, tableName, this.historyFileDirectory, this.siddhiAppName, streamName, serverID, serverName, connectorProperties, ((Object)((Object)this)).hashCode(), (ListeningMetrics)this.metrics, pluginName);
                    this.changeDataCapture.setConfig(configMap);
                    break;
                }
                catch (WrongConfigurationException ex) {
                    throw new SiddhiAppCreationException("The cdc source couldn't get started because of invalid configurations. Found configurations: {username='" + username + "', password=******, url='" + url + "', tablename='" + tableName + "', connetorProperties='" + connectorProperties + "'}", (Throwable)ex);
                }
            }
            case "polling": {
                String pollingColumn = optionHolder.validateAndGetStaticValue("polling.column");
                boolean isDatasourceNameAvailable = optionHolder.isOptionExists("datasource.name");
                boolean isJndiResourceAvailable = optionHolder.isOptionExists("jndi.resource");
                this.pollingInterval = Integer.parseInt(optionHolder.validateAndGetStaticValue("polling.interval", Integer.toString(1)));
                if (optionHolder.isOptionExists("cron.expression")) {
                    this.cronExpression = optionHolder.validateAndGetStaticValue("cron.expression", null);
                    if (!CronExpression.isValidExpression((String)this.cronExpression)) {
                        throw new SiddhiAppCreationException("Cron Expression " + this.cronExpression + " is not valid.");
                    }
                } else {
                    this.cronExpression = null;
                }
                String poolPropertyString = optionHolder.validateAndGetStaticValue("pool.properties", null);
                this.waitOnMissedRecord = Boolean.parseBoolean(optionHolder.validateAndGetStaticValue("wait.on.missed.record", "false"));
                int missedRecordWaitingTimeout = Integer.parseInt(optionHolder.validateAndGetStaticValue("missed.record.waiting.timeout", "-1"));
                if (isDatasourceNameAvailable) {
                    String datasourceName = optionHolder.validateAndGetStaticValue("datasource.name");
                    if (isPrometheusReporterRunning) {
                        this.metrics = new PollingMetrics(this.siddhiAppName, datasourceName, tableName);
                    }
                    this.cdcPoller = new CDCPoller(null, null, null, tableName, null, datasourceName, null, pollingColumn, this.pollingInterval, poolPropertyString, sourceEventListener, configReader, this.waitOnMissedRecord, missedRecordWaitingTimeout, this.siddhiAppName, (PollingMetrics)this.metrics, this.cronConfiguration);
                } else if (isJndiResourceAvailable) {
                    String jndiResource = optionHolder.validateAndGetStaticValue("jndi.resource");
                    if (isPrometheusReporterRunning) {
                        this.metrics = new PollingMetrics(this.siddhiAppName, jndiResource, tableName);
                    }
                    this.cdcPoller = new CDCPoller(null, null, null, tableName, null, null, jndiResource, pollingColumn, this.pollingInterval, poolPropertyString, sourceEventListener, configReader, this.waitOnMissedRecord, missedRecordWaitingTimeout, this.siddhiAppName, (PollingMetrics)this.metrics, this.cronConfiguration);
                } else {
                    String driverClassName;
                    try {
                        driverClassName = deploymentConfigMap.containsKey("jdbc.driver.name") ? (String)deploymentConfigMap.get("jdbc.driver.name") : optionHolder.validateAndGetStaticValue("jdbc.driver.name");
                        if (isPrometheusReporterRunning) {
                            this.metrics = new PollingMetrics(this.siddhiAppName, url, tableName);
                        }
                    }
                    catch (SiddhiAppValidationException ex) {
                        throw new SiddhiAppValidationException(ex.getMessage() + " Alternatively, define " + "datasource.name" + " or " + "jndi.resource" + ". Current mode: " + "polling");
                    }
                    this.cdcPoller = new CDCPoller(url, username, password, tableName, driverClassName, null, null, pollingColumn, this.pollingInterval, poolPropertyString, sourceEventListener, configReader, this.waitOnMissedRecord, missedRecordWaitingTimeout, this.siddhiAppName, (PollingMetrics)this.metrics, this.cronConfiguration);
                }
                if (this.metrics != null) {
                    int pollingHistorySize = Integer.parseInt(optionHolder.validateAndGetStaticValue("polling.history.size", "10"));
                    ((PollingMetrics)this.metrics).setPollingHistorySize(pollingHistorySize);
                }
                this.validatePollingModeParameters();
                break;
            }
            default: {
                throw new SiddhiAppValidationException("Unsupported mode: " + this.mode);
            }
        }
        return () -> new CdcState(this.mode);
    }

    public Class[] getOutputEventClasses() {
        return new Class[]{Map.class};
    }

    public void connect(Source.ConnectionCallback connectionCallback, CdcState cdcState) throws ConnectionUnavailableException {
        switch (this.mode) {
            case "listening": {
                this.cdcSourceObjectKeeper.addCdcObject(this);
                EmbeddedEngine.CompletionCallback completionCallback = (success, message, error) -> {
                    if (!success) {
                        connectionCallback.onError(new ConnectionUnavailableException("Connection to the database lost.", error));
                        if (this.metrics != null) {
                            this.metrics.setCDCStatus(CDCStatus.ERROR);
                        }
                    }
                };
                this.engine = this.changeDataCapture.getEngine(completionCallback);
                this.executorService.execute(this.engine);
                break;
            }
            case "polling": {
                CDCPoller.CompletionCallback cdcCompletionCallback = error -> {
                    if (!error.getClass().equals(SQLException.class)) {
                        this.destroy();
                        throw new SiddhiAppRuntimeException("CDC Polling mode run failed.", error);
                    }
                    connectionCallback.onError(new ConnectionUnavailableException("Connection to the database lost.", error));
                };
                this.cdcPoller.setCompletionCallback(cdcCompletionCallback);
                this.executorService.execute(this.cdcPoller);
                break;
            }
        }
        if (this.metrics != null) {
            this.metrics.updateTableStatus(this.siddhiAppContextExecutorService, this.siddhiAppName);
        }
    }

    public void disconnect() {
        if (this.mode.equals("polling")) {
            this.cdcPoller.pause();
            if (this.cdcPoller.isLocalDataSource()) {
                this.cdcPoller.getDataSource().close();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Closing the pool for CDC polling mode.");
                }
            }
            if (this.cronExpression != null) {
                try {
                    Scheduler scheduler = this.cronConfiguration.getScheduler();
                    if (scheduler != null) {
                        scheduler.deleteJob(new JobKey("CDCPollingJobName", "CDCPollingGroup"));
                    }
                }
                catch (SchedulerException e) {
                    throw new SiddhiAppRuntimeException("Failed to delete the cron job of the siddhi app due to " + e.getMessage(), (Throwable)e);
                }
            }
            this.cdcPoller.stop();
        } else if (this.mode.equals("listening") && this.engine != null) {
            this.engine.stop();
        }
    }

    public void destroy() {
        this.disconnect();
        if (this.mode.equals("listening")) {
            this.cdcSourceObjectKeeper.removeObject(((Object)((Object)this)).hashCode());
        }
        this.executorService.shutdown();
    }

    public void pause() {
        switch (this.mode) {
            case "polling": {
                this.cdcPoller.pause();
                break;
            }
            case "listening": {
                this.changeDataCapture.pause();
                break;
            }
        }
    }

    public void resume() {
        switch (this.mode) {
            case "polling": {
                this.cdcPoller.resume();
                break;
            }
            case "listening": {
                this.changeDataCapture.resume();
                break;
            }
        }
    }

    public Map<byte[], byte[]> getOffsetData() {
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            log.error((Object)"Offset data retrieval failed.", (Throwable)e);
        }
        return this.offsetData;
    }

    public void setOffsetData(Map<byte[], byte[]> offsetData) {
        this.offsetData = offsetData;
    }

    private void validateListeningModeParameters(OptionHolder optionHolder) {
        if (optionHolder.isOptionExists("datasource.name")) {
            throw new SiddhiAppValidationException("Parameter: datasource.name should not be defined for listening mode");
        }
        if (!(this.operation.contains(",") || this.operation.equalsIgnoreCase("insert") || this.operation.equalsIgnoreCase("update") || this.operation.equalsIgnoreCase("delete"))) {
            throw new SiddhiAppValidationException("Unsupported operation: '" + this.operation + "'. operation should be one of 'insert', 'update' or 'delete'");
        }
        if (this.carbonHome.isEmpty()) {
            throw new SiddhiAppValidationException("Couldn't initialize Carbon Home.");
        }
        if (!this.historyFileDirectory.endsWith(File.separator)) {
            this.historyFileDirectory = this.historyFileDirectory + File.separator;
        }
        if (optionHolder.isOptionExists("cron.expression")) {
            throw new SiddhiAppCreationException("Parameter: cron.expression should not be defined for listening mode");
        }
    }

    private void validatePollingModeParameters() {
        if (this.pollingInterval < 0) {
            throw new SiddhiAppValidationException("polling.interval should be a non negative integer. Current mode: polling");
        }
        if (this.waitOnMissedRecord && this.cronExpression != null) {
            throw new SiddhiAppCreationException("If waitOnMissedRecord is true then cron.expression must be null. ");
        }
        this.cronConfiguration.setCronExpression(this.cronExpression);
    }

    class CdcState
    extends State {
        private final String mode;
        private final Map<String, Object> state;

        private CdcState(String mode) {
            this.mode = mode;
            this.state = new HashMap<String, Object>();
        }

        public boolean canDestroy() {
            return false;
        }

        public Map<String, Object> snapshot() {
            switch (this.mode) {
                case "polling": {
                    this.state.put("last.offset", CDCSource.this.cdcPoller.getLastReadPollingColumnValue());
                    break;
                }
                case "listening": {
                    this.state.put("cacheObj", CDCSource.this.offsetData);
                    break;
                }
            }
            return this.state;
        }

        public void restore(Map<String, Object> map) {
            switch (this.mode) {
                case "polling": {
                    Object lastOffsetObj = map.get("last.offset");
                    CDCSource.this.cdcPoller.setLastReadPollingColumnValue((String)lastOffsetObj);
                    break;
                }
                case "listening": {
                    Object cacheObj = map.get("cacheObj");
                    CDCSource.this.offsetData = (HashMap)cacheObj;
                    break;
                }
            }
        }
    }
}

