/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.cdc.source.listening;

import io.siddhi.core.stream.input.source.SourceEventListener;
import io.siddhi.extension.io.cdc.source.listening.ChangeDataCapture;
import io.siddhi.extension.io.cdc.source.metrics.ListeningMetrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class MongoChangeDataCapture
extends ChangeDataCapture {
    private static final Logger log = Logger.getLogger(MongoChangeDataCapture.class);

    public MongoChangeDataCapture(String operation, SourceEventListener sourceEventListener, ListeningMetrics metrics) {
        super(operation, sourceEventListener, metrics);
    }

    @Override
    Map<String, Object> createMap(ConnectRecord connectRecord, String operation) {
        String op;
        Map<String, Object> detailsMap = new HashMap<String, Object>();
        ArrayList<String> transportProperties = new ArrayList<String>();
        Struct record = (Struct)connectRecord.value();
        try {
            op = (String)record.get("op");
        }
        catch (NullPointerException | DataException ex) {
            return detailsMap;
        }
        if (operation.equalsIgnoreCase("insert") && op.equals("c") || operation.equalsIgnoreCase("delete") && op.equals("d") || operation.equalsIgnoreCase("update") && op.equals("u")) {
            switch (op) {
                case "c": {
                    detailsMap.put("transportProperties", transportProperties.add("insert"));
                    String insertString = (String)record.get("after");
                    JSONObject jsonObj = new JSONObject(insertString);
                    detailsMap = this.getMongoDetailMap(jsonObj);
                    break;
                }
                case "d": {
                    detailsMap.put("transportProperties", transportProperties.add("delete"));
                    String deleteDocumentId = (String)((Struct)connectRecord.key()).get("id");
                    JSONObject jsonObjId = new JSONObject(deleteDocumentId);
                    detailsMap.put("id", jsonObjId.get("$oid"));
                    break;
                }
                case "u": {
                    detailsMap.put("transportProperties", transportProperties.add("update"));
                    String updateDocument = (String)record.get("patch");
                    JSONObject jsonObj1 = new JSONObject(updateDocument);
                    JSONObject setJsonObj = (JSONObject)jsonObj1.get("$set");
                    detailsMap = this.getMongoDetailMap(setJsonObj);
                    String updateDocumentId = (String)((Struct)connectRecord.key()).get("id");
                    JSONObject jsonObjId1 = new JSONObject(updateDocumentId);
                    detailsMap.put("id", jsonObjId1.get("$oid"));
                    break;
                }
                default: {
                    log.info((Object)("Provided value for \"op\" : " + op + " is not supported."));
                }
            }
        }
        return detailsMap;
    }

    private Map<String, Object> getMongoDetailMap(JSONObject jsonObj) {
        Iterator<String> keys;
        HashMap<String, Object> detailsMap = new HashMap<String, Object>();
        Iterator<String> it = keys = jsonObj.keys();
        while (it.hasNext()) {
            String key = it.next();
            if (jsonObj.get(key) instanceof Boolean) {
                detailsMap.put(key, jsonObj.getBoolean(key));
                continue;
            }
            if (jsonObj.get(key) instanceof Integer) {
                detailsMap.put(key, jsonObj.getInt(key));
                continue;
            }
            if (jsonObj.get(key) instanceof Long) {
                detailsMap.put(key, jsonObj.getDouble(key));
                continue;
            }
            if (jsonObj.get(key) instanceof Double) {
                detailsMap.put(key, jsonObj.getDouble(key));
                continue;
            }
            if (jsonObj.get(key) instanceof String) {
                detailsMap.put(key, jsonObj.getString(key));
                continue;
            }
            if (!(jsonObj.get(key) instanceof JSONObject)) continue;
            try {
                detailsMap.put(key, Long.parseLong((String)jsonObj.getJSONObject(key).get("$numberLong")));
            }
            catch (JSONException notLongObjectEx) {
                try {
                    detailsMap.put(key, Double.parseDouble((String)jsonObj.getJSONObject(key).get("$numberDecimal")));
                }
                catch (JSONException notDoubleObjectEx) {
                    if (key.equals("_id")) {
                        detailsMap.put("id", jsonObj.getJSONObject(key).get("$oid"));
                        continue;
                    }
                    detailsMap.put(key, jsonObj.getJSONObject(key).toString());
                }
            }
        }
        return detailsMap;
    }
}

