/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.cdc.util;

import io.siddhi.extension.io.cdc.source.polling.CDCPollingModeException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CDCPollingUtil {
    private static final Logger log = Logger.getLogger(CDCPollingUtil.class);

    public static boolean isEmpty(String field) {
        return field == null || field.trim().length() == 0;
    }

    public static void cleanupConnection(ResultSet rs, Statement stmt, Connection conn) {
        block14: {
            block13: {
                block12: {
                    if (rs != null) {
                        try {
                            rs.close();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Closed ResultSet");
                            }
                        }
                        catch (SQLException e) {
                            if (!log.isDebugEnabled()) break block12;
                            log.debug((Object)("Error in closing ResultSet: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Closed PreparedStatement");
                        }
                    }
                    catch (SQLException e) {
                        if (!log.isDebugEnabled()) break block13;
                        log.debug((Object)("Error in closing PreparedStatement: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Closed Connection");
                    }
                }
                catch (SQLException e) {
                    if (!log.isDebugEnabled()) break block14;
                    log.debug((Object)("Error in closing Connection: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public static List<String[]> processKeyValuePairs(String annotationString) {
        ArrayList<String[]> keyValuePairs = new ArrayList<String[]>();
        if (!CDCPollingUtil.isEmpty(annotationString)) {
            String[] pairs;
            for (String element : pairs = annotationString.split(",")) {
                if (!element.contains(":")) {
                    throw new CDCPollingModeException("Property '" + element + "' does not adhere to the expected format: a property must be a key-value pair separated by a colon (:)");
                }
                String[] pair = element.split(":");
                if (pair.length != 2) {
                    throw new CDCPollingModeException("Property '" + pair[0] + "' does not adhere to the expected format: a property must be a key-value pair separated by a colon (:)");
                }
                keyValuePairs.add(new String[]{pair[0].trim(), pair[1].trim()});
            }
        }
        return keyValuePairs;
    }
}

