/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.cdc.util;

import io.siddhi.extension.io.cdc.source.listening.InMemoryOffsetBackingStore;
import io.siddhi.extension.io.cdc.source.listening.WrongConfigurationException;
import io.siddhi.extension.io.cdc.source.metrics.ListeningMetrics;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CDCSourceUtil {
    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> getConfigMap(String username, String password, String url, String tableName, String historyFileDirectory, String siddhiAppName, String siddhiStreamName, int serverID, String serverName, String connectorProperties, int cdcSourceHashCode, ListeningMetrics metrics, String pluginName) throws WrongConfigurationException {
        String database;
        int port;
        String host;
        void var21_24;
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        Boolean isMongodb = false;
        Map<String, String> connectorPropertiesMap = CDCSourceUtil.getConnectorPropertiesMap(connectorProperties);
        String[] splittedURL = url.split(":");
        if (!splittedURL[0].equalsIgnoreCase("jdbc")) {
            throw new WrongConfigurationException("Invalid JDBC url: " + url + " received for stream: " + siddhiStreamName + ". Expected url format: jdbc:mysql://<host>:<port>/<database_name>");
        }
        String string = splittedURL[1];
        int n = -1;
        switch (string.hashCode()) {
            case 104382626: {
                if (!string.equals("mysql")) break;
                boolean bl = false;
                break;
            }
            case -2105481388: {
                if (!string.equals("postgresql")) break;
                boolean bl = true;
                break;
            }
            case -1874470255: {
                if (!string.equals("sqlserver")) break;
                int n2 = 2;
                break;
            }
            case -1008861826: {
                if (!string.equals("oracle")) break;
                int n3 = 3;
                break;
            }
            case 1236254834: {
                if (!string.equals("mongodb")) break;
                int n4 = 4;
            }
        }
        switch (var21_24) {
            case 0: {
                String regex = "jdbc:mysql://([a-zA-Z0-9-_\\.]+):(\\d++)/(\\w*)";
                Pattern p = Pattern.compile(regex);
                Matcher matcher = p.matcher(url);
                if (!matcher.find()) {
                    throw new WrongConfigurationException("Invalid JDBC url: " + url + " received for stream: " + siddhiStreamName + ". Expected url format: jdbc:mysql://<host>:<port>/<database_name>");
                }
                host = matcher.group(1);
                port = Integer.parseInt(matcher.group(2));
                database = matcher.group(3);
                configMap.put("database.port", port);
                configMap.put("table.include.list", database + "." + tableName);
                configMap.put("database.hostname", host);
                configMap.put("connector.class", "io.debezium.connector.mysql.MySqlConnector");
                if (metrics == null) break;
                metrics.setDbType("MySQL");
                break;
            }
            case 1: {
                String regex = "jdbc:postgresql://([a-zA-Z0-9-_\\.]+):(\\d++)/(\\w*)";
                Pattern p = Pattern.compile(regex);
                Matcher matcher = p.matcher(url);
                if (!matcher.find()) {
                    throw new WrongConfigurationException("Invalid JDBC url: " + url + " received for stream: " + siddhiStreamName + ". Expected url format: jdbc:postgresql://<host>:<port>/<database_name>");
                }
                host = matcher.group(1);
                port = Integer.parseInt(matcher.group(2));
                database = matcher.group(3);
                configMap.put("database.hostname", host);
                configMap.put("database.port", port);
                configMap.put("database.dbname", database);
                configMap.put("table.include.list", tableName);
                configMap.put("plugin.name", pluginName);
                configMap.put("connector.class", "io.debezium.connector.postgresql.PostgresConnector");
                if (metrics == null) break;
                metrics.setDbType("PostgreSQL");
                break;
            }
            case 2: {
                String regex = "jdbc:sqlserver://([a-zA-Z0-9-_\\.]+):(\\d++);databaseName=(\\w*)";
                Pattern p = Pattern.compile(regex);
                Matcher matcher = p.matcher(url);
                if (!matcher.find()) {
                    throw new WrongConfigurationException("Invalid JDBC url: " + url + " received for stream: " + siddhiStreamName + ". Expected url format: jdbc:sqlserver://<host>:<port>;databaseName=<database_name>");
                }
                host = matcher.group(1);
                port = Integer.parseInt(matcher.group(2));
                database = matcher.group(3);
                configMap.put("database.hostname", host);
                configMap.put("database.port", port);
                configMap.put("table.include.list", tableName);
                configMap.put("database.dbname", database);
                configMap.put("connector.class", "io.debezium.connector.sqlserver.SqlServerConnector");
                if (metrics == null) break;
                metrics.setDbType("SQL Server");
                break;
            }
            case 3: {
                String regex = "jdbc:oracle:(\\w*):\\/\\/([a-zA-Z0-9-_\\.]+):(\\d+)([\\/]?)([a-zA-Z0-9-_\\.]*)";
                Pattern p = Pattern.compile(regex);
                Matcher matcher = p.matcher(url);
                if (!matcher.find()) {
                    throw new WrongConfigurationException("Invalid JDBC url: " + url + " received for stream: " + siddhiStreamName + ". Expected url format: jdbc:oracle:<driver>://<host>:<port>/<sid>");
                }
                host = matcher.group(2);
                port = Integer.parseInt(matcher.group(3));
                database = matcher.group(5);
                if (!connectorPropertiesMap.containsKey("database.out.server.name")) {
                    throw new WrongConfigurationException("Required properties database.out.server.name is missing in the connector.properties configurations.");
                }
                configMap.put("database.hostname", host);
                configMap.put("database.port", port);
                configMap.put("table.include.list", tableName);
                configMap.put("database.dbname", database);
                configMap.put("connector.class", "io.debezium.connector.oracle.OracleConnector");
                if (metrics == null) break;
                metrics.setDbType("Oracle");
                break;
            }
            case 4: {
                isMongodb = true;
                String regex = "jdbc:mongodb://(\\w*|(\\w*)/[a-zA-Z0-9-_\\.]+):(\\d++)/(\\w*)";
                Pattern p = Pattern.compile(regex);
                Matcher matcher = p.matcher(url);
                if (!matcher.find()) {
                    throw new WrongConfigurationException("Invalid MongoDB uri: " + url + " received for stream: " + siddhiStreamName + ". Expected uri format: jdbc:mongodb://<replica_set_name>/<host>:<port>/<database_name>");
                }
                host = matcher.group(1);
                String replicaSetName = matcher.group(2);
                port = Integer.parseInt(matcher.group(3));
                database = matcher.group(4);
                configMap.put("connector.class", "io.debezium.connector.mongodb.MongoDbConnector");
                configMap.put("mongodb.hosts", host + ":" + port);
                configMap.put("mongodb.name", replicaSetName);
                configMap.put("collection.include.list", database + "." + tableName);
                if (metrics == null) break;
                metrics.setDbType("MongoDB");
                break;
            }
            default: {
                throw new WrongConfigurationException("Unsupported schema. Expected schema: mysql or postgresqlor sqlserver, oracle or mongodb Found: " + splittedURL[1]);
            }
        }
        if (metrics != null) {
            metrics.setHost(host);
            metrics.setDatabaseName(database);
            metrics.getTotalReadsMetrics();
            metrics.getEventCountMetric();
            metrics.getTotalEventCounterMetric();
            metrics.getValidEventCountMetric();
        }
        if (!isMongodb.booleanValue()) {
            configMap.put("database.user", username);
            configMap.put("database.password", password);
        } else {
            configMap.put("mongodb.user", username);
            configMap.put("mongodb.password", password);
        }
        if (serverID == -1) {
            Random random = new Random();
            configMap.put("server.id", random.nextInt(1001) + 5400);
        } else {
            configMap.put("server.id", serverID);
        }
        if (serverName.equals("")) {
            configMap.put("database.server.name", host + "_" + port);
        } else {
            configMap.put("database.server.name", serverName);
        }
        configMap.put("offset.storage", InMemoryOffsetBackingStore.class.getName());
        configMap.put("cdc.source.object", cdcSourceHashCode);
        configMap.put("database.history", "io.debezium.relational.history.FileDatabaseHistory");
        configMap.put("database.history.file.filename", historyFileDirectory + siddhiStreamName + ".dat");
        configMap.put("name", siddhiAppName + siddhiStreamName);
        for (Map.Entry entry : connectorPropertiesMap.entrySet()) {
            configMap.put((String)entry.getKey(), entry.getValue());
        }
        return configMap;
    }

    private static Map<String, String> getConnectorPropertiesMap(String connectorProperties) {
        HashMap<String, String> connectorPropertiesMap = new HashMap<String, String>();
        if (!connectorProperties.isEmpty()) {
            String[] keyValuePairs;
            for (String keyValuePair : keyValuePairs = connectorProperties.split(",")) {
                String[] keyAndValue = keyValuePair.split("=");
                if (keyAndValue.length != 2) {
                    throw new SiddhiAppValidationException("connector.properties input is invalid. Check near :" + keyValuePair);
                }
                connectorPropertiesMap.put(keyAndValue[0], keyAndValue[1]);
            }
        }
        return connectorPropertiesMap;
    }

    public static String getCarbonHome() {
        String path = System.getProperty("carbon.home");
        if (path == null) {
            path = System.getProperty("user.dir");
        }
        return path;
    }
}

