/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.health;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.health.ConnectClusterState;
import org.apache.kafka.connect.health.ConnectorHealth;
import org.apache.kafka.connect.health.ConnectorState;
import org.apache.kafka.connect.health.ConnectorType;
import org.apache.kafka.connect.health.TaskState;
import org.apache.kafka.connect.runtime.HerderProvider;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorStateInfo;
import org.apache.kafka.connect.util.Callback;

public class ConnectClusterStateImpl
implements ConnectClusterState {
    private HerderProvider herderProvider;

    public ConnectClusterStateImpl(HerderProvider herderProvider) {
        this.herderProvider = herderProvider;
    }

    @Override
    public Collection<String> connectors() {
        final ArrayList<String> connectors = new ArrayList<String>();
        this.herderProvider.get().connectors(new Callback<Collection<String>>(){

            @Override
            public void onCompletion(Throwable error, Collection<String> result) {
                connectors.addAll(result);
            }
        });
        return connectors;
    }

    @Override
    public ConnectorHealth connectorHealth(String connName) {
        ConnectorStateInfo state = this.herderProvider.get().connectorStatus(connName);
        ConnectorState connectorState = new ConnectorState(state.connector().state(), state.connector().workerId(), state.connector().trace());
        Map<Integer, TaskState> taskStates = this.taskStates(state.tasks());
        ConnectorHealth connectorHealth = new ConnectorHealth(connName, connectorState, taskStates, ConnectorType.valueOf(state.type().name()));
        return connectorHealth;
    }

    private Map<Integer, TaskState> taskStates(List<ConnectorStateInfo.TaskState> states) {
        HashMap<Integer, TaskState> taskStates = new HashMap<Integer, TaskState>();
        for (ConnectorStateInfo.TaskState state : states) {
            taskStates.put(state.id(), new TaskState(state.id(), state.workerId(), state.state(), state.trace()));
        }
        return taskStates;
    }
}

