/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.jmx.BinaryLogClientStatistics;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.mysql.BinlogReaderMetricsMXBean;
import io.debezium.connector.mysql.MySqlSchema;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.pipeline.metrics.Metrics;
import io.debezium.util.Collect;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class BinlogReaderMetrics
extends Metrics
implements BinlogReaderMetricsMXBean {
    private final BinaryLogClient client;
    private final BinaryLogClientStatistics stats;
    private final MySqlSchema schema;
    private final AtomicLong numberOfCommittedTransactions = new AtomicLong();
    private final AtomicLong numberOfRolledBackTransactions = new AtomicLong();
    private final AtomicLong numberOfNotWellFormedTransactions = new AtomicLong();
    private final AtomicLong numberOfLargeTransactions = new AtomicLong();
    private final AtomicBoolean isGtidModeEnabled = new AtomicBoolean(false);
    private final AtomicReference<String> lastTransactionId = new AtomicReference();

    public BinlogReaderMetrics(BinaryLogClient client, MySqlTaskContext taskContext, String name, ChangeEventQueueMetrics changeEventQueueMetrics) {
        super(taskContext, name, changeEventQueueMetrics, null);
        this.client = client;
        this.stats = new BinaryLogClientStatistics(client);
        this.schema = taskContext.dbSchema();
    }

    @Override
    public boolean isConnected() {
        return this.client.isConnected();
    }

    @Override
    public String getBinlogFilename() {
        return this.client.getBinlogFilename();
    }

    @Override
    public long getBinlogPosition() {
        return this.client.getBinlogPosition();
    }

    @Override
    public String getGtidSet() {
        return this.client.getGtidSet();
    }

    @Override
    public boolean getIsGtidModeEnabled() {
        return this.isGtidModeEnabled.get();
    }

    @Override
    public String getLastEvent() {
        return this.stats.getLastEvent();
    }

    @Override
    public long getSecondsSinceLastEvent() {
        return this.stats.getSecondsSinceLastEvent();
    }

    @Override
    public long getMilliSecondsSinceLastEvent() {
        return this.stats.getSecondsSinceLastEvent() * 1000L;
    }

    @Override
    public long getSecondsBehindMaster() {
        return this.stats.getSecondsBehindMaster();
    }

    @Override
    public long getTotalNumberOfEventsSeen() {
        return this.stats.getTotalNumberOfEventsSeen();
    }

    @Override
    public long getNumberOfSkippedEvents() {
        return this.stats.getNumberOfSkippedEvents();
    }

    @Override
    public long getNumberOfDisconnects() {
        return this.stats.getNumberOfDisconnects();
    }

    @Override
    public void reset() {
        this.stats.reset();
        this.numberOfCommittedTransactions.set(0L);
        this.numberOfRolledBackTransactions.set(0L);
        this.numberOfNotWellFormedTransactions.set(0L);
        this.numberOfLargeTransactions.set(0L);
        this.lastTransactionId.set(null);
        this.isGtidModeEnabled.set(false);
    }

    @Override
    public long getNumberOfCommittedTransactions() {
        return this.numberOfCommittedTransactions.get();
    }

    @Override
    public long getNumberOfRolledBackTransactions() {
        return this.numberOfRolledBackTransactions.get();
    }

    @Override
    public long getNumberOfNotWellFormedTransactions() {
        return this.numberOfNotWellFormedTransactions.get();
    }

    @Override
    public long getNumberOfLargeTransactions() {
        return this.numberOfLargeTransactions.get();
    }

    public void onCommittedTransaction() {
        this.numberOfCommittedTransactions.incrementAndGet();
    }

    public void onRolledBackTransaction() {
        this.numberOfRolledBackTransactions.incrementAndGet();
    }

    public void onNotWellFormedTransaction() {
        this.numberOfNotWellFormedTransactions.incrementAndGet();
    }

    public void onLargeTransaction() {
        this.numberOfLargeTransactions.incrementAndGet();
    }

    public void onGtidChange(String gtid) {
        this.lastTransactionId.set(gtid);
    }

    public void setIsGtidModeEnabled(boolean enabled) {
        this.isGtidModeEnabled.set(enabled);
    }

    @Override
    public String[] getMonitoredTables() {
        return this.schema.monitoredTablesAsStringArray();
    }

    @Override
    public long getMilliSecondsBehindSource() {
        return this.getSecondsBehindMaster() * 1000L;
    }

    @Override
    public Map<String, String> getSourceEventPosition() {
        return Collect.hashMapOf("filename", this.getBinlogFilename(), "position", Long.toString(this.getBinlogPosition()), "gtid", this.getGtidSet());
    }

    @Override
    public String getLastTransactionId() {
        return this.lastTransactionId.get();
    }
}

