/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.connector.mysql.AbstractReader;
import io.debezium.connector.mysql.Filters;
import io.debezium.connector.mysql.MySqlConnector;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlSchema;
import io.debezium.connector.mysql.MySqlTaskContext;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.RecordMakers;
import io.debezium.connector.mysql.SnapshotReaderMetrics;
import io.debezium.connector.mysql.SourceInfo;
import io.debezium.function.BlockingConsumer;
import io.debezium.function.BufferedBlockingConsumer;
import io.debezium.function.Predicates;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.ddl.DdlChanges;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;

public class SnapshotReader
extends AbstractReader {
    private final boolean includeData;
    private RecordRecorder recorder;
    private final SnapshotReaderMetrics metrics;
    private ExecutorService executorService;
    private final MySqlConnectorConfig.SnapshotLockingMode snapshotLockingMode;

    public SnapshotReader(String name, MySqlTaskContext context) {
        super(name, context, null);
        this.includeData = context.snapshotMode().includeData();
        this.snapshotLockingMode = context.getConnectorConfig().getSnapshotLockingMode();
        this.recorder = this::recordRowAsRead;
        this.metrics = new SnapshotReaderMetrics(context, context.dbSchema(), this.changeEventQueueMetrics);
    }

    public SnapshotReader generateReadEvents() {
        this.recorder = this::recordRowAsRead;
        return this;
    }

    public SnapshotReader generateInsertEvents() {
        this.recorder = this::recordRowAsInsert;
        return this;
    }

    @Override
    protected void doInitialize() {
        this.metrics.register(this.logger);
    }

    @Override
    public void doDestroy() {
        this.metrics.unregister(this.logger);
    }

    @Override
    protected void doStart() {
        this.executorService = Threads.newSingleThreadExecutor(MySqlConnector.class, this.context.getConnectorConfig().getLogicalName(), "snapshot");
        this.executorService.execute(this::execute);
    }

    @Override
    protected void doStop() {
        this.logger.debug("Stopping snapshot reader");
        this.cleanupResources();
    }

    @Override
    protected void doCleanup() {
        this.executorService.shutdown();
        this.logger.debug("Completed writing all snapshot records");
    }

    protected Object readField(ResultSet rs, int fieldNo, Column actualColumn) throws SQLException {
        if (actualColumn.jdbcType() == 92) {
            return this.readTimeField(rs, fieldNo);
        }
        if (actualColumn.jdbcType() == 93) {
            return rs.getTimestamp(fieldNo, Calendar.getInstance());
        }
        return rs.getObject(fieldNo);
    }

    private Object readTimeField(ResultSet rs, int fieldNo) throws SQLException {
        Blob b = rs.getBlob(fieldNo);
        if (b == null) {
            return null;
        }
        try {
            return MySqlValueConverters.stringToDuration(new String(b.getBytes(1L, (int)b.length()), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("Could not read MySQL TIME value as UTF-8");
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void execute() {
        block182: {
            this.context.configureLoggingContext("snapshot");
            sql = new AtomicReference<String>();
            mysql = this.connectionContext.jdbc();
            schema = this.context.dbSchema();
            filters = schema.filters();
            source = this.context.source();
            clock = this.context.getClock();
            ts = clock.currentTimeInMillis();
            this.logger.info("Starting snapshot for {} with user '{}' with locking mode '{}'", new Object[]{this.connectionContext.connectionString(), mysql.username(), this.snapshotLockingMode.getValue()});
            this.logRolesForCurrentUser(mysql);
            this.logServerInformation(mysql);
            isLocked = false;
            isTxnStarted = false;
            tableLocks = false;
            try {
                block190: {
                    block181: {
                        block180: {
                            block178: {
                                block189: {
                                    block179: {
                                        block175: {
                                            block188: {
                                                block176: {
                                                    block173: {
                                                        block187: {
                                                            block174: {
                                                                block171: {
                                                                    block186: {
                                                                        block172: {
                                                                            block169: {
                                                                                block185: {
                                                                                    block170: {
                                                                                        block167: {
                                                                                            block184: {
                                                                                                block168: {
                                                                                                    block166: {
                                                                                                        block164: {
                                                                                                            block183: {
                                                                                                                block165: {
                                                                                                                    this.metrics.snapshotStarted();
                                                                                                                    if (!this.isRunning()) {
                                                                                                                        return;
                                                                                                                    }
                                                                                                                    this.logger.info("Step 0: disabling autocommit and enabling repeatable read transactions");
                                                                                                                    mysql.setAutoCommit(false);
                                                                                                                    sql.set("SET TRANSACTION ISOLATION LEVEL REPEATABLE READ");
                                                                                                                    mysql.executeWithoutCommitting(new String[]{(String)sql.get()});
                                                                                                                    systemVariables = this.connectionContext.readMySqlCharsetSystemVariables();
                                                                                                                    setSystemVariablesStatement = this.connectionContext.setStatementFor(systemVariables);
                                                                                                                    interrupted = new AtomicBoolean(false);
                                                                                                                    lockAcquired = 0L;
                                                                                                                    step = 1;
                                                                                                                    if (this.isRunning()) break block164;
                                                                                                                    rolledBack = false;
                                                                                                                    if (!isTxnStarted) break block165;
                                                                                                                    if (interrupted.get() || !this.isRunning()) {
                                                                                                                        this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                                                                                                        mysql.connection().rollback();
                                                                                                                        this.metrics.snapshotAborted();
                                                                                                                        rolledBack = true;
                                                                                                                    } else {
                                                                                                                        this.logger.info("Step {}: committing transaction", (Object)step++);
                                                                                                                        mysql.connection().commit();
                                                                                                                        this.metrics.snapshotCompleted();
                                                                                                                    }
                                                                                                                    break block183;
                                                                                                                }
                                                                                                                mysql.connection().rollback();
                                                                                                            }
                                                                                                            if (isLocked && !rolledBack) {
                                                                                                                if (tableLocks) {
                                                                                                                    this.logger.info("Step {}: releasing table read locks to enable MySQL writes", (Object)step++);
                                                                                                                } else {
                                                                                                                    this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                                                                                                }
                                                                                                                sql.set("UNLOCK TABLES");
                                                                                                                mysql.executeWithoutCommitting(new String[]{(String)sql.get()});
                                                                                                                isLocked = false;
                                                                                                                lockReleased = clock.currentTimeInMillis();
                                                                                                                this.metrics.globalLockReleased();
                                                                                                                if (this.logger.isInfoEnabled()) {
                                                                                                                    if (tableLocks) {
                                                                                                                        this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration(lockReleased - lockAcquired));
                                                                                                                    } else {
                                                                                                                        this.logger.info("Writes to MySQL tables prevented for a total of {}", (Object)Strings.duration(lockReleased - lockAcquired));
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                            return;
                                                                                                        }
                                                                                                        if (!this.snapshotLockingMode.equals(MySqlConnectorConfig.SnapshotLockingMode.NONE)) {
                                                                                                            try {
                                                                                                                this.logger.info("Step 1: flush and obtain global read lock to prevent writes to database");
                                                                                                                sql.set("FLUSH TABLES WITH READ LOCK");
                                                                                                                mysql.executeWithoutCommitting(new String[]{(String)sql.get()});
                                                                                                                lockAcquired = clock.currentTimeInMillis();
                                                                                                                this.metrics.globalLockAcquired();
                                                                                                                isLocked = true;
                                                                                                            }
                                                                                                            catch (SQLException e) {
                                                                                                                this.logger.info("Step 1: unable to flush and acquire global read lock, will use table read locks after reading table names");
                                                                                                                if (SnapshotReader.$assertionsDisabled || !isLocked) break block166;
                                                                                                                throw new AssertionError();
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                    if (this.isRunning()) break block167;
                                                                                                    rolledBack = false;
                                                                                                    if (!isTxnStarted) break block168;
                                                                                                    if (interrupted.get() || !this.isRunning()) {
                                                                                                        this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                                                                                        mysql.connection().rollback();
                                                                                                        this.metrics.snapshotAborted();
                                                                                                        rolledBack = true;
                                                                                                    } else {
                                                                                                        this.logger.info("Step {}: committing transaction", (Object)step++);
                                                                                                        mysql.connection().commit();
                                                                                                        this.metrics.snapshotCompleted();
                                                                                                    }
                                                                                                    break block184;
                                                                                                }
                                                                                                mysql.connection().rollback();
                                                                                            }
                                                                                            if (isLocked && !rolledBack) {
                                                                                                if (tableLocks) {
                                                                                                    this.logger.info("Step {}: releasing table read locks to enable MySQL writes", (Object)step++);
                                                                                                } else {
                                                                                                    this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                                                                                }
                                                                                                sql.set("UNLOCK TABLES");
                                                                                                mysql.executeWithoutCommitting(new String[]{(String)sql.get()});
                                                                                                isLocked = false;
                                                                                                lockReleased = clock.currentTimeInMillis();
                                                                                                this.metrics.globalLockReleased();
                                                                                                if (this.logger.isInfoEnabled()) {
                                                                                                    if (tableLocks) {
                                                                                                        this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration(lockReleased - lockAcquired));
                                                                                                    } else {
                                                                                                        this.logger.info("Writes to MySQL tables prevented for a total of {}", (Object)Strings.duration(lockReleased - lockAcquired));
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                            return;
                                                                                        }
                                                                                        this.logger.info("Step 2: start transaction with consistent snapshot");
                                                                                        sql.set("START TRANSACTION WITH CONSISTENT SNAPSHOT");
                                                                                        mysql.executeWithoutCommitting(new String[]{(String)sql.get()});
                                                                                        isTxnStarted = true;
                                                                                        if (this.isRunning()) break block169;
                                                                                        rolledBack = false;
                                                                                        if (!isTxnStarted) break block170;
                                                                                        if (interrupted.get() || !this.isRunning()) {
                                                                                            this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                                                                            mysql.connection().rollback();
                                                                                            this.metrics.snapshotAborted();
                                                                                            rolledBack = true;
                                                                                        } else {
                                                                                            this.logger.info("Step {}: committing transaction", (Object)step++);
                                                                                            mysql.connection().commit();
                                                                                            this.metrics.snapshotCompleted();
                                                                                        }
                                                                                        break block185;
                                                                                    }
                                                                                    mysql.connection().rollback();
                                                                                }
                                                                                if (isLocked && !rolledBack) {
                                                                                    if (tableLocks) {
                                                                                        this.logger.info("Step {}: releasing table read locks to enable MySQL writes", (Object)step++);
                                                                                    } else {
                                                                                        this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                                                                    }
                                                                                    sql.set("UNLOCK TABLES");
                                                                                    mysql.executeWithoutCommitting(new String[]{sql.get()});
                                                                                    isLocked = false;
                                                                                    lockReleased = clock.currentTimeInMillis();
                                                                                    this.metrics.globalLockReleased();
                                                                                    if (this.logger.isInfoEnabled()) {
                                                                                        if (tableLocks) {
                                                                                            this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration(lockReleased - lockAcquired));
                                                                                        } else {
                                                                                            this.logger.info("Writes to MySQL tables prevented for a total of {}", (Object)Strings.duration(lockReleased - lockAcquired));
                                                                                        }
                                                                                    }
                                                                                }
                                                                                return;
                                                                            }
                                                                            step = 3;
                                                                            if (isLocked) {
                                                                                this.readBinlogPosition(step++, source, mysql, sql);
                                                                            }
                                                                            if (this.isRunning()) break block171;
                                                                            rolledBack = false;
                                                                            if (!isTxnStarted) break block172;
                                                                            if (interrupted.get() || !this.isRunning()) {
                                                                                this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                                                                mysql.connection().rollback();
                                                                                this.metrics.snapshotAborted();
                                                                                rolledBack = true;
                                                                            } else {
                                                                                this.logger.info("Step {}: committing transaction", (Object)step++);
                                                                                mysql.connection().commit();
                                                                                this.metrics.snapshotCompleted();
                                                                            }
                                                                            break block186;
                                                                        }
                                                                        mysql.connection().rollback();
                                                                    }
                                                                    if (isLocked && !rolledBack) {
                                                                        if (tableLocks) {
                                                                            this.logger.info("Step {}: releasing table read locks to enable MySQL writes", (Object)step++);
                                                                        } else {
                                                                            this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                                                        }
                                                                        sql.set("UNLOCK TABLES");
                                                                        mysql.executeWithoutCommitting(new String[]{sql.get()});
                                                                        isLocked = false;
                                                                        lockReleased = clock.currentTimeInMillis();
                                                                        this.metrics.globalLockReleased();
                                                                        if (this.logger.isInfoEnabled()) {
                                                                            if (tableLocks) {
                                                                                this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration(lockReleased - lockAcquired));
                                                                            } else {
                                                                                this.logger.info("Writes to MySQL tables prevented for a total of {}", (Object)Strings.duration(lockReleased - lockAcquired));
                                                                            }
                                                                        }
                                                                    }
                                                                    return;
                                                                }
                                                                this.logger.info("Step {}: read list of available databases", (Object)step++);
                                                                databaseNames = new ArrayList<E>();
                                                                sql.set("SHOW DATABASES");
                                                                mysql.query(sql.get(), (JdbcConnection.ResultSetConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)V, lambda$execute$0(java.util.List java.sql.ResultSet ), (Ljava/sql/ResultSet;)V)(databaseNames));
                                                                this.logger.info("\t list of available databases is: {}", databaseNames);
                                                                if (this.isRunning()) break block173;
                                                                rolledBack = false;
                                                                if (!isTxnStarted) break block174;
                                                                if (interrupted.get() || !this.isRunning()) {
                                                                    this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                                                    mysql.connection().rollback();
                                                                    this.metrics.snapshotAborted();
                                                                    rolledBack = true;
                                                                } else {
                                                                    this.logger.info("Step {}: committing transaction", (Object)step++);
                                                                    mysql.connection().commit();
                                                                    this.metrics.snapshotCompleted();
                                                                }
                                                                break block187;
                                                            }
                                                            mysql.connection().rollback();
                                                        }
                                                        if (isLocked && !rolledBack) {
                                                            if (tableLocks) {
                                                                this.logger.info("Step {}: releasing table read locks to enable MySQL writes", (Object)step++);
                                                            } else {
                                                                this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                                            }
                                                            sql.set("UNLOCK TABLES");
                                                            mysql.executeWithoutCommitting(new String[]{sql.get()});
                                                            isLocked = false;
                                                            lockReleased = clock.currentTimeInMillis();
                                                            this.metrics.globalLockReleased();
                                                            if (this.logger.isInfoEnabled()) {
                                                                if (tableLocks) {
                                                                    this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration(lockReleased - lockAcquired));
                                                                } else {
                                                                    this.logger.info("Writes to MySQL tables prevented for a total of {}", (Object)Strings.duration(lockReleased - lockAcquired));
                                                                }
                                                            }
                                                        }
                                                        return;
                                                    }
                                                    this.logger.info("Step {}: read list of available tables in each database", (Object)step++);
                                                    tableIds = new ArrayList<TableId>();
                                                    createTableFilters = this.getCreateTableFilters(filters);
                                                    createTablesMap = new HashMap<K, V>();
                                                    readableDatabaseNames = new HashSet<String>();
                                                    for (String dbName : databaseNames) {
                                                        try {
                                                            sql.set("SHOW FULL TABLES IN " + this.quote(dbName) + " where Table_Type = 'BASE TABLE'");
                                                            mysql.query(sql.get(), (JdbcConnection.ResultSetConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)V, lambda$execute$2(java.lang.String io.debezium.connector.mysql.Filters java.util.Map io.debezium.connector.mysql.Filters java.util.List java.sql.ResultSet ), (Ljava/sql/ResultSet;)V)((SnapshotReader)this, (String)dbName, (Filters)createTableFilters, createTablesMap, (Filters)filters, tableIds));
                                                            readableDatabaseNames.add(dbName);
                                                        }
                                                        catch (SQLException e) {
                                                            this.logger.warn("\t skipping database '{}' due to error reading tables: {}", (Object)dbName, (Object)e.getMessage());
                                                        }
                                                    }
                                                    tableWhitelistPattern = Strings.listOfRegex(this.context.config().getString(MySqlConnectorConfig.TABLE_WHITELIST), 2);
                                                    tableIdsSorted = new ArrayList<E>();
                                                    tableWhitelistPattern.forEach((Consumer<Pattern>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$5(java.util.List java.util.List java.util.regex.Pattern ), (Ljava/util/regex/Pattern;)V)(tableIds, tableIdsSorted));
                                                    tableIds.sort(Comparator.comparing((Function<TableId, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, indexOf(java.lang.Object ), (Lio/debezium/relational/TableId;)Ljava/lang/Integer;)(tableIdsSorted)));
                                                    includedDatabaseNames = readableDatabaseNames.stream().filter(filters.databaseFilter()).collect(Collectors.toSet());
                                                    this.logger.info("\tsnapshot continuing with database(s): {}", includedDatabaseNames);
                                                    if (!isLocked) {
                                                        if (!this.snapshotLockingMode.equals(MySqlConnectorConfig.SnapshotLockingMode.NONE)) {
                                                            if (!this.connectionContext.userHasPrivileges("LOCK TABLES")) {
                                                                throw new ConnectException("User does not have the 'LOCK TABLES' privilege required to obtain a consistent snapshot by preventing concurrent writes to tables.");
                                                            }
                                                            this.logger.info("Step {}: flush and obtain read lock for {} tables (preventing writes)", (Object)step++, (Object)tableIds.size());
                                                            tableList = tableIds.stream().map((Function<TableId, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$execute$6(io.debezium.relational.TableId ), (Lio/debezium/relational/TableId;)Ljava/lang/String;)((SnapshotReader)this)).reduce((BinaryOperator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$execute$7(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)()).orElse(null);
                                                            if (tableList != null) {
                                                                sql.set("FLUSH TABLES " + tableList + " WITH READ LOCK");
                                                                mysql.executeWithoutCommitting(new String[]{sql.get()});
                                                            }
                                                            lockAcquired = clock.currentTimeInMillis();
                                                            this.metrics.globalLockAcquired();
                                                            isLocked = true;
                                                            tableLocks = true;
                                                        }
                                                        this.readBinlogPosition(step++, source, mysql, sql);
                                                    }
                                                    try {
                                                        this.logger.info("Step {}: generating DROP and CREATE statements to reflect current database schemas:", (Object)step++);
                                                        schema.applyDdl(source, null, setSystemVariablesStatement, (DdlChanges.DatabaseStatementStringConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Ljava/lang/String;)V, enqueueSchemaChanges(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((SnapshotReader)this));
                                                        allTableIds = new ArrayList<TableId>(schema.tableIds());
                                                        allTableIds.addAll(tableIds);
                                                        allTableIds.stream().filter((Predicate<TableId>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$execute$8(io.debezium.relational.TableId ), (Lio/debezium/relational/TableId;)Z)((SnapshotReader)this)).forEach((Consumer<TableId>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$9(io.debezium.connector.mysql.MySqlSchema io.debezium.connector.mysql.SourceInfo io.debezium.relational.TableId ), (Lio/debezium/relational/TableId;)V)((SnapshotReader)this, (MySqlSchema)schema, (SourceInfo)source));
                                                        schema.tableIds().stream().map((Function<TableId, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, catalog(), (Lio/debezium/relational/TableId;)Ljava/lang/String;)()).filter(Predicates.not((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(readableDatabaseNames))).filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$execute$10(java.lang.String ), (Ljava/lang/String;)Z)((SnapshotReader)this)).forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$11(io.debezium.connector.mysql.MySqlSchema io.debezium.connector.mysql.SourceInfo java.lang.String ), (Ljava/lang/String;)V)((SnapshotReader)this, (MySqlSchema)schema, (SourceInfo)source));
                                                        block68: for (Map.Entry<K, V> entry : createTablesMap.entrySet()) {
                                                            if (!this.isRunning()) break;
                                                            dbName = (String)entry.getKey();
                                                            schema.applyDdl(source, dbName, "DROP DATABASE IF EXISTS " + this.quote(dbName), (DdlChanges.DatabaseStatementStringConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Ljava/lang/String;)V, enqueueSchemaChanges(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((SnapshotReader)this));
                                                            schema.applyDdl(source, dbName, "CREATE DATABASE " + this.quote(dbName), (DdlChanges.DatabaseStatementStringConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Ljava/lang/String;)V, enqueueSchemaChanges(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((SnapshotReader)this));
                                                            schema.applyDdl(source, dbName, "USE " + this.quote(dbName), (DdlChanges.DatabaseStatementStringConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;Ljava/lang/String;)V, enqueueSchemaChanges(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)V)((SnapshotReader)this));
                                                            for (TableId tableId : (List)entry.getValue()) {
                                                                if (!this.isRunning()) continue block68;
                                                                sql.set("SHOW CREATE TABLE " + this.quote(tableId));
                                                                mysql.query(sql.get(), (JdbcConnection.ResultSetConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)V, lambda$execute$12(io.debezium.connector.mysql.MySqlSchema io.debezium.connector.mysql.SourceInfo java.lang.String java.sql.ResultSet ), (Ljava/sql/ResultSet;)V)((SnapshotReader)this, (MySqlSchema)schema, (SourceInfo)source, (String)dbName));
                                                            }
                                                        }
                                                        this.context.makeRecord().regenerate();
                                                    }
                                                    catch (Exception e) {
                                                        interrupted.set(true);
                                                        throw e;
                                                    }
                                                    if (this.snapshotLockingMode.equals(MySqlConnectorConfig.SnapshotLockingMode.MINIMAL) && isLocked) {
                                                        if (tableLocks) {
                                                            this.logger.info("Step {}: tables were locked explicitly, but to get a consistent snapshot we cannot release the locks until we've read all tables.", (Object)step++);
                                                        } else {
                                                            this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step);
                                                            sql.set("UNLOCK TABLES");
                                                            mysql.executeWithoutCommitting(new String[]{sql.get()});
                                                            isLocked = false;
                                                            lockReleased = clock.currentTimeInMillis();
                                                            this.metrics.globalLockReleased();
                                                            this.logger.info("Step {}: blocked writes to MySQL for a total of {}", (Object)step++, (Object)Strings.duration(lockReleased - lockAcquired));
                                                        }
                                                    }
                                                    if (this.isRunning()) break block175;
                                                    rolledBack = false;
                                                    if (!isTxnStarted) break block176;
                                                    if (interrupted.get() || !this.isRunning()) {
                                                        this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                                        mysql.connection().rollback();
                                                        this.metrics.snapshotAborted();
                                                        rolledBack = true;
                                                    } else {
                                                        this.logger.info("Step {}: committing transaction", (Object)step++);
                                                        mysql.connection().commit();
                                                        this.metrics.snapshotCompleted();
                                                    }
                                                    break block188;
                                                }
                                                mysql.connection().rollback();
                                            }
                                            if (isLocked && !rolledBack) {
                                                if (tableLocks) {
                                                    this.logger.info("Step {}: releasing table read locks to enable MySQL writes", (Object)step++);
                                                } else {
                                                    this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                                }
                                                sql.set("UNLOCK TABLES");
                                                mysql.executeWithoutCommitting(new String[]{sql.get()});
                                                isLocked = false;
                                                lockReleased = clock.currentTimeInMillis();
                                                this.metrics.globalLockReleased();
                                                if (this.logger.isInfoEnabled()) {
                                                    if (tableLocks) {
                                                        this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration(lockReleased - lockAcquired));
                                                    } else {
                                                        this.logger.info("Writes to MySQL tables prevented for a total of {}", (Object)Strings.duration(lockReleased - lockAcquired));
                                                    }
                                                }
                                            }
                                            return;
                                        }
                                        try {
                                            if (!this.includeData) ** GOTO lbl486
                                            bufferedRecordQueue = BufferedBlockingConsumer.bufferLast((BlockingConsumer<SourceRecord>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$13(org.apache.kafka.connect.source.SourceRecord ), (Lorg/apache/kafka/connect/source/SourceRecord;)V)((SnapshotReader)this));
                                            this.logger.info("Step {}: scanning contents of {} tables while still in transaction", (Object)step, (Object)tableIds.size());
                                            this.metrics.monitoredTablesDetermined(tableIds);
                                            startScan = clock.currentTimeInMillis();
                                            totalRowCount = new AtomicLong();
                                            counter = 0;
                                            completedCounter = 0;
                                            largeTableCount = this.context.rowCountForLargeTable();
                                            for (TableId tableId : tableIds) {
                                                rowNum = new AtomicLong();
                                                if (!this.isRunning()) break;
                                                recordMaker = this.context.makeRecord().forTable(tableId, null, bufferedRecordQueue);
                                                if (recordMaker != null) {
                                                    sql.set("USE " + this.quote(tableId.catalog()) + ";");
                                                    mysql.executeWithoutCommitting(new String[]{sql.get()});
                                                    numRows = new AtomicLong(-1L);
                                                    rowCountStr = new AtomicReference<String>("<unknown>");
                                                    statementFactory = (JdbcConnection.StatementFactory)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/Connection;)Ljava/sql/Statement;, createStatementWithLargeResultSet(java.sql.Connection ), (Ljava/sql/Connection;)Ljava/sql/Statement;)((SnapshotReader)this);
                                                    if (largeTableCount > 0L) {
                                                        try {
                                                            sql.set("SHOW TABLE STATUS LIKE '" + tableId.table() + "';");
                                                            mysql.query(sql.get(), (JdbcConnection.ResultSetConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)V, lambda$execute$14(java.util.concurrent.atomic.AtomicLong java.sql.ResultSet ), (Ljava/sql/ResultSet;)V)((AtomicLong)numRows));
                                                            if (numRows.get() <= largeTableCount) {
                                                                statementFactory = (JdbcConnection.StatementFactory)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/Connection;)Ljava/sql/Statement;, createStatement(java.sql.Connection ), (Ljava/sql/Connection;)Ljava/sql/Statement;)((SnapshotReader)this);
                                                            }
                                                            rowCountStr.set(numRows.toString());
                                                        }
                                                        catch (SQLException e) {
                                                            this.logger.debug("Error while getting number of rows in table {}: {}", new Object[]{tableId, e.getMessage(), e});
                                                        }
                                                    }
                                                    start = clock.currentTimeInMillis();
                                                    this.logger.info("Step {}: - scanning table '{}' ({} of {} tables)", new Object[]{step, tableId, ++counter, tableIds.size()});
                                                    selectOverrides = this.getSnapshotSelectOverridesByTable();
                                                    selectStatement = selectOverrides.getOrDefault(tableId, "SELECT * FROM " + this.quote(tableId));
                                                    this.logger.info("For table '{}' using select statement: '{}'", (Object)tableId, (Object)selectStatement);
                                                    sql.set(selectStatement);
                                                    try {
                                                        stepNum = step;
                                                        mysql.query(sql.get(), statementFactory, (JdbcConnection.ResultSetConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/sql/ResultSet;)V, lambda$execute$15(io.debezium.connector.mysql.MySqlSchema io.debezium.relational.TableId io.debezium.connector.mysql.RecordMakers$RecordsForTable long java.util.concurrent.atomic.AtomicLong io.debezium.util.Clock int java.util.concurrent.atomic.AtomicReference long java.util.concurrent.atomic.AtomicLong java.util.concurrent.atomic.AtomicBoolean java.sql.ResultSet ), (Ljava/sql/ResultSet;)V)((SnapshotReader)this, (MySqlSchema)schema, (TableId)tableId, (RecordMakers.RecordsForTable)recordMaker, (long)ts, (AtomicLong)rowNum, (Clock)clock, (int)stepNum, rowCountStr, (long)start, (AtomicLong)totalRowCount, (AtomicBoolean)interrupted));
                                                    }
                                                    finally {
                                                        this.metrics.tableSnapshotCompleted(tableId, rowNum.get());
                                                        if (interrupted.get()) break;
                                                    }
                                                }
                                                ++completedCounter;
                                            }
                                            if (this.isRunning() && !interrupted.get()) break block178;
                                            rolledBack = false;
                                            if (!isTxnStarted) break block179;
                                        }
                                        catch (Throwable var47_85) {
                                            rolledBack = false;
                                            if (isTxnStarted) {
                                                if (interrupted.get() || !this.isRunning()) {
                                                    this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                                    mysql.connection().rollback();
                                                    this.metrics.snapshotAborted();
                                                    rolledBack = true;
                                                } else {
                                                    this.logger.info("Step {}: committing transaction", (Object)step++);
                                                    mysql.connection().commit();
                                                    this.metrics.snapshotCompleted();
                                                }
                                            } else {
                                                mysql.connection().rollback();
                                            }
                                            if (isLocked && !rolledBack) {
                                                if (tableLocks) {
                                                    this.logger.info("Step {}: releasing table read locks to enable MySQL writes", (Object)step++);
                                                } else {
                                                    this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                                }
                                                sql.set("UNLOCK TABLES");
                                                mysql.executeWithoutCommitting(new String[]{(String)sql.get()});
                                                isLocked = false;
                                                lockReleased = clock.currentTimeInMillis();
                                                this.metrics.globalLockReleased();
                                                if (this.logger.isInfoEnabled()) {
                                                    if (tableLocks) {
                                                        this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration(lockReleased - lockAcquired));
                                                    } else {
                                                        this.logger.info("Writes to MySQL tables prevented for a total of {}", (Object)Strings.duration(lockReleased - lockAcquired));
                                                    }
                                                }
                                            }
                                            throw var47_85;
                                        }
                                        if (interrupted.get() || !this.isRunning()) {
                                            this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                                            mysql.connection().rollback();
                                            this.metrics.snapshotAborted();
                                            rolledBack = true;
                                        } else {
                                            this.logger.info("Step {}: committing transaction", (Object)step++);
                                            mysql.connection().commit();
                                            this.metrics.snapshotCompleted();
                                        }
                                        break block189;
                                    }
                                    mysql.connection().rollback();
                                }
                                if (isLocked && !rolledBack) {
                                    if (tableLocks) {
                                        this.logger.info("Step {}: releasing table read locks to enable MySQL writes", (Object)step++);
                                    } else {
                                        this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                                    }
                                    sql.set("UNLOCK TABLES");
                                    mysql.executeWithoutCommitting(new String[]{sql.get()});
                                    isLocked = false;
                                    lockReleased = clock.currentTimeInMillis();
                                    this.metrics.globalLockReleased();
                                    if (this.logger.isInfoEnabled()) {
                                        if (tableLocks) {
                                            this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration(lockReleased - lockAcquired));
                                        } else {
                                            this.logger.info("Writes to MySQL tables prevented for a total of {}", (Object)Strings.duration(lockReleased - lockAcquired));
                                        }
                                    }
                                }
                                return;
                            }
                            source.markLastSnapshot(this.context.config());
                            stop = clock.currentTimeInMillis();
                            try {
                                bufferedRecordQueue.close((Function<SourceRecord, SourceRecord>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, replaceOffset(org.apache.kafka.connect.source.SourceRecord ), (Lorg/apache/kafka/connect/source/SourceRecord;)Lorg/apache/kafka/connect/source/SourceRecord;)((SnapshotReader)this));
                                if (this.logger.isInfoEnabled()) {
                                    this.logger.info("Step {}: scanned {} rows in {} tables in {}", new Object[]{step, totalRowCount, tableIds.size(), Strings.duration(stop - startScan)});
                                }
                                break block180;
                            }
                            catch (InterruptedException e) {
                                Thread.interrupted();
                                if (this.logger.isInfoEnabled()) {
                                    this.logger.info("Step {}: aborting the snapshot after {} rows in {} of {} tables {}", new Object[]{step, totalRowCount, completedCounter, tableIds.size(), Strings.duration(stop - startScan)});
                                }
                                interrupted.set(true);
                            }
                            break block180;
lbl486:
                            // 1 sources

                            this.logger.info("Step {}: encountered only schema based snapshot, skipping data snapshot", (Object)step);
                        }
                        ++step;
                        rolledBack = false;
                        if (!isTxnStarted) break block181;
                        if (interrupted.get() || !this.isRunning()) {
                            this.logger.info("Step {}: rolling back transaction after abort", (Object)step++);
                            mysql.connection().rollback();
                            this.metrics.snapshotAborted();
                            rolledBack = true;
                        } else {
                            this.logger.info("Step {}: committing transaction", (Object)step++);
                            mysql.connection().commit();
                            this.metrics.snapshotCompleted();
                        }
                        break block190;
                    }
                    mysql.connection().rollback();
                }
                if (isLocked && !rolledBack) {
                    if (tableLocks) {
                        this.logger.info("Step {}: releasing table read locks to enable MySQL writes", (Object)step++);
                    } else {
                        this.logger.info("Step {}: releasing global read lock to enable MySQL writes", (Object)step++);
                    }
                    sql.set("UNLOCK TABLES");
                    mysql.executeWithoutCommitting(new String[]{sql.get()});
                    isLocked = false;
                    lockReleased = clock.currentTimeInMillis();
                    this.metrics.globalLockReleased();
                    if (this.logger.isInfoEnabled()) {
                        if (tableLocks) {
                            this.logger.info("Writes to MySQL prevented for a total of {}", (Object)Strings.duration(lockReleased - lockAcquired));
                        } else {
                            this.logger.info("Writes to MySQL tables prevented for a total of {}", (Object)Strings.duration(lockReleased - lockAcquired));
                        }
                    }
                }
                if (!this.isRunning()) {
                    try {
                        this.completeSuccessfully();
                        if (this.logger.isInfoEnabled()) {
                            stop = clock.currentTimeInMillis();
                            this.logger.info("Stopped snapshot after {} but before completing", (Object)Strings.duration(stop - ts));
                        }
                        break block182;
                    }
                    finally {
                        this.cleanupResources();
                    }
                }
                try {
                    source.completeSnapshot();
                    Heartbeat.create(this.context.config(), this.context.topicSelector().getHeartbeatTopic(), this.context.getConnectorConfig().getLogicalName()).forcedBeat(source.partition(), source.offset(), (BlockingConsumer<SourceRecord>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, enqueueRecord(org.apache.kafka.connect.source.SourceRecord ), (Lorg/apache/kafka/connect/source/SourceRecord;)V)((SnapshotReader)this));
                }
                finally {
                    this.completeSuccessfully();
                    if (this.logger.isInfoEnabled()) {
                        stop = clock.currentTimeInMillis();
                        this.logger.info("Completed snapshot in {}", (Object)Strings.duration(stop - ts));
                    }
                }
            }
            catch (Throwable e) {
                if (isLocked) {
                    try {
                        sql.set("UNLOCK TABLES");
                        mysql.executeWithoutCommitting(new String[]{(String)sql.get()});
                    }
                    catch (Exception eUnlock) {
                        this.logger.error("Removing of table locks not completed successfully", (Throwable)eUnlock);
                    }
                    try {
                        mysql.connection().rollback();
                    }
                    catch (Exception eRollback) {
                        this.logger.error("Execption while rollback is executed", (Throwable)eRollback);
                    }
                }
                this.failed(e, "Aborting snapshot due to error when last running '" + (String)sql.get() + "': " + e.getMessage());
            }
            finally {
                try {
                    mysql.close();
                }
                catch (SQLException e) {
                    this.logger.warn("Failed to close the connection properly", (Throwable)e);
                }
            }
        }
    }

    protected void readBinlogPosition(int step, SourceInfo source, JdbcConnection mysql, AtomicReference<String> sql) throws SQLException {
        if (this.context.isSchemaOnlyRecoverySnapshot()) {
            if (Strings.isNullOrEmpty(source.binlogFilename())) {
                throw new IllegalStateException("Could not find existing binlog information while attempting schema only recovery snapshot");
            }
            source.startSnapshot();
        } else {
            this.logger.info("Step {}: read binlog position of MySQL master", (Object)step);
            String showMasterStmt = "SHOW MASTER STATUS";
            sql.set(showMasterStmt);
            mysql.query(sql.get(), rs -> {
                if (rs.next()) {
                    String binlogFilename = rs.getString(1);
                    long binlogPosition = rs.getLong(2);
                    source.setBinlogStartPoint(binlogFilename, binlogPosition);
                    if (rs.getMetaData().getColumnCount() > 4) {
                        String gtidSet = rs.getString(5);
                        source.setCompletedGtidSet(gtidSet);
                        this.logger.info("\t using binlog '{}' at position '{}' and gtid '{}'", new Object[]{binlogFilename, binlogPosition, gtidSet});
                    } else {
                        this.logger.info("\t using binlog '{}' at position '{}'", (Object)binlogFilename, (Object)binlogPosition);
                    }
                } else {
                    throw new IllegalStateException("Cannot read the binlog filename and position via '" + showMasterStmt + "'. Make sure your server is correctly configured");
                }
                source.startSnapshot();
            });
        }
    }

    private Filters getCreateTableFilters(Filters filters) {
        MySqlConnectorConfig.SnapshotNewTables snapshotNewTables = this.context.getConnectorConfig().getSnapshotNewTables();
        if (snapshotNewTables == MySqlConnectorConfig.SnapshotNewTables.PARALLEL) {
            return new Filters.Builder(this.context.config()).build();
        }
        return filters;
    }

    protected String quote(String dbOrTableName) {
        return "`" + dbOrTableName + "`";
    }

    protected String quote(TableId id) {
        return this.quote(id.catalog()) + "." + this.quote(id.table());
    }

    private Statement createStatementWithLargeResultSet(Connection connection) throws SQLException {
        int fetchSize = this.context.getConnectorConfig().getSnapshotFetchSize();
        Statement stmt = connection.createStatement(1003, 1007);
        stmt.setFetchSize(fetchSize);
        return stmt;
    }

    private Statement createStatement(Connection connection) throws SQLException {
        return connection.createStatement();
    }

    private void logServerInformation(JdbcConnection mysql) {
        try {
            this.logger.info("MySQL server variables related to change data capture:");
            mysql.query("SHOW VARIABLES WHERE Variable_name REGEXP 'version|binlog|tx_|gtid|character_set|collation|time_zone'", rs -> {
                while (rs.next()) {
                    this.logger.info("\t{} = {}", (Object)Strings.pad(rs.getString(1), 45, ' '), (Object)Strings.pad(rs.getString(2), 45, ' '));
                }
            });
        }
        catch (SQLException e) {
            this.logger.info("Cannot determine MySql server version", (Throwable)e);
        }
    }

    private void logRolesForCurrentUser(JdbcConnection mysql) {
        try {
            ArrayList grants = new ArrayList();
            mysql.query("SHOW GRANTS FOR CURRENT_USER", rs -> {
                while (rs.next()) {
                    grants.add(rs.getString(1));
                }
            });
            if (grants.isEmpty()) {
                this.logger.warn("Snapshot is using user '{}' but it likely doesn't have proper privileges. If tables are missing or are empty, ensure connector is configured with the correct MySQL user and/or ensure that the MySQL user has the required privileges.", (Object)mysql.username());
            } else {
                this.logger.info("Snapshot is using user '{}' with these MySQL grants:", (Object)mysql.username());
                grants.forEach(grant -> this.logger.info("\t{}", grant));
            }
        }
        catch (SQLException e) {
            this.logger.info("Cannot determine the privileges for '{}' ", (Object)mysql.username(), (Object)e);
        }
    }

    protected SourceRecord replaceOffset(SourceRecord record) {
        if (record == null) {
            return null;
        }
        Map<String, ?> newOffset = this.context.source().offset();
        return new SourceRecord(record.sourcePartition(), newOffset, record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), record.value());
    }

    protected void enqueueSchemaChanges(String dbName, String ddlStatement) {
        if (!this.context.includeSchemaChangeRecords() || ddlStatement.length() == 0) {
            return;
        }
        if (this.context.makeRecord().schemaChanges(dbName, ddlStatement, x$0 -> super.enqueueRecord((SourceRecord)x$0)) > 0) {
            this.logger.info("\t{}", (Object)ddlStatement);
        }
    }

    protected void recordRowAsRead(RecordMakers.RecordsForTable recordMaker, Object[] row, long ts) throws InterruptedException {
        recordMaker.read(row, ts);
    }

    protected void recordRowAsInsert(RecordMakers.RecordsForTable recordMaker, Object[] row, long ts) throws InterruptedException {
        recordMaker.create(row, ts);
    }

    private Map<TableId, String> getSnapshotSelectOverridesByTable() {
        String tableList = this.context.getSnapshotSelectOverrides();
        if (tableList == null) {
            return Collections.emptyMap();
        }
        HashMap<TableId, String> snapshotSelectOverridesByTable = new HashMap<TableId, String>();
        for (String table : tableList.split(",")) {
            snapshotSelectOverridesByTable.put(TableId.parse(table), this.context.config().getString(MySqlConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + "." + table));
        }
        return snapshotSelectOverridesByTable;
    }

    private /* synthetic */ void lambda$execute$15(MySqlSchema schema, TableId tableId, RecordMakers.RecordsForTable recordMaker, long ts, AtomicLong rowNum, Clock clock, int stepNum, AtomicReference rowCountStr, long start, AtomicLong totalRowCount, AtomicBoolean interrupted, ResultSet rs) throws SQLException {
        try {
            Table table = schema.tableFor(tableId);
            int numColumns = table.columns().size();
            Object[] row = new Object[numColumns];
            while (rs.next()) {
                int i = 0;
                int j = 1;
                while (i != numColumns) {
                    Column actualColumn = table.columns().get(i);
                    row[i] = this.readField(rs, j, actualColumn);
                    ++i;
                    ++j;
                }
                this.recorder.recordRow(recordMaker, row, ts);
                rowNum.incrementAndGet();
                if (rowNum.get() % 100L == 0L && !this.isRunning()) break;
                if (rowNum.get() % 10000L != 0L) continue;
                if (this.logger.isInfoEnabled()) {
                    long stop = clock.currentTimeInMillis();
                    this.logger.info("Step {}: - {} of {} rows scanned from table '{}' after {}", new Object[]{stepNum, rowNum, rowCountStr, tableId, Strings.duration(stop - start)});
                }
                this.metrics.rowsScanned(tableId, rowNum.get());
            }
            totalRowCount.addAndGet(rowNum.get());
            if (this.isRunning()) {
                if (this.logger.isInfoEnabled()) {
                    long stop = clock.currentTimeInMillis();
                    this.logger.info("Step {}: - Completed scanning a total of {} rows from table '{}' after {}", new Object[]{stepNum, rowNum, tableId, Strings.duration(stop - start)});
                }
                this.metrics.rowsScanned(tableId, rowNum.get());
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            this.logger.info("Step {}: Stopping the snapshot due to thread interruption", (Object)stepNum);
            interrupted.set(true);
        }
    }

    private static /* synthetic */ void lambda$execute$14(AtomicLong numRows, ResultSet rs) throws SQLException {
        if (rs.next()) {
            numRows.set(rs.getLong(5));
        }
    }

    private /* synthetic */ void lambda$execute$13(SourceRecord x$0) throws InterruptedException {
        super.enqueueRecord(x$0);
    }

    private /* synthetic */ void lambda$execute$12(MySqlSchema schema, SourceInfo source, String dbName, ResultSet rs) throws SQLException {
        if (rs.next()) {
            schema.applyDdl(source, dbName, rs.getString(2), this::enqueueSchemaChanges);
        }
    }

    private /* synthetic */ void lambda$execute$11(MySqlSchema schema, SourceInfo source, String missingDbName) {
        schema.applyDdl(source, missingDbName, "DROP DATABASE IF EXISTS " + this.quote(missingDbName), this::enqueueSchemaChanges);
    }

    private /* synthetic */ boolean lambda$execute$10(String id) {
        return this.isRunning();
    }

    private /* synthetic */ void lambda$execute$9(MySqlSchema schema, SourceInfo source, TableId tableId) {
        schema.applyDdl(source, tableId.schema(), "DROP TABLE IF EXISTS " + this.quote(tableId), this::enqueueSchemaChanges);
    }

    private /* synthetic */ boolean lambda$execute$8(TableId id) {
        return this.isRunning();
    }

    private static /* synthetic */ String lambda$execute$7(String r, String element) {
        return r + "," + element;
    }

    private /* synthetic */ String lambda$execute$6(TableId tid) {
        return this.quote(tid);
    }

    private static /* synthetic */ void lambda$execute$5(List tableIds, List tableIdsSorted, Pattern pattern) {
        List<TableId> tablesMatchedByPattern = tableIds.stream().filter(t -> pattern.asPredicate().test(t.toString())).collect(Collectors.toList());
        tablesMatchedByPattern.forEach(t -> {
            if (!tableIdsSorted.contains(t)) {
                tableIdsSorted.add(t);
            }
        });
    }

    private /* synthetic */ void lambda$execute$2(String dbName, Filters createTableFilters, Map createTablesMap, Filters filters, List tableIds, ResultSet rs) throws SQLException {
        while (rs.next() && this.isRunning()) {
            TableId id = new TableId(dbName, null, rs.getString(1));
            if (createTableFilters.tableFilter().test(id)) {
                createTablesMap.computeIfAbsent(dbName, k -> new ArrayList()).add(id);
            }
            if (filters.tableFilter().test(id)) {
                tableIds.add(id);
                this.logger.info("\t including '{}'", (Object)id);
                continue;
            }
            this.logger.info("\t '{}' is filtered out, discarding", (Object)id);
        }
    }

    private static /* synthetic */ void lambda$execute$0(List databaseNames, ResultSet rs) throws SQLException {
        while (rs.next()) {
            databaseNames.add(rs.getString(1));
        }
    }

    protected static interface RecordRecorder {
        public void recordRow(RecordMakers.RecordsForTable var1, Object[] var2, long var3) throws InterruptedException;
    }
}

