/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.time;

import io.debezium.time.Conversions;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjuster;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class NanoTime {
    public static final String SCHEMA_NAME = "io.debezium.time.NanoTime";

    public static SchemaBuilder builder() {
        return SchemaBuilder.int64().name(SCHEMA_NAME).version(1);
    }

    public static Schema schema() {
        return NanoTime.builder().build();
    }

    public static long toNanoOfDay(Object value, TemporalAdjuster adjuster) {
        LocalTime time = Conversions.toLocalTime(value);
        if (adjuster != null) {
            time = time.with(adjuster);
        }
        return time.toNanoOfDay();
    }

    private NanoTime() {
    }
}

