/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.io.cdc.source.listening;

import io.siddhi.extension.io.cdc.source.CDCSource;
import io.siddhi.extension.io.cdc.source.listening.CDCSourceObjectKeeper;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.storage.MemoryOffsetBackingStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryOffsetBackingStore
extends MemoryOffsetBackingStore {
    private static final Logger log = LoggerFactory.getLogger(InMemoryOffsetBackingStore.class);
    private CDCSource cdcSource = null;
    private Map<byte[], byte[]> inMemoryOffsetCache = new HashMap<byte[], byte[]>();

    @Override
    public void configure(WorkerConfig config) {
        super.configure(config);
        int cdcSourceObjectId = Integer.parseInt((String)config.originals().get("cdc.source.object"));
        this.cdcSource = CDCSourceObjectKeeper.getCdcSourceObjectKeeper().getCdcObject(cdcSourceObjectId);
    }

    @Override
    public void start() {
        super.start();
        log.debug("Started InMemoryOffsetBackingStore");
        this.inMemoryOffsetCache = this.cdcSource.getOffsetData();
        try {
            this.data = new HashMap();
            Iterator<Map.Entry<byte[], byte[]>> iterator = this.inMemoryOffsetCache.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<byte[], byte[]> cacheEntrySet;
                Map.Entry<byte[], byte[]> mapEntry = cacheEntrySet = iterator.next();
                ByteBuffer key = ByteBuffer.wrap(mapEntry.getKey());
                ByteBuffer value = ByteBuffer.wrap(mapEntry.getValue());
                this.data.put(key, value);
            }
        }
        catch (Exception ex) {
            log.error("Error loading the in-memory offsets.", (Throwable)ex);
        }
    }

    @Override
    public void stop() {
        super.stop();
        log.debug("Stopped InMemoryOffsetBackingStore");
    }

    @Override
    protected void save() {
        try {
            Iterator iterator = this.data.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry dataEntrySet;
                Map.Entry mapEntry = dataEntrySet = iterator.next();
                byte[] key = ((ByteBuffer)mapEntry.getKey()).array();
                byte[] value = ((ByteBuffer)mapEntry.getValue()).array();
                this.inMemoryOffsetCache.put(key, value);
            }
            this.cdcSource.setOffsetData(this.inMemoryOffsetCache);
        }
        catch (Exception ex) {
            log.error("Error loading the in-memory offsets.", (Throwable)ex);
        }
    }
}

