/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigTransformer;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.errors.NotFoundException;
import org.apache.kafka.connect.runtime.AbstractStatus;
import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.kafka.connect.runtime.ConnectorStatus;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.SinkConnectorConfig;
import org.apache.kafka.connect.runtime.SourceConnectorConfig;
import org.apache.kafka.connect.runtime.TargetState;
import org.apache.kafka.connect.runtime.TaskStatus;
import org.apache.kafka.connect.runtime.Worker;
import org.apache.kafka.connect.runtime.distributed.ClusterConfigState;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.runtime.rest.entities.ConfigInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConfigInfos;
import org.apache.kafka.connect.runtime.rest.entities.ConfigKeyInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConfigValueInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorStateInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorType;
import org.apache.kafka.connect.runtime.rest.errors.BadRequestException;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.storage.ConfigBackingStore;
import org.apache.kafka.connect.storage.StatusBackingStore;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectorTaskId;

public abstract class AbstractHerder
implements Herder,
TaskStatus.Listener,
ConnectorStatus.Listener {
    private final String workerId;
    protected final Worker worker;
    private final String kafkaClusterId;
    protected final StatusBackingStore statusBackingStore;
    protected final ConfigBackingStore configBackingStore;
    private Map<String, Connector> tempConnectors = new ConcurrentHashMap<String, Connector>();

    public AbstractHerder(Worker worker, String workerId, String kafkaClusterId, StatusBackingStore statusBackingStore, ConfigBackingStore configBackingStore) {
        this.worker = worker;
        this.worker.herder = this;
        this.workerId = workerId;
        this.kafkaClusterId = kafkaClusterId;
        this.statusBackingStore = statusBackingStore;
        this.configBackingStore = configBackingStore;
    }

    @Override
    public String kafkaClusterId() {
        return this.kafkaClusterId;
    }

    protected abstract int generation();

    protected void startServices() {
        this.worker.start();
        this.statusBackingStore.start();
        this.configBackingStore.start();
    }

    protected void stopServices() {
        this.statusBackingStore.stop();
        this.configBackingStore.stop();
        this.worker.stop();
    }

    @Override
    public void onStartup(String connector) {
        this.statusBackingStore.put(new ConnectorStatus(connector, AbstractStatus.State.RUNNING, this.workerId, this.generation()));
    }

    @Override
    public void onPause(String connector) {
        this.statusBackingStore.put(new ConnectorStatus(connector, AbstractStatus.State.PAUSED, this.workerId, this.generation()));
    }

    @Override
    public void onResume(String connector) {
        this.statusBackingStore.put(new ConnectorStatus(connector, AbstractStatus.State.RUNNING, this.workerId, this.generation()));
    }

    @Override
    public void onShutdown(String connector) {
        this.statusBackingStore.putSafe(new ConnectorStatus(connector, AbstractStatus.State.UNASSIGNED, this.workerId, this.generation()));
    }

    @Override
    public void onFailure(String connector, Throwable cause) {
        this.statusBackingStore.putSafe(new ConnectorStatus(connector, AbstractStatus.State.FAILED, this.trace(cause), this.workerId, this.generation()));
    }

    @Override
    public void onStartup(ConnectorTaskId id) {
        this.statusBackingStore.put(new TaskStatus(id, AbstractStatus.State.RUNNING, this.workerId, this.generation()));
    }

    @Override
    public void onFailure(ConnectorTaskId id, Throwable cause) {
        this.statusBackingStore.putSafe(new TaskStatus(id, AbstractStatus.State.FAILED, this.workerId, this.generation(), this.trace(cause)));
    }

    @Override
    public void onShutdown(ConnectorTaskId id) {
        this.statusBackingStore.putSafe(new TaskStatus(id, AbstractStatus.State.UNASSIGNED, this.workerId, this.generation()));
    }

    @Override
    public void onResume(ConnectorTaskId id) {
        this.statusBackingStore.put(new TaskStatus(id, AbstractStatus.State.RUNNING, this.workerId, this.generation()));
    }

    @Override
    public void onPause(ConnectorTaskId id) {
        this.statusBackingStore.put(new TaskStatus(id, AbstractStatus.State.PAUSED, this.workerId, this.generation()));
    }

    @Override
    public void onDeletion(String connector) {
        for (TaskStatus status : this.statusBackingStore.getAll(connector)) {
            this.statusBackingStore.put(new TaskStatus((ConnectorTaskId)status.id(), AbstractStatus.State.DESTROYED, this.workerId, this.generation()));
        }
        this.statusBackingStore.put(new ConnectorStatus(connector, AbstractStatus.State.DESTROYED, this.workerId, this.generation()));
    }

    @Override
    public void pauseConnector(String connector) {
        if (!this.configBackingStore.contains(connector)) {
            throw new NotFoundException("Unknown connector " + connector);
        }
        this.configBackingStore.putTargetState(connector, TargetState.PAUSED);
    }

    @Override
    public void resumeConnector(String connector) {
        if (!this.configBackingStore.contains(connector)) {
            throw new NotFoundException("Unknown connector " + connector);
        }
        this.configBackingStore.putTargetState(connector, TargetState.STARTED);
    }

    @Override
    public Plugins plugins() {
        return this.worker.getPlugins();
    }

    protected abstract Map<String, String> config(String var1);

    @Override
    public ConnectorStateInfo connectorStatus(String connName) {
        ConnectorStatus connector = this.statusBackingStore.get(connName);
        if (connector == null) {
            throw new NotFoundException("No status found for connector " + connName);
        }
        Collection<TaskStatus> tasks = this.statusBackingStore.getAll(connName);
        ConnectorStateInfo.ConnectorState connectorState = new ConnectorStateInfo.ConnectorState(connector.state().toString(), connector.workerId(), connector.trace());
        ArrayList<ConnectorStateInfo.TaskState> taskStates = new ArrayList<ConnectorStateInfo.TaskState>();
        for (TaskStatus status : tasks) {
            taskStates.add(new ConnectorStateInfo.TaskState(((ConnectorTaskId)status.id()).task(), status.state().toString(), status.workerId(), status.trace()));
        }
        Collections.sort(taskStates);
        Map<String, String> conf = this.config(connName);
        return new ConnectorStateInfo(connName, connectorState, taskStates, conf == null ? ConnectorType.UNKNOWN : this.connectorTypeForClass(conf.get("connector.class")));
    }

    @Override
    public ConnectorStateInfo.TaskState taskStatus(ConnectorTaskId id) {
        TaskStatus status = this.statusBackingStore.get(id);
        if (status == null) {
            throw new NotFoundException("No status found for task " + id);
        }
        return new ConnectorStateInfo.TaskState(id.task(), status.state().toString(), status.workerId(), status.trace());
    }

    protected Map<String, ConfigValue> validateBasicConnectorConfig(Connector connector, ConfigDef configDef, Map<String, String> config) {
        return configDef.validateAll(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigInfos validateConnectorConfig(Map<String, String> connectorProps) {
        String connType;
        if (this.worker.configTransformer() != null) {
            connectorProps = this.worker.configTransformer().transform(connectorProps);
        }
        if ((connType = connectorProps.get("connector.class")) == null) {
            throw new BadRequestException("Connector config " + connectorProps + " contains no connector type");
        }
        Connector connector = this.getConnector(connType);
        ClassLoader savedLoader = this.plugins().compareAndSwapLoaders(connector);
        try {
            ConfigDef baseConfigDef;
            if (connector instanceof SourceConnector) {
                baseConfigDef = SourceConnectorConfig.configDef();
            } else {
                baseConfigDef = SinkConnectorConfig.configDef();
                SinkConnectorConfig.validate(connectorProps);
            }
            ConfigDef enrichedConfigDef = ConnectorConfig.enrich(this.plugins(), baseConfigDef, connectorProps, false);
            Map<String, ConfigValue> validatedConnectorConfig = this.validateBasicConnectorConfig(connector, enrichedConfigDef, connectorProps);
            ArrayList<ConfigValue> configValues = new ArrayList<ConfigValue>(validatedConnectorConfig.values());
            LinkedHashMap<String, ConfigDef.ConfigKey> configKeys = new LinkedHashMap<String, ConfigDef.ConfigKey>(enrichedConfigDef.configKeys());
            LinkedHashSet<String> allGroups = new LinkedHashSet<String>(enrichedConfigDef.groups());
            Config config = connector.validate(connectorProps);
            if (null == config) {
                throw new BadRequestException(String.format("%s.validate() must return a Config that is not null.", connector.getClass().getName()));
            }
            ConfigDef configDef = connector.config();
            if (null == configDef) {
                throw new BadRequestException(String.format("%s.config() must return a ConfigDef that is not null.", connector.getClass().getName()));
            }
            configKeys.putAll(configDef.configKeys());
            allGroups.addAll(configDef.groups());
            configValues.addAll(config.configValues());
            ConfigInfos configInfos = AbstractHerder.generateResult(connType, configKeys, configValues, new ArrayList<String>(allGroups));
            return configInfos;
        }
        finally {
            Plugins.compareAndSwapLoaders(savedLoader);
        }
    }

    public static ConfigInfos generateResult(String connType, Map<String, ConfigDef.ConfigKey> configKeys, List<ConfigValue> configValues, List<String> groups) {
        String configName;
        int errorCount = 0;
        LinkedList<ConfigInfo> configInfoList = new LinkedList<ConfigInfo>();
        HashMap<String, ConfigValue> configValueMap = new HashMap<String, ConfigValue>();
        for (ConfigValue configValue : configValues) {
            configName = configValue.name();
            configValueMap.put(configName, configValue);
            if (configKeys.containsKey(configName)) continue;
            configValue.addErrorMessage("Configuration is not defined: " + configName);
            configInfoList.add(new ConfigInfo(null, AbstractHerder.convertConfigValue(configValue, null)));
        }
        for (Map.Entry entry : configKeys.entrySet()) {
            configName = (String)entry.getKey();
            ConfigKeyInfo configKeyInfo = AbstractHerder.convertConfigKey((ConfigDef.ConfigKey)entry.getValue());
            ConfigDef.Type type = ((ConfigDef.ConfigKey)entry.getValue()).type;
            ConfigValueInfo configValueInfo = null;
            if (configValueMap.containsKey(configName)) {
                ConfigValue configValue = (ConfigValue)configValueMap.get(configName);
                configValueInfo = AbstractHerder.convertConfigValue(configValue, type);
                errorCount += configValue.errorMessages().size();
            }
            configInfoList.add(new ConfigInfo(configKeyInfo, configValueInfo));
        }
        return new ConfigInfos(connType, errorCount, groups, configInfoList);
    }

    private static ConfigKeyInfo convertConfigKey(ConfigDef.ConfigKey configKey) {
        String defaultValue;
        String name = configKey.name;
        ConfigDef.Type type = configKey.type;
        String typeName = configKey.type.name();
        boolean required = false;
        if (ConfigDef.NO_DEFAULT_VALUE.equals(configKey.defaultValue)) {
            defaultValue = null;
            required = true;
        } else {
            defaultValue = ConfigDef.convertToString(configKey.defaultValue, type);
        }
        String importance = configKey.importance.name();
        String documentation = configKey.documentation;
        String group = configKey.group;
        int orderInGroup = configKey.orderInGroup;
        String width = configKey.width.name();
        String displayName = configKey.displayName;
        List<String> dependents = configKey.dependents;
        return new ConfigKeyInfo(name, typeName, required, defaultValue, importance, documentation, group, orderInGroup, width, displayName, dependents);
    }

    private static ConfigValueInfo convertConfigValue(ConfigValue configValue, ConfigDef.Type type) {
        String value = ConfigDef.convertToString(configValue.value(), type);
        LinkedList<String> recommendedValues = new LinkedList<String>();
        if (type == ConfigDef.Type.LIST) {
            for (Object object : configValue.recommendedValues()) {
                recommendedValues.add(ConfigDef.convertToString(object, ConfigDef.Type.STRING));
            }
        } else {
            for (Object object : configValue.recommendedValues()) {
                recommendedValues.add(ConfigDef.convertToString(object, type));
            }
        }
        return new ConfigValueInfo(configValue.name(), value, recommendedValues, configValue.errorMessages(), configValue.visible());
    }

    protected Connector getConnector(String connType) {
        if (this.tempConnectors.containsKey(connType)) {
            return this.tempConnectors.get(connType);
        }
        Connector connector = this.plugins().newConnector(connType);
        this.tempConnectors.put(connType, connector);
        return connector;
    }

    public ConnectorType connectorTypeForClass(String connClass) {
        return ConnectorType.from(this.getConnector(connClass).getClass());
    }

    protected final boolean maybeAddConfigErrors(ConfigInfos configInfos, Callback<Herder.Created<ConnectorInfo>> callback) {
        boolean hasErrors;
        int errors = configInfos.errorCount();
        boolean bl = hasErrors = errors > 0;
        if (hasErrors) {
            StringBuilder messages = new StringBuilder();
            messages.append("Connector configuration is invalid and contains the following ").append(errors).append(" error(s):");
            for (ConfigInfo configInfo : configInfos.values()) {
                for (String msg : configInfo.configValue().errors()) {
                    messages.append('\n').append(msg);
                }
            }
            callback.onCompletion(new BadRequestException(messages.append("\nYou can also find the above list of errors at the endpoint `/{connectorType}/config/validate`").toString()), null);
        }
        return hasErrors;
    }

    private String trace(Throwable t) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            t.printStackTrace(new PrintStream((OutputStream)output, false, StandardCharsets.UTF_8.name()));
            return output.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static List<Map<String, String>> reverseTransform(String connName, ClusterConfigState configState, List<Map<String, String>> configs) {
        Map<String, String> rawConnConfig = configState.rawConnectorConfig(connName);
        Set<String> connKeysWithVariableValues = AbstractHerder.keysWithVariableValues(rawConnConfig, ConfigTransformer.DEFAULT_PATTERN);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (Map<String, String> config : configs) {
            HashMap<String, String> newConfig = new HashMap<String, String>(config);
            for (String key : connKeysWithVariableValues) {
                if (!newConfig.containsKey(key)) continue;
                newConfig.put(key, rawConnConfig.get(key));
            }
            result.add(newConfig);
        }
        return result;
    }

    private static Set<String> keysWithVariableValues(Map<String, String> rawConfig, Pattern pattern) {
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<String, String> config : rawConfig.entrySet()) {
            Matcher matcher;
            if (config.getValue() == null || !(matcher = pattern.matcher(config.getValue())).matches()) continue;
            keys.add(config.getKey());
        }
        return keys;
    }
}

