/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.distributed;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.connect.util.ConnectorTaskId;

public class ConnectProtocol {
    public static final String VERSION_KEY_NAME = "version";
    public static final String URL_KEY_NAME = "url";
    public static final String CONFIG_OFFSET_KEY_NAME = "config-offset";
    public static final String CONNECTOR_KEY_NAME = "connector";
    public static final String LEADER_KEY_NAME = "leader";
    public static final String LEADER_URL_KEY_NAME = "leader-url";
    public static final String ERROR_KEY_NAME = "error";
    public static final String TASKS_KEY_NAME = "tasks";
    public static final String ASSIGNMENT_KEY_NAME = "assignment";
    public static final int CONNECTOR_TASK = -1;
    public static final short CONNECT_PROTOCOL_V0 = 0;
    public static final Schema CONNECT_PROTOCOL_HEADER_SCHEMA = new Schema(new Field("version", Type.INT16));
    private static final Struct CONNECT_PROTOCOL_HEADER_V0 = new Struct(CONNECT_PROTOCOL_HEADER_SCHEMA).set("version", (Object)0);
    public static final Schema CONFIG_STATE_V0 = new Schema(new Field("url", Type.STRING), new Field("config-offset", Type.INT64));
    public static final Schema CONNECTOR_ASSIGNMENT_V0 = new Schema(new Field("connector", Type.STRING), new Field("tasks", new ArrayOf(Type.INT32)));
    public static final Schema ASSIGNMENT_V0 = new Schema(new Field("error", Type.INT16), new Field("leader", Type.STRING), new Field("leader-url", Type.STRING), new Field("config-offset", Type.INT64), new Field("assignment", new ArrayOf(CONNECTOR_ASSIGNMENT_V0)));

    public static ByteBuffer serializeMetadata(WorkerState workerState) {
        Struct struct = new Struct(CONFIG_STATE_V0);
        struct.set(URL_KEY_NAME, (Object)workerState.url());
        struct.set(CONFIG_OFFSET_KEY_NAME, (Object)workerState.offset());
        ByteBuffer buffer = ByteBuffer.allocate(CONNECT_PROTOCOL_HEADER_V0.sizeOf() + CONFIG_STATE_V0.sizeOf(struct));
        CONNECT_PROTOCOL_HEADER_V0.writeTo(buffer);
        CONFIG_STATE_V0.write(buffer, struct);
        buffer.flip();
        return buffer;
    }

    public static WorkerState deserializeMetadata(ByteBuffer buffer) {
        Struct header = CONNECT_PROTOCOL_HEADER_SCHEMA.read(buffer);
        Short version = header.getShort(VERSION_KEY_NAME);
        ConnectProtocol.checkVersionCompatibility(version);
        Struct struct = CONFIG_STATE_V0.read(buffer);
        long configOffset = struct.getLong(CONFIG_OFFSET_KEY_NAME);
        String url = struct.getString(URL_KEY_NAME);
        return new WorkerState(url, configOffset);
    }

    public static ByteBuffer serializeAssignment(Assignment assignment) {
        Struct struct = new Struct(ASSIGNMENT_V0);
        struct.set(ERROR_KEY_NAME, (Object)assignment.error());
        struct.set(LEADER_KEY_NAME, (Object)assignment.leader());
        struct.set(LEADER_URL_KEY_NAME, (Object)assignment.leaderUrl());
        struct.set(CONFIG_OFFSET_KEY_NAME, (Object)assignment.offset());
        ArrayList<Struct> taskAssignments = new ArrayList<Struct>();
        for (Map.Entry connectorEntry : assignment.asMap().entrySet()) {
            Struct taskAssignment = new Struct(CONNECTOR_ASSIGNMENT_V0);
            taskAssignment.set(CONNECTOR_KEY_NAME, connectorEntry.getKey());
            List tasks = (List)connectorEntry.getValue();
            taskAssignment.set(TASKS_KEY_NAME, (Object)tasks.toArray());
            taskAssignments.add(taskAssignment);
        }
        struct.set(ASSIGNMENT_KEY_NAME, (Object)taskAssignments.toArray());
        ByteBuffer buffer = ByteBuffer.allocate(CONNECT_PROTOCOL_HEADER_V0.sizeOf() + ASSIGNMENT_V0.sizeOf(struct));
        CONNECT_PROTOCOL_HEADER_V0.writeTo(buffer);
        ASSIGNMENT_V0.write(buffer, struct);
        buffer.flip();
        return buffer;
    }

    public static Assignment deserializeAssignment(ByteBuffer buffer) {
        Struct header = CONNECT_PROTOCOL_HEADER_SCHEMA.read(buffer);
        Short version = header.getShort(VERSION_KEY_NAME);
        ConnectProtocol.checkVersionCompatibility(version);
        Struct struct = ASSIGNMENT_V0.read(buffer);
        short error = struct.getShort(ERROR_KEY_NAME);
        String leader = struct.getString(LEADER_KEY_NAME);
        String leaderUrl = struct.getString(LEADER_URL_KEY_NAME);
        long offset = struct.getLong(CONFIG_OFFSET_KEY_NAME);
        ArrayList<String> connectorIds = new ArrayList<String>();
        ArrayList<ConnectorTaskId> taskIds = new ArrayList<ConnectorTaskId>();
        for (Object structObj : struct.getArray(ASSIGNMENT_KEY_NAME)) {
            Struct assignment = (Struct)structObj;
            String connector = assignment.getString(CONNECTOR_KEY_NAME);
            for (Object taskIdObj : assignment.getArray(TASKS_KEY_NAME)) {
                Integer taskId = (Integer)taskIdObj;
                if (taskId == -1) {
                    connectorIds.add(connector);
                    continue;
                }
                taskIds.add(new ConnectorTaskId(connector, taskId));
            }
        }
        return new Assignment(error, leader, leaderUrl, offset, connectorIds, taskIds);
    }

    private static void checkVersionCompatibility(short version) {
        if (version < 0) {
            throw new SchemaException("Unsupported subscription version: " + version);
        }
    }

    public static class Assignment {
        public static final short NO_ERROR = 0;
        public static final short CONFIG_MISMATCH = 1;
        private final short error;
        private final String leader;
        private final String leaderUrl;
        private final long offset;
        private final List<String> connectorIds;
        private final List<ConnectorTaskId> taskIds;

        public Assignment(short error, String leader, String leaderUrl, long configOffset, List<String> connectorIds, List<ConnectorTaskId> taskIds) {
            this.error = error;
            this.leader = leader;
            this.leaderUrl = leaderUrl;
            this.offset = configOffset;
            this.taskIds = taskIds;
            this.connectorIds = connectorIds;
        }

        public short error() {
            return this.error;
        }

        public String leader() {
            return this.leader;
        }

        public String leaderUrl() {
            return this.leaderUrl;
        }

        public boolean failed() {
            return this.error != 0;
        }

        public long offset() {
            return this.offset;
        }

        public List<String> connectors() {
            return this.connectorIds;
        }

        public List<ConnectorTaskId> tasks() {
            return this.taskIds;
        }

        public String toString() {
            return "Assignment{error=" + this.error + ", leader='" + this.leader + '\'' + ", leaderUrl='" + this.leaderUrl + '\'' + ", offset=" + this.offset + ", connectorIds=" + this.connectorIds + ", taskIds=" + this.taskIds + '}';
        }

        private Map<String, List<Integer>> asMap() {
            LinkedHashMap<String, List<Integer>> taskMap = new LinkedHashMap<String, List<Integer>>();
            for (String connectorId : new HashSet<String>(this.connectorIds)) {
                ArrayList<Integer> connectorTasks = (ArrayList<Integer>)taskMap.get(connectorId);
                if (connectorTasks == null) {
                    connectorTasks = new ArrayList<Integer>();
                    taskMap.put(connectorId, connectorTasks);
                }
                connectorTasks.add(-1);
            }
            for (ConnectorTaskId taskId : this.taskIds) {
                String connectorId = taskId.connector();
                ArrayList<Integer> connectorTasks = (ArrayList<Integer>)taskMap.get(connectorId);
                if (connectorTasks == null) {
                    connectorTasks = new ArrayList<Integer>();
                    taskMap.put(connectorId, connectorTasks);
                }
                connectorTasks.add(taskId.task());
            }
            return taskMap;
        }
    }

    public static class WorkerState {
        private final String url;
        private final long offset;

        public WorkerState(String url, long offset) {
            this.url = url;
            this.offset = offset;
        }

        public String url() {
            return this.url;
        }

        public long offset() {
            return this.offset;
        }

        public String toString() {
            return "WorkerState{url='" + this.url + '\'' + ", offset=" + this.offset + '}';
        }
    }
}

