/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.distributed;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.internals.AbstractCoordinator;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.utils.CircularIterator;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.connect.runtime.distributed.ClusterConfigState;
import org.apache.kafka.connect.runtime.distributed.ConnectProtocol;
import org.apache.kafka.connect.runtime.distributed.WorkerRebalanceListener;
import org.apache.kafka.connect.storage.ConfigBackingStore;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.slf4j.Logger;

public final class WorkerCoordinator
extends AbstractCoordinator
implements Closeable {
    public static final String DEFAULT_SUBPROTOCOL = "default";
    private final Logger log;
    private final String restUrl;
    private final ConfigBackingStore configStorage;
    private ConnectProtocol.Assignment assignmentSnapshot;
    private ClusterConfigState configSnapshot;
    private final WorkerRebalanceListener listener;
    private LeaderState leaderState;
    private boolean rejoinRequested;

    public WorkerCoordinator(LogContext logContext, ConsumerNetworkClient client, String groupId, int rebalanceTimeoutMs, int sessionTimeoutMs, int heartbeatIntervalMs, Metrics metrics, String metricGrpPrefix, Time time, long retryBackoffMs, String restUrl, ConfigBackingStore configStorage, WorkerRebalanceListener listener) {
        super(logContext, client, groupId, rebalanceTimeoutMs, sessionTimeoutMs, heartbeatIntervalMs, metrics, metricGrpPrefix, time, retryBackoffMs, true);
        this.log = logContext.logger(WorkerCoordinator.class);
        this.restUrl = restUrl;
        this.configStorage = configStorage;
        this.assignmentSnapshot = null;
        new WorkerCoordinatorMetrics(metrics, metricGrpPrefix);
        this.listener = listener;
        this.rejoinRequested = false;
    }

    @Override
    public void requestRejoin() {
        this.rejoinRequested = true;
    }

    @Override
    public String protocolType() {
        return "connect";
    }

    @Override
    protected synchronized boolean ensureCoordinatorReady(Timer timer) {
        return super.ensureCoordinatorReady(timer);
    }

    public void poll(long timeout) {
        long elapsed;
        long remaining;
        long start;
        long now = start = this.time.milliseconds();
        do {
            if (this.coordinatorUnknown()) {
                this.ensureCoordinatorReady(this.time.timer(Long.MAX_VALUE));
                now = this.time.milliseconds();
            }
            if (this.rejoinNeededOrPending()) {
                this.ensureActiveGroup();
                now = this.time.milliseconds();
            }
            this.pollHeartbeat(now);
            elapsed = now - start;
            remaining = timeout - elapsed;
            long pollTimeout = Math.min(Math.max(0L, remaining), this.timeToNextHeartbeat(now));
            this.client.poll(this.time.timer(pollTimeout));
        } while ((remaining = timeout - (elapsed = (now = this.time.milliseconds()) - start)) > 0L);
    }

    @Override
    public List<JoinGroupRequest.ProtocolMetadata> metadata() {
        this.configSnapshot = this.configStorage.snapshot();
        ConnectProtocol.WorkerState workerState = new ConnectProtocol.WorkerState(this.restUrl, this.configSnapshot.offset());
        ByteBuffer metadata = ConnectProtocol.serializeMetadata(workerState);
        return Collections.singletonList(new JoinGroupRequest.ProtocolMetadata(DEFAULT_SUBPROTOCOL, metadata));
    }

    @Override
    protected void onJoinComplete(int generation, String memberId, String protocol, ByteBuffer memberAssignment) {
        this.assignmentSnapshot = ConnectProtocol.deserializeAssignment(memberAssignment);
        this.rejoinRequested = false;
        this.listener.onAssigned(this.assignmentSnapshot, generation);
    }

    @Override
    protected Map<String, ByteBuffer> performAssignment(String leaderId, String protocol, Map<String, ByteBuffer> allMemberMetadata) {
        this.log.debug("Performing task assignment");
        HashMap<String, ConnectProtocol.WorkerState> memberConfigs = new HashMap<String, ConnectProtocol.WorkerState>();
        for (Map.Entry<String, ByteBuffer> entry : allMemberMetadata.entrySet()) {
            memberConfigs.put(entry.getKey(), ConnectProtocol.deserializeMetadata(entry.getValue()));
        }
        long maxOffset = this.findMaxMemberConfigOffset(memberConfigs);
        Long leaderOffset = this.ensureLeaderConfig(maxOffset);
        if (leaderOffset == null) {
            return this.fillAssignmentsAndSerialize(memberConfigs.keySet(), (short)1, leaderId, ((ConnectProtocol.WorkerState)memberConfigs.get(leaderId)).url(), maxOffset, new HashMap<String, List<String>>(), new HashMap<String, List<ConnectorTaskId>>());
        }
        return this.performTaskAssignment(leaderId, leaderOffset, memberConfigs);
    }

    private long findMaxMemberConfigOffset(Map<String, ConnectProtocol.WorkerState> memberConfigs) {
        Long maxOffset = null;
        for (Map.Entry<String, ConnectProtocol.WorkerState> stateEntry : memberConfigs.entrySet()) {
            long memberRootOffset = stateEntry.getValue().offset();
            if (maxOffset == null) {
                maxOffset = memberRootOffset;
                continue;
            }
            maxOffset = Math.max(maxOffset, memberRootOffset);
        }
        this.log.debug("Max config offset root: {}, local snapshot config offsets root: {}", maxOffset, (Object)this.configSnapshot.offset());
        return maxOffset;
    }

    private Long ensureLeaderConfig(long maxOffset) {
        if (this.configSnapshot.offset() < maxOffset) {
            ClusterConfigState updatedSnapshot = this.configStorage.snapshot();
            if (updatedSnapshot.offset() < maxOffset) {
                this.log.info("Was selected to perform assignments, but do not have latest config found in sync request. Returning an empty configuration to trigger re-sync.");
                return null;
            }
            this.configSnapshot = updatedSnapshot;
            return this.configSnapshot.offset();
        }
        return maxOffset;
    }

    private Map<String, ByteBuffer> performTaskAssignment(String leaderId, long maxOffset, Map<String, ConnectProtocol.WorkerState> memberConfigs) {
        HashMap<String, List<String>> connectorAssignments = new HashMap<String, List<String>>();
        HashMap<String, List<ConnectorTaskId>> taskAssignments = new HashMap<String, List<ConnectorTaskId>>();
        List<String> connectorsSorted = WorkerCoordinator.sorted(this.configSnapshot.connectors());
        CircularIterator<String> memberIt = new CircularIterator<String>(WorkerCoordinator.sorted(memberConfigs.keySet()));
        for (String connectorId : connectorsSorted) {
            String connectorAssignedTo = memberIt.next();
            this.log.trace("Assigning connector {} to {}", (Object)connectorId, (Object)connectorAssignedTo);
            ArrayList<String> memberConnectors = (ArrayList<String>)connectorAssignments.get(connectorAssignedTo);
            if (memberConnectors == null) {
                memberConnectors = new ArrayList<String>();
                connectorAssignments.put(connectorAssignedTo, memberConnectors);
            }
            memberConnectors.add(connectorId);
        }
        for (String connectorId : connectorsSorted) {
            for (ConnectorTaskId taskId : WorkerCoordinator.sorted(this.configSnapshot.tasks(connectorId))) {
                String taskAssignedTo = memberIt.next();
                this.log.trace("Assigning task {} to {}", (Object)taskId, (Object)taskAssignedTo);
                ArrayList<ConnectorTaskId> memberTasks = (ArrayList<ConnectorTaskId>)taskAssignments.get(taskAssignedTo);
                if (memberTasks == null) {
                    memberTasks = new ArrayList<ConnectorTaskId>();
                    taskAssignments.put(taskAssignedTo, memberTasks);
                }
                memberTasks.add(taskId);
            }
        }
        this.leaderState = new LeaderState(memberConfigs, connectorAssignments, taskAssignments);
        return this.fillAssignmentsAndSerialize(memberConfigs.keySet(), (short)0, leaderId, memberConfigs.get(leaderId).url(), maxOffset, connectorAssignments, taskAssignments);
    }

    private Map<String, ByteBuffer> fillAssignmentsAndSerialize(Collection<String> members, short error, String leaderId, String leaderUrl, long maxOffset, Map<String, List<String>> connectorAssignments, Map<String, List<ConnectorTaskId>> taskAssignments) {
        HashMap<String, ByteBuffer> groupAssignment = new HashMap<String, ByteBuffer>();
        for (String member : members) {
            List<ConnectorTaskId> tasks;
            List<String> connectors = connectorAssignments.get(member);
            if (connectors == null) {
                connectors = Collections.emptyList();
            }
            if ((tasks = taskAssignments.get(member)) == null) {
                tasks = Collections.emptyList();
            }
            ConnectProtocol.Assignment assignment = new ConnectProtocol.Assignment(error, leaderId, leaderUrl, maxOffset, connectors, tasks);
            this.log.debug("Assignment: {} -> {}", (Object)member, (Object)assignment);
            groupAssignment.put(member, ConnectProtocol.serializeAssignment(assignment));
        }
        this.log.debug("Finished assignment");
        return groupAssignment;
    }

    @Override
    protected void onJoinPrepare(int generation, String memberId) {
        this.leaderState = null;
        this.log.debug("Revoking previous assignment {}", (Object)this.assignmentSnapshot);
        if (this.assignmentSnapshot != null && !this.assignmentSnapshot.failed()) {
            this.listener.onRevoked(this.assignmentSnapshot.leader(), this.assignmentSnapshot.connectors(), this.assignmentSnapshot.tasks());
        }
    }

    @Override
    protected boolean rejoinNeededOrPending() {
        return super.rejoinNeededOrPending() || this.assignmentSnapshot == null || this.assignmentSnapshot.failed() || this.rejoinRequested;
    }

    public String memberId() {
        AbstractCoordinator.Generation generation = this.generation();
        if (generation != null) {
            return generation.memberId;
        }
        return "";
    }

    private boolean isLeader() {
        return this.assignmentSnapshot != null && this.memberId().equals(this.assignmentSnapshot.leader());
    }

    public String ownerUrl(String connector) {
        if (this.rejoinNeededOrPending() || !this.isLeader()) {
            return null;
        }
        return this.leaderState.ownerUrl(connector);
    }

    public String ownerUrl(ConnectorTaskId task) {
        if (this.rejoinNeededOrPending() || !this.isLeader()) {
            return null;
        }
        return this.leaderState.ownerUrl(task);
    }

    private static <T extends Comparable<T>> List<T> sorted(Collection<T> members) {
        ArrayList<T> res = new ArrayList<T>(members);
        Collections.sort(res);
        return res;
    }

    private static <K, V> Map<V, K> invertAssignment(Map<K, List<V>> assignment) {
        HashMap<V, K> inverted = new HashMap<V, K>();
        for (Map.Entry<K, List<V>> assignmentEntry : assignment.entrySet()) {
            K key = assignmentEntry.getKey();
            for (V value : assignmentEntry.getValue()) {
                inverted.put(value, key);
            }
        }
        return inverted;
    }

    private static class LeaderState {
        private final Map<String, ConnectProtocol.WorkerState> allMembers;
        private final Map<String, String> connectorOwners;
        private final Map<ConnectorTaskId, String> taskOwners;

        public LeaderState(Map<String, ConnectProtocol.WorkerState> allMembers, Map<String, List<String>> connectorAssignment, Map<String, List<ConnectorTaskId>> taskAssignment) {
            this.allMembers = allMembers;
            this.connectorOwners = WorkerCoordinator.invertAssignment(connectorAssignment);
            this.taskOwners = WorkerCoordinator.invertAssignment(taskAssignment);
        }

        private String ownerUrl(ConnectorTaskId id) {
            String ownerId = this.taskOwners.get(id);
            if (ownerId == null) {
                return null;
            }
            return this.allMembers.get(ownerId).url();
        }

        private String ownerUrl(String connector) {
            String ownerId = this.connectorOwners.get(connector);
            if (ownerId == null) {
                return null;
            }
            return this.allMembers.get(ownerId).url();
        }
    }

    private class WorkerCoordinatorMetrics {
        public final String metricGrpName;

        public WorkerCoordinatorMetrics(Metrics metrics, String metricGrpPrefix) {
            this.metricGrpName = metricGrpPrefix + "-coordinator-metrics";
            Measurable numConnectors = new Measurable(){

                @Override
                public double measure(MetricConfig config, long now) {
                    return WorkerCoordinator.this.assignmentSnapshot.connectors().size();
                }
            };
            Measurable numTasks = new Measurable(){

                @Override
                public double measure(MetricConfig config, long now) {
                    return WorkerCoordinator.this.assignmentSnapshot.tasks().size();
                }
            };
            metrics.addMetric(metrics.metricName("assigned-connectors", this.metricGrpName, "The number of connector instances currently assigned to this consumer"), numConnectors);
            metrics.addMetric(metrics.metricName("assigned-tasks", this.metricGrpName, "The number of tasks currently assigned to this consumer"), numTasks);
        }
    }
}

