/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.antlr;

import io.debezium.antlr.AntlrDdlParserListener;
import io.debezium.antlr.CaseChangingCharStream;
import io.debezium.antlr.DataTypeResolver;
import io.debezium.antlr.ParsingErrorListener;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.AbstractDdlParser;
import io.debezium.text.MultipleParsingExceptions;
import io.debezium.text.ParsingException;
import java.util.Collection;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public abstract class AntlrDdlParser<L extends Lexer, P extends Parser>
extends AbstractDdlParser {
    private final boolean throwErrorsFromTreeWalk;
    private AntlrDdlParserListener antlrDdlParserListener;
    protected Tables databaseTables;
    protected DataTypeResolver dataTypeResolver;

    public AntlrDdlParser(boolean throwErrorsFromTreeWalk) {
        this(throwErrorsFromTreeWalk, false);
    }

    public AntlrDdlParser(boolean throwErrorsFromTreeWalk, boolean includeViews) {
        super(";", includeViews);
        this.throwErrorsFromTreeWalk = throwErrorsFromTreeWalk;
    }

    @Override
    public void parse(String ddlContent, Tables databaseTables) {
        this.databaseTables = databaseTables;
        CodePointCharStream ddlContentCharStream = CharStreams.fromString((String)ddlContent);
        L lexer = this.createNewLexerInstance(new CaseChangingCharStream((CharStream)ddlContentCharStream, this.isGrammarInUpperCase()));
        P parser = this.createNewParserInstance(new CommonTokenStream(lexer));
        this.dataTypeResolver = this.initializeDataTypeResolver();
        parser.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        ParsingErrorListener parsingErrorListener = new ParsingErrorListener(AbstractDdlParser::accumulateParsingFailure);
        parser.addErrorListener((ANTLRErrorListener)parsingErrorListener);
        ParseTree parseTree = this.parseTree(parser);
        if (parsingErrorListener.getErrors().isEmpty()) {
            this.antlrDdlParserListener = this.createParseTreeWalkerListener();
            if (this.antlrDdlParserListener != null) {
                ParseTreeWalker.DEFAULT.walk((ParseTreeListener)this.antlrDdlParserListener, parseTree);
                if (this.throwErrorsFromTreeWalk && !this.antlrDdlParserListener.getErrors().isEmpty()) {
                    this.throwParsingException(this.antlrDdlParserListener.getErrors());
                }
            }
        } else {
            this.throwParsingException(parsingErrorListener.getErrors());
        }
    }

    public Collection<ParsingException> getParsingExceptionsFromWalker() {
        return this.antlrDdlParserListener.getErrors();
    }

    protected abstract ParseTree parseTree(P var1);

    protected abstract AntlrDdlParserListener createParseTreeWalkerListener();

    protected abstract L createNewLexerInstance(CharStream var1);

    protected abstract P createNewParserInstance(CommonTokenStream var1);

    protected abstract boolean isGrammarInUpperCase();

    protected abstract DataTypeResolver initializeDataTypeResolver();

    public Tables databaseTables() {
        return this.databaseTables;
    }

    public DataTypeResolver dataTypeResolver() {
        return this.dataTypeResolver;
    }

    public static String getText(ParserRuleContext ctx) {
        return AntlrDdlParser.getText(ctx, ctx.start.getStartIndex(), ctx.stop.getStopIndex());
    }

    public static String getText(ParserRuleContext ctx, int start, int stop) {
        Interval interval = new Interval(start, stop);
        return ctx.start.getInputStream().getText(interval);
    }

    public boolean skipViews() {
        return this.skipViews;
    }

    public void signalSetVariable(String variableName, String variableValue, ParserRuleContext ctx) {
        this.signalSetVariable(variableName, variableValue, AntlrDdlParser.getText(ctx));
    }

    public void signalCreateDatabase(String databaseName, ParserRuleContext ctx) {
        this.signalCreateDatabase(databaseName, AntlrDdlParser.getText(ctx));
    }

    public void signalAlterDatabase(String databaseName, String previousDatabaseName, ParserRuleContext ctx) {
        this.signalAlterDatabase(databaseName, previousDatabaseName, AntlrDdlParser.getText(ctx));
    }

    public void signalDropDatabase(String databaseName, ParserRuleContext ctx) {
        this.signalDropDatabase(databaseName, AntlrDdlParser.getText(ctx));
    }

    public void signalCreateTable(TableId id, ParserRuleContext ctx) {
        this.signalCreateTable(id, AntlrDdlParser.getText(ctx));
    }

    public void signalAlterTable(TableId id, TableId previousId, ParserRuleContext ctx) {
        this.signalAlterTable(id, previousId, AntlrDdlParser.getText(ctx));
    }

    @Override
    public void signalDropTable(TableId id, String statement) {
        super.signalDropTable(id, statement);
    }

    public void signalDropTable(TableId id, ParserRuleContext ctx) {
        this.signalDropTable(id, AntlrDdlParser.getText(ctx));
    }

    public void signalTruncateTable(TableId id, ParserRuleContext ctx) {
        this.signalTruncateTable(id, AntlrDdlParser.getText(ctx));
    }

    public void signalCreateView(TableId id, ParserRuleContext ctx) {
        this.signalCreateView(id, AntlrDdlParser.getText(ctx));
    }

    public void signalAlterView(TableId id, TableId previousId, ParserRuleContext ctx) {
        this.signalAlterView(id, previousId, AntlrDdlParser.getText(ctx));
    }

    public void signalDropView(TableId id, ParserRuleContext ctx) {
        this.signalDropView(id, AntlrDdlParser.getText(ctx));
    }

    public void signalCreateIndex(String indexName, TableId id, ParserRuleContext ctx) {
        this.signalCreateIndex(indexName, id, AntlrDdlParser.getText(ctx));
    }

    public void signalDropIndex(String indexName, TableId id, ParserRuleContext ctx) {
        this.signalDropIndex(indexName, id, AntlrDdlParser.getText(ctx));
    }

    public void debugParsed(ParserRuleContext ctx) {
        this.debugParsed(AntlrDdlParser.getText(ctx));
    }

    public void debugSkipped(ParserRuleContext ctx) {
        this.debugSkipped(AntlrDdlParser.getText(ctx));
    }

    public String withoutQuotes(ParserRuleContext ctx) {
        return AntlrDdlParser.withoutQuotes(ctx.getText());
    }

    private void throwParsingException(Collection<ParsingException> errors) {
        if (errors.size() == 1) {
            throw errors.iterator().next();
        }
        throw new MultipleParsingExceptions(errors);
    }
}

