/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql;

import io.debezium.annotation.Immutable;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.relational.ColumnId;
import io.debezium.relational.Selectors;
import io.debezium.relational.TableId;
import io.debezium.util.Collect;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Immutable
public class Filters {
    protected static final Set<String> BUILT_IN_DB_NAMES = Collect.unmodifiableSet("mysql", "performance_schema", "sys", "information_schema");
    private final Predicate<String> dbFilter;
    private final Predicate<TableId> tableFilter;
    private final Predicate<String> isBuiltInDb;
    private final Predicate<TableId> isBuiltInTable;
    private final Predicate<ColumnId> columnFilter;

    protected static boolean isBuiltInDatabase(String databaseName) {
        return BUILT_IN_DB_NAMES.contains(databaseName.toLowerCase());
    }

    protected static boolean isBuiltInTable(TableId id) {
        return Filters.isBuiltInDatabase(id.catalog());
    }

    protected static boolean isNotBuiltInDatabase(String databaseName) {
        return !Filters.isBuiltInDatabase(databaseName);
    }

    protected static boolean isNotBuiltInTable(TableId id) {
        return !Filters.isBuiltInTable(id);
    }

    protected static List<TableId> withoutBuiltIns(Collection<TableId> tableIds) {
        return tableIds.stream().filter(Filters::isNotBuiltInTable).collect(Collectors.toList());
    }

    protected static List<String> withoutBuiltInDatabases(Collection<String> dbNames) {
        return dbNames.stream().filter(Filters::isNotBuiltInDatabase).collect(Collectors.toList());
    }

    private Filters(Predicate<String> dbFilter, Predicate<TableId> tableFilter, Predicate<String> isBuiltInDb, Predicate<TableId> isBuiltInTable, Predicate<ColumnId> columnFilter) {
        this.dbFilter = dbFilter;
        this.tableFilter = tableFilter;
        this.isBuiltInDb = isBuiltInDb;
        this.isBuiltInTable = isBuiltInTable;
        this.columnFilter = columnFilter;
    }

    public Predicate<String> databaseFilter() {
        return this.dbFilter;
    }

    public Predicate<TableId> tableFilter() {
        return this.tableFilter;
    }

    public Predicate<TableId> builtInTableFilter() {
        return this.isBuiltInTable;
    }

    public Predicate<String> builtInDatabaseFilter() {
        return this.isBuiltInDb;
    }

    public Predicate<ColumnId> columnFilter() {
        return this.columnFilter;
    }

    public static class Builder {
        private Predicate<String> dbFilter;
        private Predicate<TableId> tableFilter;
        private Predicate<String> isBuiltInDb = Filters::isBuiltInDatabase;
        private Predicate<TableId> isBuiltInTable = Filters::isBuiltInTable;
        private Predicate<ColumnId> columnFilter;
        private final Configuration config;

        public Builder(Configuration config) {
            this.config = config;
            this.setFiltersFromStrings(config.getString(MySqlConnectorConfig.DATABASE_WHITELIST), config.getString(MySqlConnectorConfig.DATABASE_BLACKLIST), config.getString(MySqlConnectorConfig.TABLE_WHITELIST), config.getString(MySqlConnectorConfig.TABLE_BLACKLIST));
            this.columnFilter = Selectors.excludeColumns(config.getString(MySqlConnectorConfig.COLUMN_BLACKLIST));
        }

        public Builder setFiltersFromOffsets(Map<String, ?> offsets) {
            this.setFiltersFromStrings((String)offsets.get("database_whitelist"), (String)offsets.get("database_blacklist"), (String)offsets.get("table_whitelist"), (String)offsets.get("table_blacklist"));
            return this;
        }

        private void setFiltersFromStrings(String dbWhitelist, String dbBlacklist, String tableWhitelist, String tableBlacklist) {
            Predicate<String> dbFilter = Selectors.databaseSelector().includeDatabases(dbWhitelist).excludeDatabases(dbBlacklist).build();
            Predicate<TableId> tableFilter = Selectors.tableSelector().includeDatabases(dbWhitelist).excludeDatabases(dbBlacklist).includeTables(tableWhitelist).excludeTables(tableBlacklist).build();
            if (this.config.getBoolean(MySqlConnectorConfig.TABLES_IGNORE_BUILTIN)) {
                this.tableFilter = tableFilter.and(this.isBuiltInTable.negate());
                this.dbFilter = dbFilter.and(this.isBuiltInDb.negate());
            } else {
                this.tableFilter = tableFilter;
                this.dbFilter = dbFilter;
            }
        }

        public Builder setFiltersFromFilters(Filters filters) {
            this.dbFilter = filters.dbFilter;
            this.tableFilter = filters.tableFilter;
            this.isBuiltInDb = filters.isBuiltInDb;
            this.isBuiltInTable = filters.isBuiltInTable;
            this.columnFilter = filters.columnFilter;
            return this;
        }

        public Builder excludeAllTables(Filters otherFilter) {
            this.excludeDatabases(otherFilter.dbFilter);
            this.excludeTables(otherFilter.tableFilter);
            return this;
        }

        public Builder excludeDatabases(Predicate<String> databases) {
            this.dbFilter = this.dbFilter.and(databases.negate());
            return this;
        }

        public Builder includeDatabases(Predicate<String> databases) {
            this.dbFilter = this.dbFilter.or(databases);
            return this;
        }

        public Builder excludeTables(Predicate<TableId> tables) {
            this.tableFilter = this.tableFilter.and(tables.negate());
            return this;
        }

        public Builder includeTables(Predicate<TableId> tables) {
            this.tableFilter = this.tableFilter.or(tables);
            return this;
        }

        public Filters build() {
            return new Filters(this.dbFilter, this.tableFilter, this.isBuiltInDb, this.isBuiltInTable, this.columnFilter);
        }
    }
}

