/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.antlr;

import io.debezium.antlr.AntlrDdlParser;
import io.debezium.antlr.AntlrDdlParserListener;
import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.mysql.MySqlSystemVariables;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.antlr.listener.MySqlAntlrDdlParserListener;
import io.debezium.ddl.parser.mysql.generated.MySqlLexer;
import io.debezium.ddl.parser.mysql.generated.MySqlParser;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.AbstractDdlParser;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySqlAntlrDdlParser
extends AntlrDdlParser<MySqlLexer, MySqlParser> {
    private final ConcurrentMap<String, String> charsetNameForDatabase = new ConcurrentHashMap<String, String>();
    private final MySqlValueConverters converters;
    private final Tables.TableFilter tableFilter;

    public MySqlAntlrDdlParser() {
        this(null, Tables.TableFilter.includeAll());
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters) {
        this(converters, Tables.TableFilter.includeAll());
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters, Tables.TableFilter tableFilter) {
        this(true, false, converters, tableFilter);
    }

    protected MySqlAntlrDdlParser(boolean throwErrorsFromTreeWalk, boolean includeViews, MySqlValueConverters converters, Tables.TableFilter tableFilter) {
        super(throwErrorsFromTreeWalk, includeViews);
        this.systemVariables = new MySqlSystemVariables();
        this.converters = converters;
        this.tableFilter = tableFilter;
    }

    @Override
    protected ParseTree parseTree(MySqlParser parser) {
        return parser.root();
    }

    @Override
    protected AntlrDdlParserListener createParseTreeWalkerListener() {
        return new MySqlAntlrDdlParserListener(this);
    }

    @Override
    protected MySqlLexer createNewLexerInstance(CharStream charStreams) {
        return new MySqlLexer(charStreams);
    }

    @Override
    protected MySqlParser createNewParserInstance(CommonTokenStream commonTokenStream) {
        return new MySqlParser((TokenStream)commonTokenStream);
    }

    @Override
    protected SystemVariables createNewSystemVariablesInstance() {
        return new MySqlSystemVariables();
    }

    @Override
    protected boolean isGrammarInUpperCase() {
        return true;
    }

    @Override
    protected DataTypeResolver initializeDataTypeResolver() {
        DataTypeResolver.Builder dataTypeResolverBuilder = new DataTypeResolver.Builder();
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.StringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, 192), new DataTypeResolver.DataTypeEntry(12, 193), new DataTypeResolver.DataTypeEntry(12, 202), new DataTypeResolver.DataTypeEntry(12, 203), new DataTypeResolver.DataTypeEntry(12, 204), new DataTypeResolver.DataTypeEntry(12, 205), new DataTypeResolver.DataTypeEntry(-15, 420), new DataTypeResolver.DataTypeEntry(-9, 194), new DataTypeResolver.DataTypeEntry(-2, 192, 196), new DataTypeResolver.DataTypeEntry(-2, 193, 196), new DataTypeResolver.DataTypeEntry(-2, 202, 196), new DataTypeResolver.DataTypeEntry(-2, 203, 196), new DataTypeResolver.DataTypeEntry(-2, 204, 196), new DataTypeResolver.DataTypeEntry(-2, 205, 196), new DataTypeResolver.DataTypeEntry(-2, 420, 196), new DataTypeResolver.DataTypeEntry(-2, 194, 196)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, 195, 193).setSuffixTokens(196), new DataTypeResolver.DataTypeEntry(-15, 195, 22).setSuffixTokens(196), new DataTypeResolver.DataTypeEntry(-9, 420, 193).setSuffixTokens(196)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalVaryingStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, 195, 192, 207), new DataTypeResolver.DataTypeEntry(-9, 195, 22, 207)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.DimensionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(5, 173).setSuffixTokens(494, 159, 172), new DataTypeResolver.DataTypeEntry(5, 174).setSuffixTokens(494, 159, 172), new DataTypeResolver.DataTypeEntry(4, 175).setSuffixTokens(494, 159, 172), new DataTypeResolver.DataTypeEntry(4, 176).setSuffixTokens(494, 159, 172), new DataTypeResolver.DataTypeEntry(4, 177).setSuffixTokens(494, 159, 172), new DataTypeResolver.DataTypeEntry(-5, 178).setSuffixTokens(494, 159, 172), new DataTypeResolver.DataTypeEntry(7, 179).setSuffixTokens(494, 159, 172), new DataTypeResolver.DataTypeEntry(8, 180).setSuffixTokens(181, 494, 159, 172), new DataTypeResolver.DataTypeEntry(6, 182).setSuffixTokens(494, 159, 172), new DataTypeResolver.DataTypeEntry(3, 183).setSuffixTokens(494, 159, 172).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, 184).setSuffixTokens(494, 159, 172).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, 185).setSuffixTokens(494, 159, 172).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(2, 186).setSuffixTokens(494, 159, 172).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(-7, 269), new DataTypeResolver.DataTypeEntry(92, 188), new DataTypeResolver.DataTypeEntry(2014, 189), new DataTypeResolver.DataTypeEntry(93, 190), new DataTypeResolver.DataTypeEntry(-2, 196), new DataTypeResolver.DataTypeEntry(-3, 197), new DataTypeResolver.DataTypeEntry(4, 191)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SimpleDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(91, 187), new DataTypeResolver.DataTypeEntry(2004, 198), new DataTypeResolver.DataTypeEntry(2004, 199), new DataTypeResolver.DataTypeEntry(2004, 200), new DataTypeResolver.DataTypeEntry(2004, 201), new DataTypeResolver.DataTypeEntry(16, 271), new DataTypeResolver.DataTypeEntry(16, 272), new DataTypeResolver.DataTypeEntry(-5, 208)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.CollectionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, 206).setSuffixTokens(196), new DataTypeResolver.DataTypeEntry(1, 133).setSuffixTokens(196)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SpatialDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1111, 634), new DataTypeResolver.DataTypeEntry(1111, 635), new DataTypeResolver.DataTypeEntry(1111, 637), new DataTypeResolver.DataTypeEntry(1111, 638), new DataTypeResolver.DataTypeEntry(1111, 639), new DataTypeResolver.DataTypeEntry(1111, 640), new DataTypeResolver.DataTypeEntry(1111, 641), new DataTypeResolver.DataTypeEntry(1111, 642), new DataTypeResolver.DataTypeEntry(1111, 371), new DataTypeResolver.DataTypeEntry(1111, 636)));
        return dataTypeResolverBuilder.build();
    }

    public ConcurrentMap<String, String> charsetNameForDatabase() {
        return this.charsetNameForDatabase;
    }

    public String parseName(MySqlParser.UidContext uidContext) {
        return this.withoutQuotes(uidContext);
    }

    public TableId parseQualifiedTableId(MySqlParser.FullIdContext fullIdContext) {
        String fullTableName = fullIdContext.getText();
        int dotIndex = fullTableName.indexOf(".");
        if (dotIndex > 0) {
            return this.resolveTableId(MySqlAntlrDdlParser.withoutQuotes(fullTableName.substring(0, dotIndex)), MySqlAntlrDdlParser.withoutQuotes(fullTableName.substring(dotIndex + 1, fullTableName.length())));
        }
        return this.resolveTableId(this.currentSchema(), MySqlAntlrDdlParser.withoutQuotes(fullTableName));
    }

    public void parsePrimaryIndexColumnNames(MySqlParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        List<String> pkColumnNames = indexColumnNamesContext.indexColumnName().stream().map(indexColumnNameContext -> {
            String columnName = indexColumnNameContext.uid() != null ? this.parseName(indexColumnNameContext.uid()) : MySqlAntlrDdlParser.withoutQuotes(indexColumnNameContext.STRING_LITERAL().getText());
            Column column = tableEditor.columnWithName(columnName);
            if (column != null && column.isOptional()) {
                ColumnEditor ce = column.edit().optional(false);
                if (ce.hasDefaultValue() && ce.defaultValue() == null) {
                    ce.unsetDefaultValue();
                }
                tableEditor.addColumn(ce.create());
            }
            return columnName;
        }).collect(Collectors.toList());
        tableEditor.setPrimaryKeyNames(pkColumnNames);
    }

    public String currentDatabaseCharset() {
        String charsetName = this.systemVariables.getVariable("character_set_database");
        if (charsetName == null || "DEFAULT".equalsIgnoreCase(charsetName)) {
            charsetName = this.systemVariables.getVariable("character_set_server");
        }
        return charsetName;
    }

    public void runIfNotNull(Runnable function, Object ... nullableObjects) {
        for (Object nullableObject : nullableObjects) {
            if (nullableObject != null) continue;
            return;
        }
        function.run();
    }

    public static List<String> extractEnumAndSetOptions(List<String> enumValues) {
        return enumValues.stream().map(AbstractDdlParser::withoutQuotes).map(MySqlAntlrDdlParser::escapeOption).collect(Collectors.toList());
    }

    public static String escapeOption(String option) {
        return option.replaceAll(",", "\\\\,").replaceAll("\\\\'", "'").replaceAll("''", "'");
    }

    public MySqlValueConverters getConverters() {
        return this.converters;
    }

    public Tables.TableFilter getTableFilter() {
        return this.tableFilter;
    }
}

