/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.postgresql.ChangeEvent;
import io.debezium.connector.postgresql.Module;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.PostgresTaskContext;
import io.debezium.connector.postgresql.PostgresTopicSelector;
import io.debezium.connector.postgresql.RecordsProducer;
import io.debezium.connector.postgresql.RecordsSnapshotProducer;
import io.debezium.connector.postgresql.RecordsStreamProducer;
import io.debezium.connector.postgresql.SourceInfo;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.spi.SlotState;
import io.debezium.connector.postgresql.spi.Snapshotter;
import io.debezium.relational.TableId;
import io.debezium.schema.TopicSelector;
import io.debezium.util.LoggingContext;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresConnectorTask
extends BaseSourceTask {
    private static final String CONTEXT_NAME = "postgres-connector-task";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean running = new AtomicBoolean(false);
    private PostgresTaskContext taskContext;
    private RecordsProducer producer;
    private volatile Long lastCompletelyProcessedLsn;
    private ChangeEventQueue<ChangeEvent> changeEventQueue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Configuration config) {
        Charset databaseCharset;
        TypeRegistry typeRegistry;
        if (this.running.get()) {
            return;
        }
        PostgresConnectorConfig connectorConfig = new PostgresConnectorConfig(config);
        try (PostgresConnection connection = new PostgresConnection(connectorConfig.jdbcConfig());){
            typeRegistry = connection.getTypeRegistry();
            databaseCharset = connection.getDatabaseCharset();
        }
        Snapshotter snapshotter = connectorConfig.getSnapshotter();
        if (snapshotter == null) {
            this.logger.error("Unable to load snapshotter, if using custom snapshot mode, double check your settings");
            throw new ConnectException("Unable to load snapshotter, if using custom snapshot mode, double check your settings");
        }
        TopicSelector<TableId> topicSelector = PostgresTopicSelector.create(connectorConfig);
        PostgresSchema schema = new PostgresSchema(connectorConfig, typeRegistry, databaseCharset, topicSelector);
        this.taskContext = new PostgresTaskContext(connectorConfig, schema, topicSelector);
        SourceInfo sourceInfo = new SourceInfo(connectorConfig.getLogicalName(), connectorConfig.databaseName());
        Map<String, Object> existingOffset = this.context.offsetStorageReader().offset(sourceInfo.partition());
        LoggingContext.PreviousContext previousContext = this.taskContext.configureLoggingContext(CONTEXT_NAME);
        try {
            SlotState slotInfo = null;
            try (PostgresConnection connection = this.taskContext.createConnection();){
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(connection.serverInfo().toString());
                }
                slotInfo = connection.getReplicationSlotInfo(connectorConfig.slotName(), connectorConfig.plugin().getPostgresPluginName());
            }
            catch (SQLException e) {
                this.logger.warn("unable to load info of replication slot, debezium will try to create the slot");
            }
            if (existingOffset == null) {
                this.logger.info("No previous offset found");
                snapshotter.init(connectorConfig, null, slotInfo);
            } else {
                this.logger.info("Found previous offset {}", (Object)sourceInfo);
                sourceInfo.load(existingOffset);
                snapshotter.init(connectorConfig, sourceInfo.asOffsetState(), slotInfo);
            }
            this.createRecordProducer(this.taskContext, sourceInfo, snapshotter);
            this.changeEventQueue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
            this.producer.start(this.changeEventQueue::enqueue, this.changeEventQueue::producerFailure);
            this.running.compareAndSet(false, true);
        }
        finally {
            previousContext.restore();
        }
    }

    private void createRecordProducer(PostgresTaskContext taskContext, SourceInfo sourceInfo, Snapshotter snapshotter) {
        if (snapshotter.shouldSnapshot()) {
            if (snapshotter.shouldStream()) {
                this.logger.info("Taking a new snapshot of the DB and streaming logical changes once the snapshot is finished...");
                this.producer = new RecordsSnapshotProducer(taskContext, sourceInfo, snapshotter);
            } else {
                this.logger.info("Taking only a snapshot of the DB without streaming any changes afterwards...");
                this.producer = new RecordsSnapshotProducer(taskContext, sourceInfo, snapshotter);
            }
        } else if (snapshotter.shouldStream()) {
            this.logger.info("Not attempting to take a snapshot, immediately starting to stream logical changes...");
            this.producer = new RecordsStreamProducer(taskContext, sourceInfo);
        } else {
            throw new ConnectException("Snapshotter neither is snapshotting or streaming, invalid!");
        }
    }

    @Override
    public void commit() throws InterruptedException {
        if (this.running.get() && this.lastCompletelyProcessedLsn != null) {
            this.producer.commit(this.lastCompletelyProcessedLsn);
        }
    }

    @Override
    public List<SourceRecord> poll() throws InterruptedException {
        List<ChangeEvent> events = this.changeEventQueue.poll();
        if (events.size() > 0) {
            this.lastCompletelyProcessedLsn = events.get(events.size() - 1).getLastCompletelyProcessedLsn();
        }
        return events.stream().map(ChangeEvent::getRecord).collect(Collectors.toList());
    }

    @Override
    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.producer.stop();
        }
    }

    @Override
    public String version() {
        return Module.version();
    }

    @Override
    protected Iterable<Field> getAllConfigurationFields() {
        return PostgresConnectorConfig.ALL_FIELDS;
    }
}

